/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.runner;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.security.SecureRandom;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import ru.bitel.bgbilling.client.runner.BGClientRunnerDbInfo;
import ru.bitel.bgbilling.client.runner.BGClientRunnerHostnameVerifier;
import ru.bitel.bgbilling.client.runner.BGClientRunnerTrustManager;
import ru.bitel.bgbilling.client.runner.json.JSONArray;
import ru.bitel.bgbilling.client.runner.json.JSONObject;

public class BGClientRunnerUtil {
    public static File getLocalSettingsFile() {
        return BGClientRunnerUtil.getLocalFile(System.getProperty("local.setting.file.name", "config"));
    }

    public static File getLocalSettingsDir() {
        String folderName = System.getProperty("local.setting.folder.name", ".bgbilling");
        File file = new File(System.getProperty("user.home") + File.separator + folderName);
        return file;
    }

    public static File getLocalFile(String fileName) {
        File result = null;
        try {
            File file = BGClientRunnerUtil.getLocalSettingsDir();
            if (!file.exists()) {
                file.mkdir();
            }
            if (file.isDirectory()) {
                if (!(file = new File(file.getAbsoluteFile() + File.separator + fileName)).exists()) {
                    file.createNewFile();
                }
                if (file.exists() && file.isFile()) {
                    result = file;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static File getUserFolderForFile(String fileName) {
        File file = new File(BGClientRunnerUtil.getLocalSettingsDir().getAbsolutePath() + File.separator + fileName);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static String loadDefaultConfig() throws Exception {
        String config = null;
        URL url = ClassLoader.getSystemResource("config.json");
        if (url != null) {
            config = BGClientRunnerUtil.loadConfig(new File(url.toURI()));
        }
        return config;
    }

    public static String loadDefaultHttpConfig(String configURL, String defaultConfigURL, boolean anySSL) throws Exception {
        String serverURL = configURL != null ? configURL : System.getProperty("default.config.url", defaultConfigURL);
        String config = null;
        if (!"none".equals(serverURL)) {
            config = BGClientRunnerUtil.doRequest(serverURL, null, "GET", null, anySSL);
        }
        return config;
    }

    public static String loadServersConfig() throws Exception {
        return BGClientRunnerUtil.loadConfig(BGClientRunnerUtil.getLocalFile("servers.json"));
    }

    public static String doRequest(String serverUrl, String[][] headers, String requestMethod, String outputText, boolean anySSL) throws Exception {
        HttpURLConnection urlConnection = BGClientRunnerUtil.getHttpURLConnection(serverUrl, headers, requestMethod, outputText, anySSL);
        String result = BGClientRunnerUtil.readInputStream(urlConnection.getInputStream());
        urlConnection.disconnect();
        return result;
    }

    public static HttpURLConnection getHttpURLConnection(String serverURL, String[][] headers, String requestMethod, String outputText, boolean anySSL) throws Exception {
        URL url = new URL(serverURL);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        BGClientRunnerUtil.ssl(urlConnection, url, anySSL);
        urlConnection.setConnectTimeout(3000);
        urlConnection.setRequestMethod(requestMethod);
        if (headers != null) {
            for (String[] header : headers) {
                if (header.length <= 1) continue;
                urlConnection.setRequestProperty(header[0], header[1]);
            }
        }
        urlConnection.setDoOutput(outputText != null);
        urlConnection.setDoInput(true);
        if (outputText != null) {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(urlConnection.getOutputStream()));
            bw.write(outputText.toCharArray());
            bw.close();
        }
        urlConnection.connect();
        return urlConnection;
    }

    private static void ssl(HttpURLConnection urlConnection, URL url, boolean anySSL) throws Exception {
        System.out.println("anySSL = " + anySSL + "; protocol = " + url.getProtocol());
        if (anySSL && "https".equalsIgnoreCase(url.getProtocol())) {
            SSLContext sslContext = SSLContext.getInstance(System.getProperty("version.tls", "TLSv1.2"));
            sslContext.init(new KeyManager[0], new TrustManager[]{new BGClientRunnerTrustManager()}, new SecureRandom());
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sslContext.getSocketFactory());
            ((HttpsURLConnection)urlConnection).setHostnameVerifier(new BGClientRunnerHostnameVerifier());
        }
    }

    public static String loadConfig(File file) throws Exception {
        String serversConfig = "";
        if (file != null && file.canRead()) {
            serversConfig = BGClientRunnerUtil.readInputStream(new FileInputStream(file));
        }
        return serversConfig;
    }

    public static String readInputStream(InputStream inputStream) throws Exception {
        StringBuffer serversConfig = new StringBuffer();
        if (inputStream != null) {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            char[] target = new char[1024];
            int bytes = 0;
            while ((bytes = inputStreamReader.read(target)) > -1) {
                serversConfig.append(target, 0, bytes);
            }
            inputStreamReader.close();
        }
        return serversConfig.toString();
    }

    public static void saveServersConfig(List<? extends BGClientRunnerDbInfo> serverList, String defaultServerKey, String serversListMode, boolean anySSL) {
        try {
            File file = BGClientRunnerUtil.getLocalFile("servers.json");
            if (file != null && file.canWrite()) {
                JSONObject serversJSONObject = new JSONObject();
                JSONObject paramJSONObject = new JSONObject();
                paramJSONObject.put("defaultServerKey", defaultServerKey);
                paramJSONObject.put("serversListMode", serversListMode);
                paramJSONObject.put("anySSL", String.valueOf(anySSL));
                serversJSONObject.put("param", paramJSONObject);
                JSONArray serversJSONArray = new JSONArray();
                for (BGClientRunnerDbInfo bGClientRunnerDbInfo : serverList) {
                    serversJSONArray.put(bGClientRunnerDbInfo.toJsonObject());
                }
                serversJSONObject.put("servers", serversJSONArray);
                BGClientRunnerUtil.saveFile(file, serversJSONObject.toString(2));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveFile(File file, String outText) throws Exception {
        OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        fileWriter.write(outText);
        fileWriter.flush();
        fileWriter.close();
    }

    public static boolean deleteDir(File dir) {
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (File f : contents) {
                if (Files.isSymbolicLink(f.toPath())) {
                    f.delete();
                    continue;
                }
                BGClientRunnerUtil.deleteDir(f);
            }
        }
        return dir.delete();
    }

    public static String checkUnsupportedClassVersionError(String message) {
        Pattern p = Pattern.compile("UnsupportedClassVersionError.+recent.+version\\s+(?<need>\\d+).+up\\s+to\\s+(?<has>\\d+)");
        Matcher m = p.matcher(message);
        if (m.find()) {
            try {
                int vneed = Integer.parseInt(m.group("need")) - 44;
                int vhas = Integer.parseInt(m.group("has")) - 44;
                return String.format("\u0414\u043b\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0430 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f Java %d, \u0430 \u0437\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0441\u044f \u043d\u0430 Java %d\n\n%s", vneed, vhas, message);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return message;
    }

    public static String randomAlphanumeric(int count) {
        StringBuilder result = new StringBuilder();
        if (count > 0) {
            String sym = "qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM0987654321";
            Random random = new Random();
            for (int index = 0; index < count; ++index) {
                result.append("qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM0987654321".charAt(random.nextInt("qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM0987654321".length())));
            }
        }
        return result.toString();
    }
}

