/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.groupaction.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.ListItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.admin.groupaction.client.ContractGroupOperation;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class UnblockLimit
extends ContractGroupOperation.ContractGroupOperationItem {
    private BGControlPanelListSelect groups;
    private JCheckBox showOnlyUsing = new JCheckBox("\u0422\u043e\u043b\u044c\u043a\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0435", false);
    private Document doc;

    public UnblockLimit() {
        super(new GridBagLayout());
    }

    @Override
    protected void jbInit() throws Exception {
        this.groups = new BGControlPanelListSelect();
        JPanel groupPanel = new JPanel(new GridBagLayout());
        groupPanel.setBorder(new BGTitleBorder(" \u041d\u0435 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u044c \u0440\u0430\u0437\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0443 \u0434\u043b\u044f \u0433\u0440\u0443\u043f\u043f "));
        groupPanel.setMinimumSize(new Dimension(180, 200));
        groupPanel.setPreferredSize(new Dimension(180, 200));
        groupPanel.add((Component)this.showOnlyUsing, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.showOnlyUsing.addActionListener(e -> {
            List<String> selectedItems = this.getSelectedIdList();
            this.getGroups(this.showOnlyUsing.isSelected());
            this.selectByIds(Utils.toString(selectedItems));
        });
        groupPanel.add((Component)this.groups, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.getTextArea("\u0418\u0437\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u0430 contract_limit_manage_mode"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)groupPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    @Override
    protected void setData() {
        this.getGroups(this.showOnlyUsing.isSelected());
    }

    @Override
    protected boolean doItemOperation(String cids) {
        ArrayList<CallSite> groupList = new ArrayList<CallSite>();
        DefaultListModel model = (DefaultListModel)this.groups.getList().getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ListItem item = (ListItem)model.elementAt(i);
            if (!item.isSelected()) continue;
            groupList.add((CallSite)((Object)("" + item.getAttribute("id"))));
        }
        Request request = new Request();
        request.setModule("contract");
        request.setAction("ContractGroupOperation");
        request.setAttribute("type", "unblockLimit");
        request.setAttribute("cids", cids);
        request.setAttribute("mids", Utils.toString(groupList));
        return ClientUtils.checkStatus(TransferManager.getDocument(request));
    }

    @Override
    protected String getOperationTitle() {
        return "\u0420\u0430\u0437\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0430 \u043b\u0438\u043c\u0438\u0442\u0430";
    }

    private void getDocument() {
        Request request = new Request();
        request.setModule("admin");
        request.setAction("GetContractGroupList");
        this.doc = TransferManager.getDocument(request);
    }

    private void getGroups(boolean enabled) {
        if (this.doc == null) {
            this.getDocument();
        }
        Element node = XMLUtils.selectElement(this.doc, "//table/data");
        if (this.groups.getList() == null) {
            return;
        }
        DefaultListModel<ListItem> model = this.groups.getListModel();
        if (node != null && node.hasChildNodes()) {
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Element item = (Element)list.item(i);
                if ("true".equals(XMLUtils.getAttribute(item, "f3", "false")) || enabled && !"true".equals(XMLUtils.getAttribute(item, "f1", "false"))) continue;
                ListItem listItem = new ListItem(XMLUtils.getAttribute(item, "f2", null), false);
                listItem.setAttribute("id", XMLUtils.getAttribute(item, "f0", null));
                model.addElement(listItem);
            }
        }
    }

    public List<String> getSelectedIdList() {
        return Utils.toList(this.groups.getListValues());
    }

    public void selectByIds(String sids) {
        this.groups.setListValues(sids);
    }
}

