/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.mail.client;

import bitel.billing.module.common.BGTextArea;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.admin.mail.common.bean.MailConfig;
import ru.bitel.bgbilling.kernel.admin.mail.common.dto.MailComponentDto;
import ru.bitel.bgbilling.kernel.admin.mail.common.dto.MailDto;
import ru.bitel.bgbilling.kernel.admin.mail.common.handler.MailConfigAbstractHandler;
import ru.bitel.bgbilling.kernel.admin.mail.common.handler.MailConfigHandler;
import ru.bitel.bgbilling.kernel.admin.mail.common.service.MailService;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicClassChooser;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;

public class MailLetterPanel
extends BGUPanel {
    private boolean initEditor = false;
    private MailConfig mailConfig = null;
    private ButtonGroup subjectButtonGroup;
    private ButtonGroup patternButtonGroup;
    private ButtonGroup handlerButtonGroup;
    private BGTextField subject;
    private JPanel editorPanel;
    private PatternPanel defaultPatternPanel;
    private PatternPanel customPatternPanel;
    private DynamicClassChooser defaultChooser;
    private DynamicClassChooser customChooser;
    private BGUList<MailComponentDto> componentList = new BGUList();
    private BGUList<MailDto> letterList = new BGUList();
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            try {
                MailLetterPanel.this.componentList.setData(((ClientContext)MailLetterPanel.this.getContext()).getWebService(MailService.class, 0).mailComponentList());
                MailLetterPanel.this.componentList.setSelectedIndex(0);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    };

    @Override
    protected void jbInit() throws Exception {
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, this.getLetterPanel(), (Component)this.getEditorPanel(), 400L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel getLetterPanel() {
        this.componentList.setSelectionMode(0);
        this.componentList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.setLetterList();
            }
        });
        this.letterList.setSelectionMode(0);
        this.letterList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    MailLetterPanel.this.showMailEditor();
                }
                super.mouseClicked(e);
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 8, 0, 3), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane(this.componentList, 300, 200), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 3, 5, 3), 0, 0));
        panel.add((Component)new JLabel("\u041f\u0438\u0441\u044c\u043c\u0430:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 8, 0, 3), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane(this.letterList, 300, 300), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getEditorPanel() {
        this.editorPanel = new JPanel(new CardLayout());
        this.editorPanel.add((Component)new JPanel(), "empty");
        return this.editorPanel;
    }

    private JPanel getMailEditorPanel() {
        BGButtonPanelOkCancel buttonPanelOkCancel = new BGButtonPanelOkCancel();
        buttonPanelOkCancel.addActionListener(e -> this.doButton(e.getActionCommand()));
        JLabel titleLabel = new JLabel("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043f\u0438\u0441\u044c\u043c\u0430");
        titleLabel.setFont(titleLabel.getFont().deriveFont(20.0f));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)titleLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        panel.add((Component)this.getSubjectPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(20, 10, 0, 0), 0, 0));
        panel.add((Component)this.getPatternPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(20, 10, 0, 0), 0, 0));
        panel.add((Component)this.getHandlerPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(20, 10, 0, 0), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)buttonPanelOkCancel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 20), 0, 0));
        return panel;
    }

    private JPanel getSubjectPanel() {
        JLabel titleLabel = new JLabel("\u0422\u0435\u043c\u0430 \u043f\u0438\u0441\u044c\u043c\u0430:");
        titleLabel.setFont(titleLabel.getFont().deriveFont(15.0f));
        this.subject = new BGTextField();
        this.subject.setPreferredSize(new Dimension(700, 26));
        JRadioButton defaultButton = new JRadioButton("\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
        defaultButton.setActionCommand("default");
        defaultButton.setSelected(true);
        JRadioButton customButton = new JRadioButton("\u0437\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u0430");
        customButton.setActionCommand("custom");
        this.subjectButtonGroup = new ButtonGroup();
        this.subjectButtonGroup.add(defaultButton);
        this.subjectButtonGroup.add(customButton);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)titleLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)defaultButton, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        panel.add((Component)customButton, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        panel.add((Component)this.subject, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getPatternPanel() {
        JLabel titleLabel = new JLabel("\u0428\u0430\u0431\u043b\u043e\u043d \u043f\u0438\u0441\u044c\u043c\u0430:");
        titleLabel.setFont(titleLabel.getFont().deriveFont(15.0f));
        JRadioButton emptyButton = new JRadioButton("\u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c");
        emptyButton.setActionCommand("off");
        JRadioButton defaultButton = new JRadioButton("\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e (\u043e\u0431\u0449\u0438\u0439 \u0434\u043b\u044f \u0432\u0441\u0435\u0445 \u043f\u0438\u0441\u0435\u043c)");
        defaultButton.setActionCommand("default");
        defaultButton.setSelected(true);
        JRadioButton customButton = new JRadioButton("\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439");
        customButton.setActionCommand("custom");
        this.patternButtonGroup = new ButtonGroup();
        this.patternButtonGroup.add(emptyButton);
        this.patternButtonGroup.add(defaultButton);
        this.patternButtonGroup.add(customButton);
        this.defaultPatternPanel = new PatternPanel();
        this.customPatternPanel = new PatternPanel();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)titleLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)emptyButton, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        panel.add((Component)defaultButton, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        panel.add((Component)this.defaultPatternPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        panel.add((Component)customButton, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        panel.add((Component)this.customPatternPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getHandlerPanel() {
        JLabel titleLabel = new JLabel("\u041a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430:");
        titleLabel.setFont(titleLabel.getFont().deriveFont(15.0f));
        JRadioButton emptyButton = new JRadioButton("\u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c");
        emptyButton.setActionCommand("off");
        JRadioButton defaultButton = new JRadioButton("\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e (\u043e\u0431\u0449\u0438\u0439 \u0434\u043b\u044f \u0432\u0441\u0435\u0445 \u043f\u0438\u0441\u0435\u043c)");
        defaultButton.setActionCommand("default");
        defaultButton.setSelected(true);
        JRadioButton customButton = new JRadioButton("\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439");
        customButton.setActionCommand("custom");
        this.handlerButtonGroup = new ButtonGroup();
        this.handlerButtonGroup.add(emptyButton);
        this.handlerButtonGroup.add(defaultButton);
        this.handlerButtonGroup.add(customButton);
        this.defaultChooser = new DynamicClassChooser(true);
        this.defaultChooser.getClassNamesBox().setPreferredSize(new Dimension(700, 20));
        this.defaultChooser.setIfaceName(MailConfigHandler.class.getName());
        this.defaultChooser.setSuperclassName(MailConfigAbstractHandler.class.getName());
        this.customChooser = new DynamicClassChooser(true);
        this.customChooser.getClassNamesBox().setPreferredSize(new Dimension(700, 20));
        this.customChooser.setIfaceName(MailConfigHandler.class.getName());
        this.customChooser.setSuperclassName(MailConfigAbstractHandler.class.getName());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)titleLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        panel.add((Component)emptyButton, gridBagConstraints);
        panel.add((Component)defaultButton, gridBagConstraints);
        panel.add((Component)this.defaultChooser, gridBagConstraints);
        panel.add((Component)customButton, gridBagConstraints);
        panel.add((Component)this.customChooser, gridBagConstraints);
        return panel;
    }

    private void doButton(String actionCommand) {
        if (!"cancel".equals(actionCommand) && "ok".equals(actionCommand)) {
            this.mailConfig.setSubjectMode(MailConfig.SubjectMode.valueOf(this.subjectButtonGroup.getSelection().getActionCommand().toUpperCase()));
            this.mailConfig.setSubjectCustom(this.subject.getText());
            this.mailConfig.setPatternMode(MailConfig.PatternMode.valueOf(this.patternButtonGroup.getSelection().getActionCommand().toUpperCase()));
            this.mailConfig.setPatternDefault(this.defaultPatternPanel.getPatternData());
            this.mailConfig.setPatternCustom(this.customPatternPanel.getPatternData());
            this.mailConfig.setHandlerMode(MailConfig.HandlerMode.valueOf(this.handlerButtonGroup.getSelection().getActionCommand().toUpperCase()));
            this.mailConfig.setHandlerDefault(this.defaultChooser.getSelectedClass());
            this.mailConfig.setHandlerCustom(this.customChooser.getSelectedClass());
            try {
                ((ClientContext)this.getContext()).getWebService(MailService.class).mailConfigUpdate(this.mailConfig);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
        CardLayout cardLayout = (CardLayout)this.editorPanel.getLayout();
        cardLayout.show(this.editorPanel, "empty");
        this.componentList.setEnabled(true);
        this.letterList.setEnabled(true);
        this.mailConfig = null;
    }

    private void setLetterList() {
        MailComponentDto mailComponentDto = (MailComponentDto)this.componentList.getSelectedValue();
        if (mailComponentDto == null) {
            this.letterList.setData(new ArrayList());
            return;
        }
        try {
            this.letterList.setData(((ClientContext)this.getContext()).getWebService(MailService.class, 0).mailList(String.valueOf(mailComponentDto.getComponentName())));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void showMailEditor() {
        CardLayout cardLayout = (CardLayout)this.editorPanel.getLayout();
        MailDto mailDto = (MailDto)this.letterList.getSelectedValue();
        if (mailDto == null) {
            cardLayout.show(this.editorPanel, "empty");
            return;
        }
        if (!this.initEditor) {
            this.editorPanel.add((Component)this.getMailEditorPanel(), "editor");
            this.defaultChooser.performAction("refresh");
            this.customChooser.performAction("refresh");
        }
        try {
            MailComponentDto mailComponentDto = (MailComponentDto)this.componentList.getSelectedValue();
            this.mailConfig = ((ClientContext)this.getContext()).getWebService(MailService.class).mailConfigGet(mailComponentDto.getComponentName(), mailComponentDto.getModuleId(), mailDto.getKey());
            if (this.mailConfig == null) {
                this.mailConfig = new MailConfig();
                this.mailConfig.setComponentId(mailComponentDto.getComponentName());
                this.mailConfig.setModuleId(mailComponentDto.getModuleId());
                this.mailConfig.setKey(mailDto.getKey());
            }
            this.setSelecButton(this.subjectButtonGroup, this.mailConfig.getSubjectMode().name());
            this.subject.setText(this.mailConfig.getSubjectCustom());
            this.setSelecButton(this.patternButtonGroup, this.mailConfig.getPatternMode().name());
            this.defaultPatternPanel.setPatternData(this.mailConfig.getPatternDefault());
            this.customPatternPanel.setPatternData(this.mailConfig.getPatternCustom());
            this.setSelecButton(this.handlerButtonGroup, this.mailConfig.getHandlerMode().name());
            if (this.mailConfig.getHandlerDefault() != null) {
                this.defaultChooser.setSelectedItem(this.mailConfig.getHandlerDefault());
            }
            if (this.mailConfig.getHandlerCustom() != null) {
                this.customChooser.setSelectedItem(this.mailConfig.getHandlerCustom());
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        cardLayout.show(this.editorPanel, "editor");
        this.componentList.setEnabled(false);
        this.letterList.setEnabled(false);
    }

    private void setSelecButton(ButtonGroup buttonGroup, String command) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            if (!command.equalsIgnoreCase(button.getActionCommand())) continue;
            button.setSelected(true);
            break;
        }
    }

    class PatternPanel
    extends JPanel {
        private String patternData;
        private JTextField status;
        private JButton editButton;

        public PatternPanel() {
            super(new GridBagLayout());
            this.patternData = null;
            this.status = new JTextField(20);
            this.editButton = new JButton(ClientUtils.getIcon("edit"));
            this.status.setHorizontalAlignment(0);
            this.status.setText("\u041d\u0415 \u0423\u0421\u0422\u0410\u041d\u041e\u0412\u041b\u0415\u041d");
            this.editButton.addActionListener(e -> this.doEdit());
            this.add((Component)this.status, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)this.editButton, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        }

        public String getPatternData() {
            return this.patternData;
        }

        public void setPatternData(String patternData) {
            this.patternData = patternData;
            this.status.setText(Utils.notBlankString(patternData) ? "\u0423\u0421\u0422\u0410\u041d\u041e\u0412\u041b\u0415\u041d" : "\u041d\u0415 \u0423\u0421\u0422\u0410\u041d\u041e\u0412\u041b\u0415\u041d");
        }

        private void doEdit() {
            BGTextArea textArea = new BGTextArea(20, 50);
            textArea.setLineWrap(false);
            textArea.setText(this.patternData == null ? "" : this.patternData);
            JOptionPane.showMessageDialog(MailLetterPanel.this, BGSwingUtilites.wrapScrollPane(textArea, 800, 400), "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0435\u043a\u0441\u0442\u0430 \u0448\u0430\u0431\u043b\u043e\u043d\u0430", -1);
            this.setPatternData(textArea.getText());
        }
    }
}

