/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.plugincfg.server;

import jakarta.jws.WebService;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.admin.plugincfg.common.PluginItem;
import ru.bitel.bgbilling.kernel.admin.plugincfg.common.PlugincfgService;
import ru.bitel.bgbilling.kernel.admin.plugincfg.server.PlugincfgDao;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.module.server.event.ModulesChangedEvent;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.plugin.server.event.PluginConfigModifiedEvent;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.admin.plugincfg.common.PlugincfgService")
public class PlugincfgServiceImpl
extends AbstractService
implements PlugincfgService {
    @Override
    public List<PluginItem> getPlugins() throws BGException {
        return new PlugincfgDao(this.getConnection()).getPlugins();
    }

    @Override
    public PluginItem getPlugin(int id) throws BGException {
        return new PlugincfgDao(this.getConnection()).getPlugin(id);
    }

    @Override
    public void updatePlugin(PluginItem pluginItem) throws BGException {
        PlugincfgDao plugincfgDao = new PlugincfgDao(this.getConnection());
        int id = pluginItem.getId();
        boolean enabled = pluginItem.isEnabled();
        String config = pluginItem.getConfig();
        if (id != -1 && config != null) {
            plugincfgDao.updatePluginConfig(id, config);
            BGPluginServer plugin = BGPluginManagerServer.getManager().getPluginByUID(id);
            if (plugin != null) {
                if (!enabled) {
                    plugincfgDao.updateEnable(id, false);
                }
            } else if (enabled) {
                plugincfgDao.updateEnable(id, true);
            }
        } else {
            throw new BGIllegalArgumentException();
        }
        this.context.publishAfterCommit(new PluginConfigModifiedEvent(id, this.context.getUserId()));
        this.context.publishAfterCommit(new ModulesChangedEvent(this.context.getUserId()));
    }
}

