/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.server.service;

import bitel.billing.server.contract.bean.ContractManager;
import jakarta.jws.WebService;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.common.bean.FieldNameSQL;
import ru.bitel.bgbilling.kernel.admin.common.service.AdminService;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.admin.common.service.AdminService")
public class AdminServiceImpl
extends AbstractService
implements AdminService {
    @Override
    public List<IdTitle> getContractEntries(String values, boolean byTitle) throws BGException, BGMessageException {
        List result = new ArrayList();
        try (ContractManager contractManager = new ContractManager(this.getConnection());){
            result = byTitle ? contractManager.getContractsByTitles(Utils.toList(values, "\n")) : contractManager.getContracts(values);
        }
        return result.stream().map(a -> new IdTitle(a.getId(), a.getTitle())).toList();
    }

    @Override
    public List<BGModule> getModules() throws BGException, BGMessageException {
        return ModuleCache.getInstance().getModulesList();
    }

    @Override
    public List<String> getContractEntriesFromSqlQuery(String query, FieldNameSQL fieldNameSQL) throws BGException, BGMessageException {
        if (query == null) {
            throw new BGMessageException("query == null");
        }
        if (fieldNameSQL == null) {
            throw new BGMessageException("fieldNameSQL == null");
        }
        if (query.isEmpty() || !query.toUpperCase().startsWith("SELECT ")) {
            throw new BGMessageException("\u043f\u0443\u0441\u0442\u043e\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u0438\u043b\u0438 \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f \u043d\u0435 \u0441 'SELECT '");
        }
        ArrayList<String> result = new ArrayList<String>();
        try (Statement st = this.getConnection().createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result.add(rs.getString(fieldNameSQL.name().toLowerCase()));
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return result;
    }
}

