/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.client;

import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public class OperatorTariffTreeNode
extends DefaultTariffTreeNode {
    private static final Icon icon = ClientUtils.getIcon("discount");
    private Directory dir;
    private int operatorId;
    private String tariffTreeTitle;
    private JLabel view;
    private JPanel editor;
    private BGUComboBox<IdTitle> costMapCombo;

    @Override
    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        this.dir = this.getDirManager().getDirectory("operator");
    }

    private void extractData() {
        Map<String, String> data = this.getDataInHash();
        this.operatorId = Utils.parseInt(data.get("operatorId"));
        this.tariffTreeTitle = this.dir.getValue(this.operatorId);
    }

    @Override
    protected JPanel getEditorPanel() {
        if (this.editor == null) {
            this.costMapCombo = new BGUComboBox();
            this.editor = new JPanel();
            this.editor.add(this.costMapCombo);
            this.costMapCombo.setData(this.dir.getItems());
        }
        Map<String, String> data = this.getDataInHash();
        this.costMapCombo.setSelectedItem(Utils.parseInt(data.get("operatorId")));
        return this.editor;
    }

    @Override
    public Component getView() {
        if (this.view == null) {
            this.view = new JLabel(icon, 2);
        }
        this.extractData();
        this.view.setText("\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440: " + this.tariffTreeTitle);
        return this.view;
    }

    @Override
    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("operatorId", String.valueOf(((IdTitle)this.costMapCombo.getSelectedItem()).getId()));
        this.setDataInHash(data);
    }

    @Override
    public void serializeToXML(Element el) {
        this.serializeHashToXML(el);
        this.serializeChildsToXML(el);
    }

    @Override
    public void loadFromXML(Element el) {
        this.loadHashFromXML(el);
        this.loadChildsFromXML(el);
    }
}

