/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.servlet;

import bitel.billing.common.cache.CacheManager;
import bitel.billing.server.Action;
import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.admin.bgsecure.bean.JAAS;
import bitel.billing.server.admin.bgsecure.bean.UserLoginModule;
import bitel.billing.server.contract.bean.ContractUtils;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.util.Date;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.security.auth.Subject;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.ActionLogEntry;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.BGActionLogManager;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.BGSQueryLogDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.BGSQueryLogEntry;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.security.server.FindAction;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleAction;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.container.web.action.ActionHandler;
import ru.bitel.bgbilling.kernel.container.ws.server.JaxWsHandler;
import ru.bitel.bgbilling.kernel.container.ws.server.JsonWsHandler;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ActionAfterEvent;
import ru.bitel.bgbilling.kernel.event.events.ActionBeforeEvent;
import ru.bitel.bgbilling.kernel.file.server.FileUtils;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.ModuleManager;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.ServletUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.io.Base64;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.model.Id;
import ru.bitel.common.worker.ThreadContext;

@WebServlet(name="Executer", urlPatterns={"/executer/*"})
public final class Executer
extends CommonExecutor {
    private String loginContextName;
    private ActionHandler actionHandler;
    private JaxWsHandler jaxWS = null;
    private JsonWsHandler jsonWs = null;

    @Override
    public void init() {
        this.setup = Setup.getSetup();
        this.setPath();
        JAAS.init((Setup)this.setup);
        this.loginContextName = "1".equals(this.setup.get("bgsecure.jaas.ldap")) ? "executer_ldap" : "executer";
        this.actionHandler = new ActionHandler();
        try {
            this.jaxWS = new JaxWsHandler(this.getServletContext());
            this.jsonWs = new JsonWsHandler(this.getServletContext());
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void setPath() {
        String pathSeparator = System.getProperty("path.separator");
        StringBuilder cp = new StringBuilder();
        String path = new File("lib").getAbsolutePath();
        File fl = new File(path);
        if (fl.exists() && fl.isDirectory()) {
            File[] jars = fl.listFiles();
            int size = jars.length;
            for (int i = 0; i < size; ++i) {
                cp.append(jars[i].getAbsolutePath());
                cp.append(pathSeparator);
            }
        }
        cp.append(System.getProperty("java.class.path"));
        System.setProperty("jasper.reports.compile.class.path", cp.toString());
        System.setProperty("jasper.reports.compile.temp", this.setup.getTempDirPath());
        if (this.setup.get("test_report") != null) {
            System.setProperty("jasper.reports.compile.temp", "/tmp/");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String clientVersion;
        String currentVersion = Setup.getSetup().get("bg.client.version");
        if (currentVersion != null && !currentVersion.isEmpty() && (clientVersion = request.getHeader("bgbilling-client-version")) != null && !currentVersion.equals(clientVersion)) {
            response.setHeader("bgbilling-server-version", currentVersion);
        }
        Document doc = XMLUtils.newDocument();
        Element rootNode = XMLUtils.createElement(doc, "data");
        rootNode.setAttribute("status", "ok");
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            if (pathInfo.startsWith("/upload")) {
                if (this.checkUser(request, rootNode) != null) {
                    Path path = Files.createTempFile("aaa", "bbb", new FileAttribute[0]);
                    Files.write(path, Utils.readByBlock((InputStream)request.getInputStream()), new OpenOption[0]);
                    BGServerFile serverFile = new BGServerFile();
                    BGServerFile.fromJSON(new JSONObject(Base64.decode(request.getHeader("bgbilling-file-info"), "utf-8")), serverFile);
                    serverFile.setUserId((Integer)request.getAttribute("user_id"));
                    String handler = request.getHeader("bgbilling-handler");
                    logger.debug("executing upload {}...", (Object)handler);
                    if (handler != null) {
                        String[] handlerData = handler.split("/");
                        if (handlerData.length == 2) {
                            BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin(handlerData[0]);
                            try {
                                Class<?> clazz = Class.forName(plugin.getPackServer() + ".file.FileUtils");
                                Method method = clazz.getMethod(handlerData[1], BGServerFile.class, Path.class);
                                Object object = method.invoke(clazz.getConstructor(new Class[0]).newInstance(new Object[0]), serverFile, path);
                                if (object != null && object instanceof Integer) {
                                    response.setHeader("bgbilling-file-id", String.valueOf((Integer)object));
                                }
                            }
                            catch (Exception e) {
                                logger.error((Object)e);
                            }
                        } else if (handlerData.length == 3) {
                            // empty if block
                        }
                    }
                }
                return;
            }
            if (pathInfo.startsWith("/download")) {
                if (this.checkUser(request, rootNode) != null) {
                    String handler = request.getHeader("bgbilling-handler");
                    logger.debug("executing download {}...", (Object)handler);
                    if (handler != null) {
                        String[] handlerData = handler.split("/");
                        if (handlerData.length == 2) {
                            BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin(handlerData[0]);
                            try {
                                Class<?> clazz = Class.forName(plugin.getPackServer() + ".file.FileUtils");
                                Method method = clazz.getMethod(handlerData[1], HttpServletRequest.class, HttpServletResponse.class);
                                method.invoke(clazz.getConstructor(new Class[0]).newInstance(new Object[0]), request, response);
                            }
                            catch (Exception clazz) {}
                        } else if (handlerData.length > 2) {
                            if ("kernel".equals(handlerData[0])) {
                                try {
                                    Class<FileUtils> clazz = FileUtils.class;
                                    Method method = clazz.getMethod(handlerData[2], HttpServletRequest.class, HttpServletResponse.class);
                                    method.invoke(clazz.getConstructor(new Class[0]).newInstance(new Object[0]), request, response);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            } else {
                                String moduleName = handlerData[0];
                                int method = Utils.parseInt(handlerData[1]);
                            }
                        }
                    }
                }
                return;
            }
            if (pathInfo.startsWith("/json")) {
                try {
                    BGNestedContext.push("json");
                    this.jsonWs.handle(request, response);
                    return;
                }
                finally {
                    BGNestedContext.peek();
                }
            }
            try {
                BGNestedContext.push("service");
                this.jaxWS.handle(request, response);
                return;
            }
            finally {
                BGNestedContext.peek();
            }
        }
        Object actionInfo = null;
        try {
            BGNestedContext.push("action");
            Object contentType = Executer.getRequestParameters("xml", request, "contentType", "ct");
            request.setAttribute("setup", (Object)this.setup);
            request.setAttribute("response", (Object)response);
            request.setAttribute("rootNode", (Object)rootNode);
            request.setAttribute("contentType", contentType);
            ServerUtils.addNoCache((HttpServletResponse)response);
            Subject subject = this.checkUser(request, rootNode);
            if (subject != null && this.checkAndLogRequest(request, rootNode)) {
                actionInfo = this.doModule(request, response, rootNode);
            }
            Executer.doSign(request, rootNode);
            contentType = request.getAttribute("contentType");
            if (this.setup.getInt("server.response.debug", -1) > 0 && logger.isDebugEnabled()) {
                logger.debug(XMLUtils.serializeToString(doc, false));
            }
            if (ActionResultContentType.xml.isEquals(contentType)) {
                String xsltFile = rootNode.getAttribute("xslt");
                this.sendXML(request, response, doc, xsltFile);
            } else if (ActionResultContentType.html.isEquals(contentType)) {
                String xsltFile = rootNode.getAttribute("xslt");
                String email = request.getParameter("email");
                if (email == null) {
                    this.xslManager.transform(response, xsltFile, new DOMSource(doc), (Map)request.getAttribute("bitel.billing.server.transformer.parameters"), "text/" + contentType, null, false);
                } else {
                    String emailSubject = request.getParameter("email_subject");
                    this.xslManager.transformAndSend(xsltFile, new DOMSource(doc), (Map)request.getAttribute("bitel.billing.server.transformer.parameters"), "text/" + contentType, null, false, email, emailSubject);
                    this.sendXML(request, response, doc, null);
                }
            } else if (ActionResultContentType.binary.isEquals(contentType)) {
                // empty if block
            }
        }
        catch (Throwable e) {
            Executer.setErrorStatus(request, rootNode, "\u041e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage());
            logger.error("Exception in Executer (" + String.valueOf(actionInfo) + ")", e);
        }
        finally {
            BGNestedContext.peek();
        }
    }

    private void sendXML(HttpServletRequest request, HttpServletResponse response, Document doc, String xsltFile) throws SAXException, IOException {
        String charset = "UTF-8";
        response.setContentType("text/xml; charset=" + charset);
        XMLUtils.serialize(doc, new StreamResult((OutputStream)response.getOutputStream()), charset, Utils.parseBoolean(request.getParameter("contentIndent")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAndLogRequest(HttpServletRequest request, Element rootNode) {
        boolean result;
        block11: {
            boolean log;
            result = true;
            Integer userId = (Integer)request.getAttribute("user_id");
            if (userId == null) {
                userId = -1;
            }
            boolean check = this.setup.getInt("bgsecure.check", -1) > 0;
            boolean bl = log = this.setup.getInt("bgsecure.log", -1) > 0;
            if (check || log) {
                String remoteAddr = ServletUtils.getIpFromHeader((HttpServletRequest)request, (Setup)this.setup);
                String module = request.getParameter("module");
                int cid = Utils.parseInt(request.getParameter("cid"), 0);
                BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin(module);
                Object mid = plugin != null ? "p" + plugin.getPluginUID() : String.valueOf(Utils.parseInt(request.getParameter("mid"), 0));
                try {
                    String notAllowReason;
                    String[] midRef = new String[]{mid};
                    ModuleAction action = FindAction.find(midRef, request);
                    mid = midRef[0];
                    if (action == null) break block11;
                    User user = UserMap.getUser((Integer)userId);
                    if (check && (notAllowReason = PermissionOfRoles.getInstance().checkActionAllow(request, (String)mid, action, (int)userId, cid)) != null) {
                        if (user.isShowActionsPermitErrors()) {
                            Executer.setErrorStatus(request, rootNode, notAllowReason);
                            rootNode.setAttribute("access_error", "1");
                        }
                        result = false;
                    }
                    if (!log || user.getConfigSetup().getBoolean("log.disabled", false)) break block11;
                    Date now = new Date();
                    Connection con = this.setup.getDBTrashOrMasterConnectionFromPool(BGSQueryLogDao.getTableName(now));
                    try {
                        ContractUtils cu = new ContractUtils(con);
                        BGModule mod = new ModuleManager(con).getModule(Utils.parseInt((String)mid));
                        BGSQueryLogEntry entry = new BGSQueryLogEntry();
                        entry.setUserId(userId);
                        entry.setRemoteAddr(remoteAddr);
                        entry.setContractId(cid);
                        entry.setActionTitle(action.getTitle());
                        entry.setQueryString(Executer.getQueryString(request, false));
                        entry.setActionId(action.getId());
                        entry.setModuleId((String)mid);
                        entry.setContractTitle(cu.getContractTitle(cid, false, ""));
                        entry.setUserName(user != null ? user.getName() : "");
                        entry.setModuleName(mod != null ? mod.getTitle() : "");
                        BGSQueryLogDao.log(con, entry, now);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        ServerUtils.closeConnection((Connection)con);
                    }
                }
                catch (BGException ex) {
                    result = false;
                    Executer.setErrorStatus(request, rootNode, ex.getMessage());
                }
            }
        }
        return result;
    }

    protected Subject checkUser(HttpServletRequest request, Element rootNode) {
        String msg;
        Subject result;
        block13: {
            result = null;
            msg = "";
            this.getLoginAndPassword(request);
            String userName = (String)request.getAttribute("userName");
            String userPswd = (String)request.getAttribute("userPswd");
            if (userName != null && userPswd != null) {
                Object user;
                HttpSession session;
                boolean authToSession;
                boolean bl = authToSession = !"application/octet-stream".equals(request.getContentType()) && !"0".equals(request.getParameter("authToSession"));
                if (authToSession && !(session = request.getSession(true)).isNew()) {
                    Integer userId = (Integer)session.getAttribute("user_id");
                    user = (String)session.getAttribute("user");
                    String pswd = (String)session.getAttribute("pswd");
                    if (userName.equalsIgnoreCase((String)user) && userPswd.equals(pswd) && userId != null) {
                        result = (Subject)session.getAttribute("subject");
                        request.setAttribute("user_id", (Object)userId);
                    }
                }
                if (result == null) {
                    String userNameIp = String.format("%s [%s]", userName, ServletUtils.getIpFromHeader((HttpServletRequest)request, (Setup)this.setup));
                    try {
                        Subject subject = UserLoginModule.auth((String)this.loginContextName, (String)userName, (String)userPswd);
                        user = UserLoginModule.getUser((Subject)subject);
                        request.setAttribute("user_id", (Object)((Id)user).getId());
                        HttpSession session2 = request.getSession(false);
                        if (session2 != null) {
                            session2.setAttribute("user_id", (Object)((Id)user).getId());
                            session2.setAttribute("user", (Object)userName);
                            session2.setAttribute("pswd", (Object)userPswd);
                            session2.setAttribute("subject", (Object)subject);
                        }
                        result = subject;
                    }
                    catch (FailedLoginException e) {
                        if (e.getCause() instanceof AuthenticationException) {
                            msg = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 LDAP. \u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c?";
                            logger.warn(userNameIp + " \u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 LDAP. \u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c?", (Throwable)e);
                            break block13;
                        }
                        if (e.getCause() instanceof CommunicationException) {
                            msg = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 LDAP.";
                            logger.warn(userNameIp + " \u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 LDAP", (Throwable)e);
                            break block13;
                        }
                        if ("Cannot find user's LDAP entry".equals(e.getMessage())) {
                            msg = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 LDAP.";
                            logger.warn(userNameIp + " \u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 LDAP", (Throwable)e);
                            break block13;
                        }
                        msg = e.getLocalizedMessage();
                        logger.warn(userNameIp + " \u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438", (Throwable)e);
                    }
                    catch (LoginException e) {
                        msg = e.getLocalizedMessage();
                        logger.warn(userNameIp + " " + e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                msg = "\u041d\u0435\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430(\u043e\u0432) user \u0438/\u0438\u043b\u0438 pswd";
            }
        }
        if (result == null) {
            rootNode.setAttribute("status", "error");
            rootNode.appendChild(rootNode.getOwnerDocument().createTextNode(msg));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doModule(HttpServletRequest request, HttpServletResponse response, Element rootNode) {
        String module = request.getParameter("module");
        String action = request.getParameter("action");
        String className = null;
        if (module == null) {
            String msg = "\u041c\u043e\u0434\u0443\u043b\u044c \"" + module + "\" - \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!";
            rootNode.setAttribute("status", "error");
            rootNode.appendChild(rootNode.getOwnerDocument().createTextNode(msg));
        } else {
            String msg = bitel.billing.server.util.FileUtils.getFileUtils().normalize0();
            if (msg != null) {
                XMLUtils.createTextNode(rootNode, msg);
                rootNode.setAttribute("status", "message");
            }
            className = "Action" + action.substring(0, 1).toUpperCase() + action.substring(1);
            ActionBeforeEvent actionEvent = null;
            int userID = (Integer)request.getAttribute("user_id");
            int contractId = Utils.parseInt(request.getParameter("cid"), -1);
            String actionEventMode = this.setup.get("action.event_" + module + "_" + action);
            if (actionEventMode != null && contractId > 0 && ("before".equals(actionEventMode) || "both".equals(actionEventMode))) {
                ServerContext context = new ServerContext(this.setup, 0, userID);
                ThreadContext parentContext = ThreadContext.push(context);
                try {
                    actionEvent = new ActionBeforeEvent(request, module, action, contractId, userID);
                    try {
                        actionEvent = EventProcessor.getInstance().request(actionEvent);
                        context.commit();
                    }
                    catch (BGException e) {
                        Executer.setErrorStatus(request, rootNode, e.getLocalizedMessage());
                    }
                    if (Utils.notBlankString(actionEvent.getError())) {
                        Executer.setErrorStatus(request, rootNode, actionEvent.getError());
                    }
                }
                finally {
                    ThreadContext.pop(context, parentContext);
                }
            }
            if (actionEvent == null || actionEvent.isDoAction()) {
                Class<?> actionClass = null;
                try {
                    String actionClassName = this.setup.get("action.remap_" + module + "_" + action);
                    if (actionClassName != null) {
                        actionClass = Class.forName(actionClassName);
                    }
                }
                catch (Exception actionClassName) {
                    // empty catch block
                }
                if (actionClass == null) {
                    actionClass = this.findAction(module, "", className);
                }
                if (actionClass != null) {
                    long time;
                    ActionLogEntry ql;
                    BGActionLogManager qlm;
                    block41: {
                        qlm = new BGActionLogManager();
                        ql = null;
                        if (qlm.isConnectionActive()) {
                            ql = new ActionLogEntry();
                            ql.setAction(className);
                            ql.setDatetime(new Date());
                            ql.setModuleId(Utils.parseInt(request.getParameter("mid"), -1));
                            ql.setModuleTitle(module);
                            ql.setQuery(Executer.getQueryString(request, false));
                            ql.setUserId(userID);
                        }
                        time = System.currentTimeMillis();
                        Action actionInstance = null;
                        try {
                            if (qlm.isConnectionActive()) {
                                qlm.update(ql);
                            }
                            if (Action.class.isAssignableFrom(actionClass)) {
                                try {
                                    actionInstance = actionClass.asSubclass(Action.class).newInstance();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (actionInstance != null) {
                                    actionInstance.init(this.setup, rootNode, request, response, this.servletContext);
                                    actionInstance.doAction();
                                    actionInstance.commit();
                                }
                            } else if (AbstractAction.class.isAssignableFrom(actionClass)) {
                                this.actionHandler.handle(actionClass.asSubclass(AbstractAction.class), this.setup, null, rootNode, request, response, request.getServletContext(), contractId, userID);
                            }
                            if ((actionEventMode = this.setup.get("action.event_" + module + "_" + action)) == null || contractId <= 0 || !"after".equals(actionEventMode) && !"both".equals(actionEventMode)) break block41;
                            ServerContext context = new ServerContext(this.setup, 0, userID);
                            ThreadContext parentContext = ThreadContext.push(context);
                            try {
                                ActionAfterEvent actionAfterEvent = new ActionAfterEvent(module, action, contractId, userID);
                                actionAfterEvent.setRootNode(rootNode);
                                EventProcessor.getInstance().request(actionAfterEvent);
                                context.commit();
                            }
                            finally {
                                ThreadContext.pop(context, parentContext);
                            }
                        }
                        catch (BGMessageException ex) {
                            Executer.setErrorStatus(request, rootNode, ex.getLocalizedMessage());
                        }
                        catch (Exception ex) {
                            Executer.setErrorStatus(request, rootNode, ex.getLocalizedMessage());
                            logger.error(ex.getMessage(), (Throwable)ex);
                        }
                        finally {
                            if (actionInstance != null) {
                                actionInstance.freeConnection();
                            }
                        }
                    }
                    Executer.loadDirectory(this.setup, rootNode, request, response, this.servletContext);
                    if (logger.isDebugEnabled()) {
                        Object operation = request.getParameter("operation");
                        operation = operation == null ? "" : ":" + (String)operation;
                        logger.debug("executing " + actionClass.getName() + (String)operation + "; time => " + (System.currentTimeMillis() - time) + " ms.");
                    }
                    try {
                        if (qlm.isConnectionActive() && ql != null) {
                            qlm.delete(ql.getId());
                        }
                        qlm.closeConnection();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                } else {
                    String err = "Action NOT FOUND ! module:" + module + " class: " + className;
                    logger.error(err);
                    Executer.setErrorStatus(request, rootNode, err);
                }
            }
        }
        return className;
    }

    protected static void doSign(HttpServletRequest request, Element rootNode) {
        try {
            String secret = request.getParameter(Utils.swapWords("GBiBllniSgceert"));
            if (Utils.isEmptyString(secret)) {
                return;
            }
            String message = Utils.getMessage(rootNode.getOwnerDocument());
            String buffer = secret + Utils.PART + message;
            String digest = Utils.getDigest(buffer, "cp1251");
            rootNode.setAttribute(Utils.swapWords("esrcte"), digest);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    private static void loadDirectory(Setup setup, Element rootNode, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        CacheManager cacheManager = CacheManager.getCacheManager();
        cacheManager.getXML(setup, rootNode, request, response, servletContext);
    }
}

