/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RoleItem;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.PermissionKitDao;
import ru.bitel.bgbilling.kernel.module.common.bean.Role;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Id;

public class RoleDao
extends AbstractIdDao<Role> {
    private PermissionKitDao permissionKitDao;

    public RoleDao(Connection con) {
        super(con, 0, "role");
        this.permissionKitDao = new PermissionKitDao(con);
    }

    @Override
    public List<Role> list(String filter, String orderBy, Object ... params) throws BGException {
        return super.list(null, null, new Object[0]);
    }

    public List<RoleItem> roleItemList(boolean initChilds) throws BGException {
        ArrayList<RoleItem> result = new ArrayList<RoleItem>();
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery("SELECT r.id, r.title, m.title, childs FROM " + this.tableName + " AS r LEFT JOIN bgs_menu AS m ON m.id=r.menu_id");){
            HashMap<Integer, List<Integer>> roleChildIds = new HashMap<Integer, List<Integer>>();
            while (rs.next()) {
                int roleId = rs.getInt("r.id");
                RoleItem roleItem = new RoleItem(roleId, rs.getString("r.title"));
                roleItem.setMenuTitle(rs.getString("m.title"));
                result.add(roleItem);
                if (!initChilds) continue;
                roleChildIds.put(roleId, Utils.toIntegerList(rs.getString("childs")));
            }
            if (initChilds) {
                for (RoleItem roleItem : result) {
                    List childIds = (List)roleChildIds.get(roleItem.getId());
                    if (childIds.isEmpty()) continue;
                    result.stream().filter(i -> childIds.contains(i.getId())).forEach(i -> roleItem.getChildren().add((RoleItem)i));
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }

    @Override
    protected Role getFromRS(ResultSet rs) throws SQLException, BGException {
        Role role = new Role();
        role.setId(rs.getInt("id"));
        role.setTitle(rs.getString("title"));
        role.setMenuId(rs.getInt("menu_id"));
        role.setPermissionKits(this.permissionKitDao.getByIds(rs.getString("permission_kit_ids")));
        role.setChildren(this.loadChildren(rs.getString("childs")));
        return role;
    }

    private List<Role> loadChildren(String childIds) throws BGException {
        ArrayList<Role> childs = new ArrayList<Role>();
        if (Utils.isBlankString(childIds)) {
            return childs;
        }
        String query = "select * from " + this.tableName + " where id IN (" + childIds + ")";
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            while (rs.next()) {
                childs.add(this.getFromRS(rs));
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return childs;
    }

    @Override
    protected void updateImpl(Role role) throws BGException, SQLException {
        if (role == null) {
            return;
        }
        boolean update = role.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, menu_id=?, childs=?, permission_kit_ids=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, role.getTitle());
            ps.setInt(index++, role.getMenuId());
            ps.setString(index++, Utils.toString(role.getChildren().stream().mapToInt(Id::getId).boxed().collect(Collectors.toList())));
            String permissionKitIds = "";
            if (Utils.notEmptyCollection(role.getPermissionKits())) {
                permissionKitIds = Utils.toString(role.getPermissionKits().stream().mapToInt(Id::getId).boxed().collect(Collectors.toList()), ",");
            }
            ps.setString(index++, permissionKitIds);
            if (update) {
                ps.setInt(index, role.getId());
            }
            ps.executeUpdate();
            if (!update) {
                role.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }
}

