/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.service.server;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.container.managed.ManagedBeanInfo;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.server.util.Setup;

public class ServiceInfo<B>
extends ManagedBeanInfo<B> {
    private static final Logger logger = LogManager.getLogger();
    private static final ConcurrentMap<Class<?>, ServiceInfo<?>> helpers = new ConcurrentHashMap();
    static final Pattern patternSlash = Pattern.compile("/");

    private static Class<?> getImplementorClass(Class<?> iface) throws ClassNotFoundException {
        StringBuilder name = new StringBuilder(iface.getName());
        String simpleName = iface.getSimpleName();
        name.setLength(name.length() - simpleName.length() - 1);
        if (name.toString().endsWith(".common.service")) {
            name.setLength(name.length() - 15);
            name.append(".server.service.").append(simpleName).append("Impl");
        } else if (name.toString().endsWith(".common")) {
            name.setLength(name.length() - 7);
            name.append(".server.").append(simpleName).append("Impl");
        } else {
            name.append(".server.").append(simpleName).append("Impl");
        }
        return Class.forName(name.toString());
    }

    public static <B> ServiceInfo<B> getServiceHelper(Class<B> clazz) {
        ServiceInfo<B> helper = (ServiceInfo<B>)helpers.get(clazz);
        if (helper == null) {
            Class<B> implementorClass = clazz;
            if (clazz.isInterface()) {
                try {
                    implementorClass = ServiceInfo.getImplementorClass(clazz);
                    helper = (ServiceInfo)helpers.get(implementorClass);
                    if (helper != null) {
                        helpers.putIfAbsent(clazz, helper);
                    }
                }
                catch (ClassNotFoundException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (helper == null) {
                helper = new ServiceInfo<B>(implementorClass);
                helpers.putIfAbsent(clazz, helper);
            }
        }
        return helper;
    }

    public ServiceInfo(Class<B> clazz) {
        super(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(ServerContext ctx, Setup setup, Object t, Method m, Object[] args, int moduleId, int userId) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object object;
        this.postConstruct(ctx, moduleId, t);
        try {
            Object result = m.invoke(t, args);
            ctx.commit();
            object = result;
        }
        catch (Throwable throwable) {
            try {
                this.preDestroy(t);
                throw throwable;
            }
            catch (InvocationTargetException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        this.preDestroy(t);
        return object;
    }

    @Override
    public void postConstruct(ServerContext ctx, int moduleId, Object t) throws Exception {
        if (t instanceof AbstractService) {
            AbstractService service = (AbstractService)t;
            service.context = ctx;
            service.setup = ctx.getSetup();
            service.userId = ctx.getUserId();
            service.connectionSet = ctx.getConnectionSet();
            if (moduleId > 0) {
                service.moduleId = moduleId;
                service.moduleSetup = moduleId == ctx.getModuleId() ? ctx.getModuleSetup() : service.setup.getModuleSetup(Integer.valueOf(moduleId));
            }
        }
        super.postConstruct(ctx, moduleId, t);
    }
}

