/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.SearchResult;

public class ContractStatusDao
extends AbstractIdDao<ContractStatus> {
    public ContractStatusDao(Connection con) {
        super(con, 0, "contract_status");
    }

    @Override
    protected ContractStatus getFromRS(ResultSet rs) throws SQLException, BGException {
        return ContractStatus.builder().setId(rs.getInt("id")).setContractId(rs.getInt("cid")).setDateFrom(rs.getDate("date1")).setDateTo(rs.getDate("date2")).setStatus(rs.getInt("status")).setComment(rs.getString("comment")).build();
    }

    @Override
    protected void updateImpl(ContractStatus status) throws BGException, SQLException {
        Objects.requireNonNull(status);
        boolean update = status.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET date1=?, date2=?, status=?, comment=?" + (update ? " WHERE id=?" : ", cid=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 0;
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(status.getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(status.getDateTo()));
            ps.setInt(index++, status.getStatus());
            ps.setString(index++, status.getComment());
            ps.setInt(index++, update ? status.getId() : status.getContractId());
            ps.executeUpdate();
            if (!update) {
                status.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public ContractStatus getStatus(int contractId, Date date) throws BGException {
        ContractStatus result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE cid=? AND date1<=? AND (date2 IS NULL OR date2>=?) LIMIT 1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate(date);
            ps.setInt(1, contractId);
            ps.setDate(2, sqlDate);
            ps.setDate(3, sqlDate);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result = this.getFromRS(rs);
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public List<ContractStatus> getStatusList(int contractId, Date date) throws BGException {
        ArrayList<ContractStatus> result = new ArrayList<ContractStatus>();
        String query = "SELECT * FROM " + this.tableName + " WHERE cid=? AND (date2 IS NULL OR ?<=date2) ORDER BY date1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setDate(2, TimeUtils.convertDateToSqlDate(date));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public List<ContractStatus> getStatusList(int contractId) throws BGException {
        return this.list("cid=?", "date1", contractId);
    }

    public void searchContractStatus(SearchResult<ContractStatus> searchResult, int contractId) throws BGException {
        Result result = this.list(searchResult.getPage(), "cid=?", "date1 desc", contractId);
        searchResult.setList(result.getList());
        searchResult.setPage(result.getPage());
    }

    public List<ContractStatus> list(int contractId, Date date) throws BGException {
        ArrayList<ContractStatus> result = new ArrayList<ContractStatus>();
        boolean useDate = date != null;
        String query = "SELECT * FROM contract_status WHERE cid=?" + (useDate ? " AND (date2 IS NULL OR ?<=date2)" : "") + " ORDER BY date1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            if (useDate) {
                ps.setDate(2, TimeUtils.convertDateToSqlDate(date));
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public ContractStatus getOnDate(int contractId, Date date) throws BGException {
        ContractStatus contractStatus = null;
        String query = "SELECT * FROM contract_status WHERE cid=? AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR ?<=date2)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setDate(2, TimeUtils.convertDateToSqlDate(date));
            ps.setDate(3, TimeUtils.convertDateToSqlDate(date));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    contractStatus = this.getFromRS(rs);
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return contractStatus;
    }
}

