/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.service;

import bitel.billing.server.contract.bean.ContractUtils;
import jakarta.jws.WebService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.fop.apps.FOPException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.dto.FileDto;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractCard;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractCardService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.GetContractCardsList;
import ru.bitel.common.FOUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.api.common.service.ContractCardService")
public class ContractCardServiceImpl
extends AbstractService
implements ContractCardService {
    @Override
    public List<ContractCard> contractCardList(int contractId) throws BGException {
        ArrayList<ContractCard> cards = new ArrayList<ContractCard>();
        String card = "";
        Contract contract = null;
        if (contractId > 0) {
            ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);
            contract = (Contract)contractDao.get(contractId);
            contractDao.close();
        }
        int i = 1;
        while (card != null) {
            String[] arr;
            card = this.getSetup().get("contractcard." + i, null);
            if (card != null && (arr = card.split(":", 3)).length > 1 && (contract == null || arr.length <= 2 || (contract.getGroups() & Utils.enumToMask(arr[2])) != 0L)) {
                ContractCard contractCard = new ContractCard();
                contractCard.setId(arr[0].trim());
                contractCard.setTitle(arr[1]);
                cards.add(contractCard);
            }
            ++i;
        }
        GetContractCardsList event = new GetContractCardsList(this.userId, contractId, cards);
        event = EventProcessor.getInstance().request(event);
        ArrayList<ContractCard> result = new ArrayList<ContractCard>(cards);
        return result;
    }

    @Override
    public FileDto contractCardExport(int contractId, String contractCardId) throws BGException {
        List<ContractCard> contractCardList = this.contractCardList(contractId);
        boolean exists = false;
        for (ContractCard contractCard : contractCardList) {
            if (!contractCard.getId().equals(contractCardId)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            throw new BGIllegalArgumentException();
        }
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            dFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element card = document.createElement("card");
            Element user = XMLUtils.createElement(card, "user");
            user.setAttribute("id", String.valueOf(this.userId));
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            XMLStreamWriter w = factory.createXMLStreamWriter(new DOMResult(card));
            new ContractUtils(this.getConnection()).addContractXML(contractId, w, true);
            document.appendChild(card);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
            XSLManager.getInstance().transform((Source)new DOMSource(document), contractCardId, FOUtils.renderSAXResult(baos, "application/pdf"));
            baos.flush();
            FileDto contractCardDto = new FileDto();
            contractCardDto.setContentType("text/csv");
            contractCardDto.setFileName("export.csv");
            contractCardDto.setData(Base64.getEncoder().encodeToString(baos.toByteArray()));
            return contractCardDto;
        }
        catch (IOException e) {
            throw new BGException(e);
        }
        catch (FOPException e) {
            throw new BGException(e);
        }
        catch (ParserConfigurationException e) {
            throw new BGException(e);
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        catch (XMLStreamException e) {
            throw new BGException(e);
        }
    }
}

