/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.bean;

import bitel.billing.server.contract.bean.ContractUtils;
import jakarta.xml.ws.Holder;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class PaymentDao
extends AbstractIdDao<Payment> {
    public PaymentDao(Connection con) {
        super(con, -1, "contract_payment");
    }

    public SearchResult<Payment> getPaymentList(int contractId, Period period, int members) throws BGException {
        SearchResult<Payment> searchResult = new SearchResult<Payment>(period, null);
        this.searchPaymentList(searchResult, contractId, members);
        return searchResult;
    }

    public void searchPaymentList(SearchResult<Payment> searchResult, int contractId, int members) throws BGException {
        this.searchPaymentList(searchResult, Utils.toIntegerList(ContractUtils.getCidsStringForQuery((int)contractId, (int)members, (Connection)this.con)));
    }

    public List<Payment> getPaymentList(List<Integer> contractIds, Period period, Holder<BigDecimal> totalSum) throws BGException {
        SearchResult<Payment> searchResult = new SearchResult<Payment>();
        searchResult.setPeriod(period);
        this.searchPaymentList(searchResult, contractIds);
        if (totalSum != null) {
            totalSum.value = searchResult.getSum();
        }
        return searchResult.getList();
    }

    public void searchPaymentList(SearchResult<Payment> searchResult, List<Integer> contractIds) throws BGException {
        if (searchResult == null || contractIds == null || contractIds.isEmpty()) {
            return;
        }
        int index = 1;
        Period period = searchResult.getPeriod();
        List<Payment> result = searchResult.getList();
        StringBuilder query = new StringBuilder("SELECT p.id, p.cid, p.comment, p.dt, p.pt, p.summa, p.uid, p.lm FROM " + this.tableName + " AS p WHERE p.cid IN (" + Utils.toString(contractIds) + ")");
        if (period != null) {
            if (period.getDateFrom() != null) {
                query.append(" AND dt>=?");
            }
            if (period.getDateTo() != null) {
                query.append(" AND dt<=?");
            }
        }
        query.append(" ORDER BY dt");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            if (period != null && period.getDateFrom() != null) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate(period.getDateFrom()));
            }
            if (period != null && period.getDateTo() != null) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate(period.getDateTo()));
            }
            ResultSet rs = ps.executeQuery();
            BigDecimal sumL = BigDecimal.ZERO;
            while (rs.next()) {
                sumL = sumL.add(rs.getBigDecimal("summa"));
                result.add(this.getFromRS(rs));
            }
            searchResult.setSum(sumL);
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void searchLastPaymentList(SearchResult<Payment> searchResult, int contractId, int members, int lastPayments) throws BGException {
        this.searchLastPaymentList(searchResult, Utils.toIntegerList(ContractUtils.getCidsStringForQuery((int)contractId, (int)members, (Connection)this.con)), lastPayments);
    }

    public void searchLastPaymentList(SearchResult<Payment> searchResult, List<Integer> contractIds, int lastPayments) throws BGException {
        if (searchResult == null || contractIds == null || contractIds.isEmpty()) {
            return;
        }
        List<Payment> result = searchResult.getList();
        StringBuilder query = new StringBuilder("SELECT p.id, p.cid, p.comment, p.dt, p.pt, p.summa, p.uid, p.lm FROM " + this.tableName + " AS p WHERE p.cid IN (" + Utils.toString(contractIds) + ")");
        query.append(" ORDER BY dt DESC");
        if (lastPayments > 0) {
            query.append(" LIMIT ").append(lastPayments);
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ResultSet rs = ps.executeQuery();
            BigDecimal sumL = BigDecimal.ZERO;
            while (rs.next()) {
                sumL = sumL.add(rs.getBigDecimal("summa"));
                result.add(this.getFromRS(rs));
            }
            searchResult.setSum(sumL);
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    @Override
    protected void updateImpl(Payment payment) throws BGException {
        if (payment == null) {
            return;
        }
        boolean update = payment.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET dt=?, cid=?, pt=?, uid=?, summa=?, comment=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(payment.getDate()));
            ps.setInt(index++, payment.getContractId());
            ps.setInt(index++, payment.getTypeId());
            ps.setInt(index++, payment.getUserId());
            ps.setBigDecimal(index++, payment.getSum());
            ps.setString(index++, payment.getComment());
            if (update) {
                ps.setInt(index++, payment.getId());
            }
            ps.executeUpdate();
            if (!update) {
                payment.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    public void zeroBalancePayment(Date date, int contractId, int paymentTypeId) throws BGException {
        this.zeroBalancePayment(date, contractId, paymentTypeId, "\u0412\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 \u0434\u043b\u044f \u043e\u0431\u043d\u0443\u043b\u0435\u043d\u0438\u044f \u0431\u0430\u043b\u0430\u043d\u0441\u0430");
    }

    public void zeroBalancePayment(Date date, int contractId, int paymentTypeId, String paymentComment) throws BGException {
        if (date != null) {
            try (BalanceUtils balanceUtils = new BalanceUtils(this.con);){
                BigDecimal balance = balanceUtils.getBalance(date, contractId);
                if (balance.compareTo(BigDecimal.ZERO) >= 0) {
                    return;
                }
                BigDecimal delta = balance.abs();
                this.update(Payment.builder().setTypeId(paymentTypeId).setContractId(contractId).setDate(date).setSum(delta).setComment(paymentComment).setUserId(0).build());
                balanceUtils.updateBalance(date, contractId);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<Payment> getPaymentsById(String idList) throws BGException {
        if (Utils.isBlankString(idList)) {
            return new ArrayList<Payment>();
        }
        String query = "SELECT * FROM " + this.tableName + " WHERE id IN (" + idList + ")";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            List<Payment> list;
            block15: {
                ResultSet rs = ps.executeQuery();
                try {
                    list = this.getListFromRS(rs);
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    @Override
    protected int deleteImpl(int id) throws BGException, SQLException {
        String query = "INSERT INTO " + this.tableName + "_deleted SELECT * FROM " + this.tableName + " WHERE id=" + id;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.executeUpdate();
        }
        return super.deleteImpl(id);
    }

    public void deletePaymentsById(String idList) throws BGException {
        PreparedStatement ps;
        if (Utils.isEmptyString(idList)) {
            return;
        }
        String query = "INSERT INTO " + this.tableName + "_deleted SELECT * FROM " + this.tableName + " WHERE id IN (" + idList + ")";
        try {
            ps = this.con.prepareStatement(query);
            try {
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            throw new BGException("error delete payments by id", e);
        }
        query = "DELETE FROM " + this.tableName + " WHERE id IN (" + idList + ")";
        try {
            ps = this.con.prepareStatement(query);
            try {
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            throw new BGException("error delete payments by id", e);
        }
    }

    @Override
    protected Payment getFromRS(ResultSet rs) throws SQLException, BGException {
        return Payment.builder().setId(rs.getInt("id")).setTypeId(rs.getInt("pt")).setContractId(rs.getInt("cid")).setDate(rs.getDate("dt")).setSum(rs.getBigDecimal("summa")).setComment(rs.getString("comment")).setUserId(rs.getInt("uid")).setTimeChange(rs.getTimestamp("lm")).build();
    }
}

