/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.config.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.kernel.contract.config.common.bean.ContractModuleConfig;
import ru.bitel.bgbilling.kernel.contract.config.common.service.ContractModuleConfigService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.SearchResult;

public class ContractModuleConfigPanel
extends BGUPanel {
    private JList<String> keyList = null;
    private JLabel recordLabel = new JLabel("");
    private BGTextField contractTitle = new BGTextField(15);
    private BGUTable contractModuleConfigTable = null;
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private ContractModuleConfigTableModel contractModuleConfigTableModel = null;
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        @Override
        public void actionPerformedImpl(ActionEvent event) throws Exception {
            ContractModuleConfigPanel.this.searchContractModuleConfig();
        }
    };
    AbstractBGUPanel.DefaultAction newSearchAction = new AbstractBGUPanel.DefaultAction("newSearch", "\u041d\u043e\u0432\u044b\u0439 \u043f\u043e\u0438\u0441\u043a"){

        @Override
        public void actionPerformedImpl(ActionEvent event) throws Exception {
            ContractModuleConfigPanel.this.pagePanel.init();
            ContractModuleConfigPanel.this.searchContractModuleConfig();
        }
    };
    AbstractBGUPanel.DefaultAction clearKeyListSelection = new AbstractBGUPanel.DefaultAction("clearKeyListSelection", "X"){

        @Override
        public void actionPerformedImpl(ActionEvent event) throws Exception {
            ContractModuleConfigPanel.this.keyList.clearSelection();
        }
    };
    AbstractBGUPanel.DefaultAction initKeyList = new AbstractBGUPanel.DefaultAction("initKeyList", "R"){

        @Override
        public void actionPerformedImpl(ActionEvent event) throws Exception {
            DefaultListModel listModel = new DefaultListModel();
            ((ClientContext)ContractModuleConfigPanel.this.getContext()).getPort(ContractModuleConfigService.class, 0).getKeyList(((ClientContext)ContractModuleConfigPanel.this.getContext()).getModuleId()).forEach(a -> listModel.addElement(a));
            ContractModuleConfigPanel.this.keyList.setModel(listModel);
        }
    };

    @Override
    protected void jbInit() throws Exception {
        this.contractModuleConfigTableModel = new ContractModuleConfigTableModel();
        this.contractModuleConfigTable = new BGUTable(this.contractModuleConfigTableModel);
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, this.getFilterPanel(), (Component)this.getDataPanel(), 200L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.performAction("initKeyList");
        this.pagePanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                ContractModuleConfigPanel.this.performAction("refresh");
            }
        });
        this.keyList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting()) {
                    ContractModuleConfigPanel.this.performAction("newSearch");
                }
            }
        });
    }

    private JPanel getFilterPanel() {
        this.keyList = new JList();
        this.keyList.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.keyList.setSelectionMode(2);
        int gridX = 0;
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)new JLabel("\u0424\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u043a\u043b\u044e\u0447\u0430\u043c:"), new GridBagConstraints(gridX++, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 2, 2), 0, 0));
        topPanel.add((Component)new SButton(this.clearKeyListSelection, "X", "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u043a\u043b\u044e\u0447\u0435\u0439"), new GridBagConstraints(gridX++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 2), 0, 0));
        topPanel.add((Component)new SButton(this.initKeyList, null, "\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u043a\u043b\u044e\u0447\u0435\u0439"), new GridBagConstraints(gridX++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 2, 2), 0, 0));
        panel.add((Component)new JScrollPane(this.keyList), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 2), 0, 0));
        return panel;
    }

    private JPanel getDataPanel() {
        int gridY = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getNavigationPanel(), new GridBagConstraints(0, gridY++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 2, 0, 0), 0, 0));
        panel.add((Component)this.getTablePanel(), new GridBagConstraints(0, gridY++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 2, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getNavigationPanel() {
        this.contractTitle.setHorizontalAlignment(0);
        this.contractTitle.setAction(this.newSearchAction);
        int gridX = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0424\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443:"), new GridBagConstraints(gridX++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.contractTitle, new GridBagConstraints(gridX++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)this.recordLabel, new GridBagConstraints(gridX++, 0, 1, 1, 1.0, 0.0, 13, 3, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)this.pagePanel, new GridBagConstraints(gridX++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getTablePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.contractModuleConfigTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private void searchContractModuleConfig() throws Exception {
        String[] selectedValues = this.keyList.getSelectedValuesList().toArray(new String[0]);
        SearchResult<ContractModuleConfig> searchResult = ((ClientContext)this.getContext()).getPort(ContractModuleConfigService.class, 0).searchContractModuleConfig(((ClientContext)this.getContext()).getModuleId(), this.contractTitle.getText(), selectedValues, this.contractModuleConfigTable.getSort(), this.pagePanel.getPage());
        this.contractModuleConfigTableModel.setData(searchResult.getList());
        this.pagePanel.setPage(searchResult.getPage());
        this.recordLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
    }

    private class ContractModuleConfigTableModel
    extends BGTableModel<ContractModuleConfig> {
        public ContractModuleConfigTableModel() {
            super(ContractModuleConfigPanel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 100, 150, 200, "contractTitle", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u041a\u043b\u044e\u0447", 100, 250, 300, "key", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 100, -1, -1, "value", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
        }
    }

    private class SButton
    extends JButton {
        public SButton(Action action, String text, String toolTipText) {
            this.setMargin(new Insets(0, 2, 0, 2));
            if (action != null) {
                this.setAction(action);
            }
            if (text != null) {
                this.setText(text);
            }
            this.setToolTipText(toolTipText);
        }
    }
}

