/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.label.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelItem;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelType;
import ru.bitel.bgbilling.kernel.contract.label.server.service.ContractLabelServiceImpl;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class ContractLabelManager {
    protected static final String TABLE_CONTRACT_LABEL = "contract_label";
    protected static final String TABLE_CONTRACT_LABEL_LINK = "contract_label_link";
    private Connection con;

    public ContractLabelManager(Connection con) {
        this.con = con;
    }

    public List<ContractLabelItem> getContractLabelItemList(boolean calcCount) throws BGException {
        ArrayList<ContractLabelItem> result = new ArrayList<ContractLabelItem>();
        try {
            HashMap<Integer, ContractLabelItem> map = new HashMap<Integer, ContractLabelItem>();
            ContractLabelItem groups = this.getRootLabelItem(1, "\u0413\u0440\u0443\u043f\u043f\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", ContractLabelType.GROUP);
            ContractLabelItem labels = this.getRootLabelItem(100, "\u041c\u0435\u0442\u043a\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", ContractLabelType.LABEL);
            result.add(groups);
            result.add(labels);
            Statement st = this.con.createStatement();
            StringBuilder query = new StringBuilder("SELECT * FROM ").append(TABLE_CONTRACT_LABEL).append(" ORDER BY title");
            ResultSet rs = st.executeQuery(query.toString());
            while (rs.next()) {
                groups = this.getContractLabelItemFromRS(rs);
                map.put(groups.getId(), groups);
                result.add(groups);
            }
            rs.close();
            if (calcCount) {
                query.setLength(0);
                query.append("SELECT label_id, count(*) FROM ").append(TABLE_CONTRACT_LABEL_LINK).append(" GROUP BY label_id");
                rs = st.executeQuery(query.toString());
                while (rs.next()) {
                    groups = (ContractLabelItem)map.get(rs.getInt(1));
                    if (groups == null) continue;
                    groups.setContractLinkCount(rs.getInt(2));
                }
                rs.close();
            }
            st.close();
            List<ContractLabelItem> onlyLabels = result.stream().filter(label -> label.getContractLabelType().equals((Object)ContractLabelType.LABEL_ITEM)).collect(Collectors.toList());
            if (!this.checkSorting(onlyLabels)) {
                this.toCorrectSortingValues(onlyLabels);
            }
            Collections.sort(result);
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return result;
    }

    private boolean checkSorting(List<ContractLabelItem> labels) {
        return labels.stream().filter(item -> item.getSortPosition() == 0).count() == 1L;
    }

    private void toCorrectSortingValues(List<ContractLabelItem> labels) throws SQLException {
        String query = "update contract_label set sort_position=? where id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            for (int x = 0; x < labels.size(); ++x) {
                ps.setInt(1, x);
                ps.setInt(2, labels.get(x).getId());
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }

    public List<Integer> getContractLabelIds(int contractId) throws BGException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        String query = "SELECT label_id FROM contract_label_link WHERE contract_id=" + contractId;
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public void setContractLabelIds(int contractId, List<Integer> ids) throws BGException {
        HashSet<Integer> labelIds = new HashSet<Integer>(ids);
        try {
            StringBuilder query = new StringBuilder("DELETE FROM ").append(TABLE_CONTRACT_LABEL_LINK).append(" WHERE contract_id=").append(contractId);
            try (Statement st = this.con.createStatement();){
                st.executeUpdate(query.toString());
            }
            query.setLength(0);
            query.append("INSERT INTO ").append(TABLE_CONTRACT_LABEL_LINK).append(" SET contract_id=").append(contractId).append(", label_id=?");
            try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
                for (Integer id : labelIds) {
                    ps.setInt(1, id);
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            ArrayList groupIds = new ArrayList();
            labelIds.forEach(i -> {
                if (i < 66) {
                    groupIds.add(i - 2);
                }
            });
            long groups = Utils.enumToMask(Utils.toString(groupIds, ","));
            try (PreparedStatement psUpdate = this.con.prepareStatement("UPDATE contract SET gr=? WHERE id=?");){
                psUpdate.setLong(1, groups);
                psUpdate.setInt(2, contractId);
                psUpdate.executeUpdate();
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    public void updateContractLabelTreeItem(ContractLabelItem contractLabelItem) throws BGException {
        try {
            Object query;
            boolean addAfterGroups;
            String maxIdQuery = "SELECT MAX(id) AS maxId FROM contract_label";
            int maxIdInTable = 0;
            try (Statement maxSt = this.con.createStatement();
                 ResultSet maxRs = maxSt.executeQuery(maxIdQuery);){
                if (maxRs.next()) {
                    maxIdInTable = maxRs.getInt("maxId");
                }
            }
            boolean bl = addAfterGroups = contractLabelItem.getId() <= 0 && maxIdInTable < 100;
            if (contractLabelItem.getId() <= 0) {
                contractLabelItem.setSortPosition(this.getNextSortPosition());
                query = "INSERT INTO contract_label SET parent_id=?, title=?, type=?, sort_position=?, comment=?, forbidden=?";
            } else {
                query = "UPDATE contract_label SET parent_id=?, title=?, type=?, sort_position=?, comment=?, forbidden=? WHERE id=?";
            }
            if (addAfterGroups) {
                query = (String)query + ", id=101";
            }
            try (PreparedStatement ps = this.con.prepareStatement((String)query);){
                int index = 1;
                ps.setInt(index++, contractLabelItem.getParentId());
                ps.setString(index++, contractLabelItem.getTitle());
                ps.setInt(index++, contractLabelItem.getContractLabelType().ordinal());
                ps.setInt(index++, contractLabelItem.getSortPosition());
                ps.setString(index++, contractLabelItem.getComment());
                ps.setInt(index++, contractLabelItem.isForbiddenEdit() ? 1 : 0);
                if (contractLabelItem.getId() > 0 && !addAfterGroups) {
                    ps.setInt(index++, contractLabelItem.getId());
                }
                ps.executeUpdate();
                if (contractLabelItem.getId() <= 0 && !addAfterGroups) {
                    contractLabelItem.setId(ServerUtils.lastInsertId((Connection)this.con));
                }
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    private int getNextSortPosition() throws SQLException {
        int sortPosition = 0;
        String query = "SELECT if( isnull( max(sort_position) ), 1, max(sort_position) + 1 ) FROM contract_label";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            if (rs.next()) {
                sortPosition = rs.getInt(1);
            }
        }
        return sortPosition;
    }

    public void removeContractLabelItem(int contractLabelItemId) throws BGException {
        try (Statement st = this.con.createStatement();){
            StringBuilder query = new StringBuilder("DELETE FROM ").append(TABLE_CONTRACT_LABEL_LINK).append(" WHERE label_id=").append(contractLabelItemId);
            st.executeUpdate(query.toString());
            query.setLength(0);
            query.append("DELETE FROM ").append(TABLE_CONTRACT_LABEL).append(" WHERE id=").append(contractLabelItemId);
            st.executeUpdate(query.toString());
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    private ContractLabelItem getContractLabelItemFromRS(ResultSet rs) throws SQLException {
        ContractLabelItem contractLabelItem = new ContractLabelItem();
        contractLabelItem.setId(rs.getInt("id"));
        contractLabelItem.setParentId(rs.getInt("parent_id"));
        contractLabelItem.setTitle(rs.getString("title"));
        contractLabelItem.setContractLabelType(ContractLabelType.getType(rs.getInt("type")));
        contractLabelItem.setSortPosition(rs.getInt("sort_position"));
        contractLabelItem.setComment(rs.getString("comment"));
        contractLabelItem.setForbiddenEdit(rs.getInt("forbidden") == 1);
        return contractLabelItem;
    }

    public ContractLabelItem getTree() throws BGException {
        ContractLabelItem root = this.getRootLabelItem(1, "\u0413\u0440\u0443\u043f\u043f\u044b \u0438 \u043c\u0435\u0442\u043a\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", ContractLabelType.GROUP);
        ContractLabelItem labels = this.getRootLabelItem(100, "\u041c\u0435\u0442\u043a\u0438", ContractLabelType.LABEL);
        ArrayList<ContractLabelItem> contractLabelItems = new ArrayList<ContractLabelItem>();
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT * FROM contract_label");
            while (rs.next()) {
                ContractLabelItem labelItemFromRS = this.getContractLabelItemFromRS(rs);
                contractLabelItems.add(labelItemFromRS);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        for (ContractLabelItem item : contractLabelItems) {
            if (item.getParentId() == root.getId()) {
                root.addChild(item);
                this.addChild(item.getId(), item, contractLabelItems);
                continue;
            }
            if (item.getParentId() != labels.getId()) continue;
            labels.addChild(item);
            this.addChild(item.getId(), item, contractLabelItems);
        }
        root.addChild(labels);
        return root;
    }

    public void syncLabelAndGroupDirectory() throws BGException {
        try {
            Statement st = this.con.createStatement();
            st.executeUpdate("DELETE FROM contract_label WHERE id < 66");
            st.close();
            st = this.con.createStatement();
            st.executeUpdate("INSERT INTO contract_label ( id, parent_id, type, title, comment, forbidden ) SELECT id+2, 1, 1, title, comment, IF(editable, 0, 1) FROM contract_group WHERE enable=1");
            st.close();
        }
        catch (Exception e) {
            LogManager.getLogger(ContractLabelServiceImpl.class).error((Object)e);
            throw new BGException(e);
        }
    }

    public void syncLabelAndGroupContract(int contractId) throws BGException {
        block38: {
            try {
                boolean all = contractId < 1;
                try (PreparedStatement psDelete = this.con.prepareStatement("DELETE FROM contract_label_link WHERE label_id < 66" + (all ? "" : " AND contract_id=?"));){
                    if (!all) {
                        psDelete.setInt(1, contractId);
                    }
                    psDelete.executeUpdate();
                }
                try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO contract_label_link ( contract_id, label_id ) SELECT id, ? FROM contract WHERE gr&(1<<?)>0");
                     PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO contract_label_link SET contract_id=?, label_id=?");
                     PreparedStatement psSelect = this.con.prepareStatement("SELECT id, gr FROM contract WHERE gr > 0 AND id=?");){
                    if (all) {
                        for (int i = 0; i < 64; ++i) {
                            ps.setInt(1, i + 2);
                            ps.setInt(2, i);
                            ps.executeUpdate();
                        }
                        break block38;
                    }
                    psSelect.setInt(1, contractId);
                    try (ResultSet rs = psSelect.executeQuery();){
                        while (rs.next()) {
                            psInsert.setInt(1, rs.getInt(1));
                            for (int pos = 0; pos < 64; ++pos) {
                                if ((rs.getLong(2) & 1L << pos) <= 0L) continue;
                                psInsert.setInt(2, pos + 2);
                                psInsert.executeUpdate();
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new BGException(e);
            }
        }
    }

    protected void addChild(int up, ContractLabelItem rootItem, List<ContractLabelItem> list) {
        for (ContractLabelItem listItem : list) {
            if (up != listItem.getParentId()) continue;
            rootItem.addChild(listItem);
            this.addChild(listItem.getId(), listItem, list);
        }
    }

    private ContractLabelItem getRootLabelItem(int id, String title, ContractLabelType type) {
        ContractLabelItem result = new ContractLabelItem();
        result.setId(id);
        result.setTitle(title);
        result.setContractLabelType(type);
        result.setSelected(false);
        result.setParentId(0);
        result.setSortPosition(type.equals((Object)ContractLabelType.GROUP) ? 1 : 2);
        return result;
    }

    public Map<Integer, List<Integer>> getContractListWithLabels() throws BGException {
        HashMap<Integer, List<Integer>> contractLabels = new HashMap<Integer, List<Integer>>();
        String query = "select c.id, label.label_id from contract as c left join contract_label_link as label on c.id=label.contract_id where label.label_id>0 order by c.id";
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            int tempCid = 0;
            while (rs.next()) {
                int cid = rs.getInt("c.id");
                if (cid != tempCid) {
                    tempCid = cid;
                    ArrayList<Integer> labelIds = new ArrayList<Integer>();
                    labelIds.add(rs.getInt("label.label_id"));
                    contractLabels.put(cid, labelIds);
                    continue;
                }
                ((List)contractLabels.get(cid)).add(rs.getInt("label.label_id"));
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return contractLabels;
    }

    public int getContractCountByLabel(int labelId) throws BGException {
        int contractCount = 0;
        String query = "select count(*) as count from contract_label_link where label_id=" + labelId;
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            if (rs.next()) {
                contractCount = rs.getInt("count");
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return contractCount;
    }
}

