/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.loader.client.utils;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.loader.client.UtilPanel;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.IdTitle;

public class ImportInetAccountPanel
extends UtilPanel {
    public static final String TITLE = "\u0418\u043c\u043f\u043e\u0440\u0442 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u043e\u0432 Inet";
    public static final String CARD_NAME = "importInetAccount";
    private InetServType inetServType;
    private JTextArea info = new JTextArea(6, 30);
    private BGUComboBox<IdTitle> inetModules = new BGUComboBox();
    private BGUComboBox<IdTitle> inetServTypes = new BGUComboBox();
    private AtomicReference<String> data = new AtomicReference();
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", ""){

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            ArrayList<IdTitle> inetModuleItems = new ArrayList<IdTitle>();
            inetModuleItems.add(new IdTitle(0, "--- \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d ---"));
            inetModuleItems.addAll(((ClientContext)ImportInetAccountPanel.this.getContext()).getWebService(ModuleService.class, 0).moduleByNameList("inet").stream().map(IdTitle::toIdTitle).toList());
            ImportInetAccountPanel.this.inetModules.setData(inetModuleItems);
        }
    };

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)new UtilPanel.PanelTitleLabel(TITLE), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        this.add((Component)this.getColumnPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(15, 5, 2, 5), 0, 0));
        this.add((Component)this.getButtonPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getColumnPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 2, 10, 0));
        panel.add(this.getSourcePanel());
        panel.add(this.getImportResultPanel());
        return panel;
    }

    private JPanel getSourcePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getInetServTypePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.getInfoPanel(this.info), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.getDataPanel(this.data), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.getFilePanel(this.data), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getInetServTypePanel() {
        this.inetModules.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.loadInetServTypes();
            }
        });
        this.inetServTypes.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.setInfo();
            }
        });
        this.loadInetServTypes();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041c\u043e\u0434\u0443\u043b\u044c \u0438\u043d\u0442\u0435\u0440\u043d\u0435\u0442\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel("\u0422\u0438\u043f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        panel.add(this.inetModules, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 5, 5, 5), 0, 0));
        panel.add(this.inetServTypes, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 5, 5), 0, 0));
        return panel;
    }

    private void loadInetServTypes() {
        Async.of(() -> {
            ArrayList<IdTitle> items = new ArrayList<IdTitle>();
            items.add(new IdTitle(0, "--- \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d ---"));
            IdTitle module = (IdTitle)this.inetModules.getSelectedItem();
            if (module != null && module.getId() > 0) {
                try {
                    items.addAll(((ClientContext)this.getContext()).getWebService(InetServService.class, module.getId()).inetServTypeTitleList());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
            this.inetServTypes.setData(items);
        });
    }

    private void setInfo() {
        Object text = "";
        IdTitle inetServTypeItem = (IdTitle)this.inetServTypes.getSelectedItem();
        if (inetServTypeItem != null && inetServTypeItem.getId() > 0) {
            IdTitle module = (IdTitle)this.inetModules.getSelectedItem();
            try {
                this.inetServType = ((ClientContext)this.getContext()).getWebService(InetServService.class, module.getId()).inetServTypeGet(inetServTypeItem.getId());
                text = (String)text + "\u041d\u041e\u041c\u0415\u0420_\u0414\u041e\u0413\u041e\u0412\u041e\u0420\u0410<TAB>\u0414\u0410\u0422\u0410_\u041d\u0410\u0427\u0410\u041b\u0410<TAB>\u041a\u041e\u041b\u0418\u0427\u0415\u0421\u0422\u0412\u041e_\u0421\u0415\u0421\u0421\u0418\u0419";
                if (this.inetServType.isNeedLogin()) {
                    text = (String)text + "<TAB>\u041b\u041e\u0413\u0418\u041d<TAB>\u041f\u0410\u0420\u041e\u041b\u042c";
                }
                if (this.inetServType.isNeedMacAddress()) {
                    text = (String)text + "<TAB>MAC_\u0410\u0414\u0420\u0415\u0421";
                }
                if (this.inetServType.isNeedVlan()) {
                    text = (String)text + "<TAB>VLAN";
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
        this.info.setText((String)text);
    }

    @Override
    protected void doUtil() {
        IdTitle module = (IdTitle)this.inetModules.getSelectedItem();
        if (module == null || module.getId() == 0) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043c\u043e\u0434\u0443\u043b\u044c");
            return;
        }
        IdTitle inetServTypeItem = (IdTitle)this.inetServTypes.getSelectedItem();
        if (inetServTypeItem == null || inetServTypeItem.getId() == 0) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430");
            return;
        }
        JSONObject config = new JSONObject();
        config.put("moduleId", module.getId());
        config.put("inetServTypeId", inetServTypeItem.getId());
        try {
            this.importResult.setText(this.getLoaderService().doUtil("ru.bitel.bgbilling.kernel.contract.loader.server.utils.LoaderImportInetServUtil", this.data.get(), config.toString()));
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }
}

