/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.loader.server.utils;

import java.text.DateFormat;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.loader.server.bean.LoaderUtil;
import ru.bitel.bgbilling.kernel.contract.loader.server.utils.LoaderBase;
import ru.bitel.common.TimeUtils;

public class LoaderSetContractPeriodUtil
extends LoaderBase
implements LoaderUtil {
    @Override
    public String execute(String data, String config) throws BGException {
        StringBuffer result = new StringBuffer();
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            int count = 0;
            DateFormat dateFormat = TimeUtils.getDateFormat("dd.MM.yyyy");
            for (String line : data.split("\n")) {
                String[] lineData = line.split("\t");
                if (lineData.length < 2 && lineData.length > 3) {
                    result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 => " + line + "\n");
                    continue;
                }
                Contract contract = contractDao.getByTitle(lineData[0]);
                if (contract == null) {
                    result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 => " + line + " => \u0414\u043e\u0433\u043e\u0432\u043e\u0440 \"" + lineData[0] + "\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\n");
                    continue;
                }
                Date date = TimeUtils.parseDate(lineData[1], dateFormat);
                if (date == null) {
                    result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 => " + line + " => \u0414\u0430\u0442\u0430 \"" + lineData[1] + "\" \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f\n");
                    continue;
                }
                contract.setDateFrom(date);
                if (lineData.length == 3) {
                    date = TimeUtils.parseDate(lineData[2], dateFormat);
                    if (date == null) {
                        result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 => " + line + " => \u0414\u0430\u0442\u0430 \"" + lineData[2] + "\" \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f\n");
                        continue;
                    }
                    contract.setDateTo(date);
                }
                contractDao.update(contract);
                ++count;
            }
            result.insert(0, "\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 -> " + count + "\n\n");
        }
        return result.toString();
    }
}

