/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.server.bean;

import bitel.billing.server.contract.object.bean.ObjectManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterListItem;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObjectParam;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObjectType;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryFactory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttr;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;

public class ContractObjectDao
extends AbstractEntityAttrDao<ContractObject> {
    public ContractObjectDao(Connection con, int userId) {
        super(con, 0, userId, "object", "object", CONTRACT_OBJECT_SUPPORT);
    }

    public EntityAttr getObjectParameter(int objectId, int parameterId) throws BGException {
        return this.getEntityAttribute(objectId, parameterId);
    }

    protected EntityAttr getEntityAttribute(int entityId, int entityAttrId) throws BGException {
        if (entityAttrId <= 0) {
            return null;
        }
        EntitySpecAttr specAttr = this.getEntitySpecAttr(entityAttrId);
        if (specAttr == null) {
            return null;
        }
        return this.getAttribute(entityId, specAttr);
    }

    protected EntitySpecAttr getEntitySpecAttr(int entitySpecAttrId) throws BGException {
        EntitySpecAttr specAttr = null;
        String query = "SELECT * FROM object_param WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, entitySpecAttrId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    specAttr = EntitySpecAttr.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).setType(ContractObjectDao.toEntityType(rs.getInt("type"))).setComment(rs.getString("comment")).build();
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return specAttr;
    }

    private static int toEntityType(int pt) {
        switch (pt) {
            case 1: {
                return EntitySpecAttrType.TEXT.getCode();
            }
            case 2: {
                return EntitySpecAttrType.LIST.getCode();
            }
            case 3: {
                return EntitySpecAttrType.DATE.getCode();
            }
            case 4: {
                return EntitySpecAttrType.ADDRESS.getCode();
            }
            case 5: {
                return EntitySpecAttrType.BOOLEAN.getCode();
            }
        }
        return 0;
    }

    public boolean updateObjectParameter(int objectId, EntityAttr entityAttr) throws BGException {
        try {
            boolean result = super.updateEntityAttribute(objectId, entityAttr);
            ObjectManager objectManager = new ObjectManager(this.con);
            ContractObject object = objectManager.getObject(entityAttr.getEntityId());
            objectManager.saveTitleByMacros(object);
            return result;
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public Optional<EntityAttrText> optObjectParameterText(int objectId, int parameterId) throws BGException {
        return super.optEntityAttribute(objectId, parameterId).filter(a -> a instanceof EntityAttrText).map(a -> (EntityAttrText)a);
    }

    public Optional<String> optObjectParameterTextAsString(int objectId, int parameterId) throws BGException {
        return this.optObjectParameterText(objectId, parameterId).map(EntityAttrText::getValue);
    }

    public Optional<EntityAttrBoolean> optObjectParameterBoolean(int objectId, int parameterId) throws BGException {
        return super.optEntityAttribute(objectId, parameterId).filter(a -> a instanceof EntityAttrBoolean).map(a -> (EntityAttrBoolean)a);
    }

    public Optional<Boolean> optObjectParameterBooleanAsBoolean(int objectId, int parameterId) throws BGException {
        return this.optObjectParameterBoolean(objectId, parameterId).map(EntityAttrBoolean::getValue);
    }

    public Optional<EntityAttrDate> optObjectParameterDate(int objectId, int parameterId) throws BGException {
        return super.optEntityAttribute(objectId, parameterId).filter(a -> a instanceof EntityAttrDate).map(a -> (EntityAttrDate)a);
    }

    public Optional<Date> optObjectParameterDateAsDate(int objectId, int parameterId) throws BGException {
        return this.optObjectParameterDate(objectId, parameterId).map(EntityAttrDate::getValue);
    }

    public Optional<EntityAttrList> optObjectParameterList(int objectId, int parameterId) throws BGException {
        return super.optEntityAttribute(objectId, parameterId).filter(a -> a instanceof EntityAttrList).map(a -> (EntityAttrList)a);
    }

    public Optional<String> optObjectParameterListAsString(int objectId, int parameterId) throws BGException {
        Directory<ContractParameterListItem> directory = ServerDirectoryFactory.newUnmodifiableDirectory(ContractParameterListItem.class, this.con, parameterId, true);
        return this.optObjectParameterList(objectId, parameterId).map(a -> a.getValue() > 0 ? (String)directory.opt(a.getValue()).map(b -> b.getTitle()).orElse(null) : a.getTitle());
    }

    public Optional<EntityAttrAddress> optObjectParameterAddress(int objectId, int parameterId) throws BGException {
        return super.optEntityAttribute(objectId, parameterId).filter(a -> a instanceof EntityAttrAddress).map(a -> (EntityAttrAddress)a);
    }

    public Optional<String> getObjectParameterAddressAsString(int contractId, int parameterId) throws BGException {
        return this.optObjectParameterAddress(contractId, parameterId).map(EntityAttrAddress::getTitle);
    }

    public Directory<? extends EntitySpec> getEntitySpecDirectory() throws BGException {
        if (this.entitySpecDirectory == null) {
            this.entitySpecDirectory = ServerDirectoryFactory.newUnmodifiableDirectory(ContractObjectType.class, this.con, 0, true);
        }
        return this.entitySpecDirectory;
    }

    protected Directory<? extends EntitySpecAttr> getEntitySpecAttrDirectory() throws BGException {
        if (this.entitySpecAttrDirectory == null) {
            this.entitySpecAttrDirectory = ServerDirectoryFactory.newUnmodifiableDirectory(ContractObjectParam.class, this.con, 0, true);
        }
        return this.entitySpecAttrDirectory;
    }

    public void contractObjectTable(SearchResult<ContractObject> searchResult, int contractId, String titleFilter, int typeId) throws BGException {
        List<ContractObject> list = searchResult.getList();
        Page page = searchResult.getPage();
        StringBuilder query = new StringBuilder("SELECT SQL_CALC_FOUND_ROWS * FROM ").append(this.tableName).append(" WHERE cid=").append(contractId);
        if (typeId > 0) {
            query.append(" AND type_id=").append(typeId);
        }
        if (Utils.notBlankString(titleFilter)) {
            query.append(" AND title REGEXP ?");
        }
        query.append(" ORDER BY pos").append(page.sqlLimit());
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            if (Utils.notBlankString(titleFilter)) {
                ps.setString(1, titleFilter);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    list.add((ContractObject)((Object)this.getFromRS(rs)));
                }
            }
            page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    protected ContractObject getFromRS(ResultSet rs, boolean loadAttributes) throws SQLException, BGException {
        ContractObject result = new ContractObject();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("cid"));
        result.setTitle(rs.getString("title"));
        result.setTypeId(rs.getInt("type_id"));
        result.setDateFrom(rs.getDate("date1"));
        result.setDateTo(rs.getDate("date2"));
        result.setPosition(rs.getInt("pos"));
        return result;
    }

    protected void updateImpl(ContractObject contractObject) throws BGException, SQLException {
        boolean isUpdate = contractObject.getId() > 0;
        String set = " SET title=?, date1=?, date2=?, cid=?, type_id=?";
        String prefix = isUpdate ? "UPDATE " + this.tableName : "INSERT INTO " + this.tableName;
        String query = prefix + set;
        if (isUpdate) {
            query = query + " WHERE id=?";
        }
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setString(1, contractObject.getTitle() != null ? contractObject.getTitle().trim() : "");
            ps.setDate(2, TimeUtils.convertDateToSqlDate(contractObject.getDateFrom()));
            ps.setDate(3, TimeUtils.convertDateToSqlDate(contractObject.getDateTo()));
            ps.setInt(4, contractObject.getContractId());
            ps.setInt(5, contractObject.getTypeId());
            if (isUpdate) {
                ps.setInt(6, contractObject.getId());
            }
            ps.executeUpdate();
            if (!isUpdate) {
                contractObject.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        if (!isUpdate) {
            this.updateSortPosition(contractObject);
        }
    }

    private void updateSortPosition(ContractObject contractObject) throws SQLException {
        try (PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET pos=? WHERE id=?");){
            ps.setInt(1, contractObject.getId());
            ps.setInt(2, contractObject.getId());
            ps.executeUpdate();
        }
    }

    public List<ContractObject> list(int contractId) throws BGException {
        return super.list("cid=?", "pos", new Object[]{contractId});
    }

    public void orderObject(int id, boolean up) throws BGException {
        String query = up ? "SELECT id, pos FROM " + this.tableName + " WHERE cid=? AND pos<? AND id!=? ORDER BY pos DESC LIMIT 1" : "SELECT id, pos FROM " + this.tableName + " WHERE cid=? AND pos>? AND id!=? ORDER BY pos ASC LIMIT 1";
        try {
            ContractObject contractObject = (ContractObject)((Object)this.get(id));
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractObject.getContractId());
            ps.setInt(2, contractObject.getPosition());
            ps.setInt(3, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                int contrObjectId = rs.getInt(1);
                int contrObjectPos = rs.getInt(2);
                ps.close();
                ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET pos=? WHERE id=?");
                ps.setInt(1, contractObject.getPosition());
                ps.setInt(2, contrObjectId);
                ps.executeUpdate();
                ps.setInt(1, contrObjectPos);
                ps.setInt(2, id);
                ps.executeUpdate();
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }
}

