/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.server.service;

import bitel.billing.server.contract.object.bean.AddressParamValue;
import bitel.billing.server.contract.object.bean.DateParamValue;
import bitel.billing.server.contract.object.bean.FlagParamValue;
import bitel.billing.server.contract.object.bean.ListParamValue;
import bitel.billing.server.contract.object.bean.ListValueManager;
import bitel.billing.server.contract.object.bean.ObjectManager;
import bitel.billing.server.contract.object.bean.ObjectParam;
import bitel.billing.server.contract.object.bean.ObjectTypeManager;
import bitel.billing.server.contract.object.bean.ParamManager;
import bitel.billing.server.contract.object.bean.ParamValue;
import bitel.billing.server.contract.object.bean.ParamValueManager;
import bitel.billing.server.contract.object.bean.TextParamValue;
import bitel.billing.server.contract.object.bean.TypeParam;
import bitel.billing.server.contract.object.bean.TypeParamManager;
import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObjectParam;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ListValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectType;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectTypeParameter;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParameterHistoryEntry;
import ru.bitel.bgbilling.kernel.contract.object.common.dto.ContractObjectParameterDTO;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ContractObjectDao;
import ru.bitel.bgbilling.kernel.contract.object.server.utils.ObjectUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ContractAddObjectEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractDeleteObjectEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractObjectParameterBeforeUpdateEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractObjectParameterUpdateEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractUpdateObjectEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ObjectMoveEvent;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService")
public class ContractObjectServiceImpl
extends AbstractService
implements ContractObjectService {
    private ContractObjectDao contractObjectDao;
    private ParamValueManager paramValueManager;

    @PostConstruct
    protected void init() {
        this.contractObjectDao = new ContractObjectDao(this.getConnection(), this.userId);
        this.paramValueManager = new ParamValueManager(this.getConnection());
    }

    @Override
    public List<ContractObject> contractObjectList(int contractId) throws BGException {
        return this.contractObjectDao.list(contractId);
    }

    @Override
    public SearchResult<ContractObject> contractObjectTable(int contractId, String filterTitle, int filterType, Page page) throws BGException {
        SearchResult<ContractObject> searchResult = new SearchResult<ContractObject>();
        searchResult.setList(new ArrayList());
        searchResult.setPage(page);
        this.contractObjectDao.contractObjectTable(searchResult, contractId, filterTitle, filterType);
        return searchResult;
    }

    @Override
    public ContractObject contractObjectGetById(int contractId, int objectId) throws BGException {
        return (ContractObject)((Object)this.contractObjectDao.get(objectId));
    }

    @Override
    public int contractObjectUpdate(int contractId, ContractObject contractObject) throws BGException {
        boolean isNewObject;
        Date dateFromOld = null;
        Date dateToOld = null;
        boolean bl = isNewObject = contractObject.getId() <= 0;
        if (!isNewObject) {
            ContractObject old = (ContractObject)((Object)this.contractObjectDao.get(contractObject.getId()));
            if (old.getTypeId() != contractObject.getTypeId()) {
                throw new BGMessageException("\u041f\u0435\u0440\u0435\u0434\u0430\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430!");
            }
            dateFromOld = old.getDateFrom();
            dateToOld = old.getDateTo();
        }
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionObjectUpdate", (int)0, (int)this.userId);
        if (closedDate != null) {
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (Date)dateFromOld, (Date)dateToOld, (Date)contractObject.getDateFrom(), (Date)contractObject.getDateTo());
        }
        this.contractObjectDao.update((Object)contractObject);
        if (isNewObject) {
            this.context.publishAfterCommit(new ContractAddObjectEvent(this.userId, contractObject));
        } else {
            this.context.publishAfterCommit(new ContractUpdateObjectEvent(this.userId, contractObject));
        }
        return contractObject.getId();
    }

    @Override
    public void contractObjectDelete(int contractId, int objectId) throws BGException {
        ContractObject object = new ObjectManager(this.getConnection()).getObject(objectId);
        this.contractObjectDao.delete(objectId);
        this.paramValueManager.deleteActivityParamValues(objectId);
        EventProcessor.getInstance().request(new ObjectMoveEvent(this.userId, object.getContractId(), objectId, 0));
        this.context.publishAfterCommit(new ContractDeleteObjectEvent(this.userId, object));
    }

    @Override
    public void contractObjectClone(int contractId, int objectId, boolean clonePeriod) throws BGException {
        ContractObject original = (ContractObject)((Object)this.contractObjectDao.get(objectId));
        if (original == null) {
            throw new BGMessageException("\u041e\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        ContractObject copy = new ContractObject();
        copy.setContractId(original.getContractId());
        copy.setTitle(original.getTitle());
        copy.setEntitySpecId(original.getEntitySpecId());
        copy.setTypeId(original.getTypeId());
        copy.setEntityAttributes(original.getEntityAttributes());
        if (clonePeriod) {
            copy.setDateFrom(original.getDateFrom());
            copy.setDateTo(original.getDateTo());
        }
        this.contractObjectDao.update((Object)copy);
        this.paramValueManager.copyObjectParams(objectId, copy.getId());
    }

    @Override
    public void contractObjectOrder(int contractId, int objectId, boolean up) throws BGException {
        this.contractObjectDao.orderObject(objectId, up);
    }

    @Override
    public List<ContractObjectParameterDTO> contractObjectParameters(int contractId, int objectId) throws BGException, BGMessageException {
        ArrayList<ContractObjectParameterDTO> list = new ArrayList<ContractObjectParameterDTO>();
        Connection con = this.getConnection();
        ContractObject object = new ObjectManager(con).getObject(objectId);
        if (object == null) {
            return list;
        }
        ObjectType type = new ObjectTypeManager(con).getType(object.getTypeId());
        if (type == null) {
            return list;
        }
        Map listValuesMap = new ListValueManager(con).getValuesMap();
        Map paramMap = new ParamManager(con).getParamMap();
        List typeParamList = new TypeParamManager(con).getTypeParamList(type.getId());
        Map valuesMap = new ParamValueManager(con).getObjectParamMap(objectId);
        for (TypeParam typeParam : typeParamList) {
            ObjectParam objectParam = (ObjectParam)paramMap.get(typeParam.getParamId());
            if (objectParam == null) continue;
            String valueData = "";
            ParamValue value = (ParamValue)valuesMap.get(objectParam.getId());
            boolean parameterAllowed = PermissionOfRoles.checkReadObjectParameter(objectParam.getId(), this.userId);
            if (parameterAllowed) {
                if (value != null) {
                    switch (objectParam.getTypeId()) {
                        case 1: {
                            valueData = ((TextParamValue)value).getValue();
                            break;
                        }
                        case 5: {
                            valueData = String.valueOf(((FlagParamValue)value).getValue());
                            break;
                        }
                        case 4: {
                            valueData = ((AddressParamValue)value).getAddress();
                            break;
                        }
                        case 3: {
                            valueData = TimeUtils.formatDate(((DateParamValue)value).getValue());
                            break;
                        }
                        case 2: {
                            ListValue listValue = (ListValue)listValuesMap.get(((ListParamValue)value).getValue());
                            valueData = listValue != null ? listValue.getTitle() : "???";
                            break;
                        }
                    }
                }
            } else {
                valueData = "<\u0421\u041a\u0420\u042b\u0422\u041e>";
            }
            list.add(new ContractObjectParameterDTO(objectParam.getId(), objectParam.getTypeId(), objectParam.getTitle(), objectParam.isHistory() ? "loopa" : "loopa_fade", valueData));
        }
        return list;
    }

    @Override
    public EntityAttr objectParameterGet(int contractId, int objectId, int parameterId) throws BGException, BGMessageException {
        try (ContractObjectDao contractObjectDao = new ContractObjectDao(this.getConnection(), this.userId);){
            EntityAttr entityAttr = contractObjectDao.getObjectParameter(objectId, parameterId);
            return entityAttr;
        }
    }

    @Override
    public AddressStruct getAddressParameterValue(int contractId, int objectId, int parameterId) throws BGException, BGMessageException {
        if (objectId <= 0 || parameterId <= 0) {
            throw new BGIllegalArgumentException();
        }
        AddressStruct address = null;
        String query = "SELECT address.hid, country.title as country, street.cityid as cityid, city.title as city, area.title as area, quarter.title as quarter, house.streetid as streetid, street.title as street, house.frac, house.box_index, house.house, address.pod, address.floor, address.flat, address.room, address.comment, address.format_key, address.address FROM object_param_value_address AS address LEFT JOIN address_house as house on address.hid=house.id LEFT JOIN address_area as area ON house.areaid=area.id LEFT JOIN address_quarter as quarter ON house.quarterid=quarter.id LEFT JOIN address_street as street ON house.streetid=street.id LEFT JOIN address_city as city ON street.cityid=city.id LEFT JOIN address_country as country ON city.country_id=country.id WHERE address.object_id=? AND address.param_id=? ";
        try (PreparedStatement ps = this.getConnection().prepareStatement(query);){
            ps.setInt(1, objectId);
            ps.setInt(2, parameterId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    address = this.getAddressStruct(rs);
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return address;
    }

    private AddressStruct getAddressStruct(ResultSet rs) throws BGException {
        AddressStruct result = new AddressStruct();
        try {
            result.setIndex(rs.getString("box_index"));
            result.setCountry(rs.getString("country"));
            result.setCity(rs.getString("city"));
            String area = rs.getString("area");
            result.setArea(area != null ? area : null);
            String quarter = rs.getString("quarter");
            result.setQuarter(quarter != null ? quarter : null);
            result.setStreet(rs.getString("street"));
            result.setHouse(String.valueOf(rs.getInt("house")));
            result.setFrac(rs.getString("frac"));
            result.setFlat(rs.getString("flat"));
            result.setRoom(rs.getString("room"));
            result.setPod(rs.getInt("pod") == 0 ? "" : rs.getString("pod"));
            result.setFloor(rs.getInt("floor") == 0 ? "" : rs.getString("floor"));
            result.setComment(rs.getString("comment"));
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    @Override
    public void addressParameterValueUpdate(int contractId, EntityAttrAddress entityAttrAddress) throws BGException, BGMessageException {
        if (entityAttrAddress == null) {
            throw new BGIllegalArgumentException();
        }
        this.changeObjectParam((EntityAttr)entityAttrAddress);
    }

    @Override
    public void addressParameterValueDelete(int contractId, int objectId, int parameterId) throws BGException, BGMessageException {
        if (objectId <= 0 || parameterId <= 0) {
            throw new BGIllegalArgumentException();
        }
        EntityAttrAddress entityAttrAddress = new EntityAttrAddress(objectId, parameterId);
        entityAttrAddress.setHouseId(-1);
        this.changeObjectParam((EntityAttr)entityAttrAddress);
    }

    private void changeObjectParam(EntityAttr entityAttr) throws BGException {
        ContractObject contractObject = new ObjectManager(this.getConnection()).getObject(entityAttr.getEntityId());
        if (contractObject == null) {
            throw new BGMessageException("\u041e\u0431\u044a\u0435\u043a\u0442 \u0441 \u043a\u043e\u0434\u043e\u043c " + entityAttr.getEntityId() + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        int contractId = contractObject.getContractId();
        ContractObjectParameterBeforeUpdateEvent beforeUpdate = new ContractObjectParameterBeforeUpdateEvent(this.userId, contractId, entityAttr);
        beforeUpdate = EventProcessor.getInstance().request(beforeUpdate);
        String error = beforeUpdate.getError();
        if (Utils.notBlankString(error)) {
            throw new BGException(error);
        }
        this.paramValueManager.updateParamValue((Object)entityAttr, this.userId);
        ContractObjectParameterUpdateEvent afterUpdate = new ContractObjectParameterUpdateEvent(this.userId, contractId, entityAttr);
        this.context.publishAfterCommit(afterUpdate);
    }

    @Override
    public void textParameterValueUpdate(int contractId, EntityAttrText entityAttrText) throws BGException, BGMessageException {
        if (entityAttrText == null) {
            throw new BGIllegalArgumentException();
        }
        this.changeObjectParam((EntityAttr)entityAttrText);
    }

    @Override
    public void flagParameterValueUpdate(int contractId, EntityAttrBoolean entityAttrBoolean) throws BGException, BGMessageException {
        if (entityAttrBoolean == null) {
            throw new BGIllegalArgumentException();
        }
        this.changeObjectParam((EntityAttr)entityAttrBoolean);
    }

    @Override
    public void dateParameterValueUpdate(int contractId, EntityAttrDate entityAttrDate) throws BGException, BGMessageException {
        if (entityAttrDate == null) {
            throw new BGIllegalArgumentException();
        }
        this.changeObjectParam((EntityAttr)entityAttrDate);
    }

    @Override
    public void listParameterValueUpdate(int contractIdId, EntityAttrList entityAttrList) throws BGException, BGMessageException {
        if (entityAttrList == null) {
            throw new BGIllegalArgumentException();
        }
        this.changeObjectParam((EntityAttr)entityAttrList);
    }

    @Override
    public int getListParameterValue(int contractId, int objectId, int parameterId) throws BGException, BGMessageException {
        if (objectId <= 0 || parameterId <= 0) {
            throw new BGIllegalArgumentException();
        }
        int resultValue = -1;
        ListParamValue value = this.paramValueManager.getListParamValue(objectId, parameterId);
        if (value != null) {
            resultValue = value.getValue();
        }
        return resultValue;
    }

    @Override
    public List<ParameterHistoryEntry> getParameterHistory(int contractId, int objectId, int parameterId, int parameterType) throws BGException, BGMessageException {
        if (objectId <= 0 || parameterId <= 0) {
            throw new BGIllegalArgumentException();
        }
        return this.paramValueManager.getParameterHistory(objectId, parameterId, parameterType);
    }

    @Override
    public void clearParameterHistory(int contractId, int objectId, int parameterId, int parameterType) throws BGException, BGMessageException {
        if (objectId <= 0 || parameterId <= 0) {
            throw new BGIllegalArgumentException();
        }
        this.paramValueManager.clearParameterHistory(objectId, parameterId, parameterType);
    }

    @Override
    public List<ObjectType> objectTypeList(boolean onlyVisible) throws BGException {
        return new ObjectTypeManager(this.getConnection()).getTypeList(onlyVisible);
    }

    @Override
    public int typeUpdate(ObjectType objectType) throws BGException {
        return new ObjectTypeManager(this.getConnection()).updateType(objectType);
    }

    @Override
    public ObjectType typeGet(int typeId) throws BGException {
        return new ObjectTypeManager(this.getConnection()).getType(typeId);
    }

    @Override
    public void typeDelete(int typeId) throws BGException {
        new ObjectTypeManager(this.getConnection()).deleteType(typeId);
    }

    @Override
    public SearchResult<ContractObjectParam> searchObjectParam() throws BGException {
        SearchResult<ContractObjectParam> searchResult = new SearchResult<ContractObjectParam>();
        ArrayList<ContractObjectParam> list = new ArrayList<ContractObjectParam>();
        searchResult.setList(list);
        for (ObjectParam param : new ParamManager(this.getConnection()).getParamList()) {
            ContractObjectParam contractObjectParam = new ContractObjectParam();
            contractObjectParam.setId(param.getId());
            contractObjectParam.setTitle(param.getTitle());
            contractObjectParam.setType(param.getTypeId());
            contractObjectParam.setComment(param.getComment());
            contractObjectParam.setHistory(param.isHistory());
            list.add(contractObjectParam);
        }
        return searchResult;
    }

    @Override
    public ContractObjectParam getObjectParam(int parameterId) throws BGException {
        return ObjectUtils.convertObjectParamToContractObjectParam(new ParamManager(this.getConnection()).getParameter(parameterId));
    }

    @Override
    public void updateObjectParam(ContractObjectParam contractObjectParam) throws BGException {
        ObjectParam parameter = ObjectUtils.convertContractObjectParamToObjectParam(contractObjectParam);
        if (parameter != null) {
            new ParamManager(this.getConnection()).updateParam(parameter);
        }
    }

    @Override
    public void deleteObjectParam(int id) throws BGException {
        new ParamManager(this.getConnection()).deleteParam(id);
    }

    @Override
    public List<ObjectTypeParameter> objectTypeParameterList(int objectTypeId) throws BGException, BGMessageException {
        ArrayList<ObjectTypeParameter> objectTypeParameters = new ArrayList<ObjectTypeParameter>();
        Map paramMap = new ParamManager(this.getConnection()).getParamMap();
        for (TypeParam typeParam : new TypeParamManager(this.getConnection()).getTypeParamList(objectTypeId)) {
            ObjectTypeParameter objectTypeParameter = new ObjectTypeParameter();
            objectTypeParameter.setParameterId(typeParam.getParamId());
            ObjectParam param = (ObjectParam)paramMap.get(typeParam.getParamId());
            if (param != null) {
                objectTypeParameter.setParameterTitle(param.getTitle());
                objectTypeParameter.setParameterTypeTitle(param.getTypeString());
            } else {
                objectTypeParameter.setParameterTitle("???");
                objectTypeParameter.setParameterTypeTitle("???");
            }
            objectTypeParameters.add(objectTypeParameter);
        }
        return objectTypeParameters;
    }

    @Override
    public List<IdTitle> getAvaliableTypeForObjectType(int objectTypeId) throws BGException {
        Set typeParamSet = new TypeParamManager(this.getConnection()).getTypeParamList(objectTypeId).stream().mapToInt(TypeParam::getParamId).boxed().collect(Collectors.toSet());
        return new ParamManager(this.getConnection()).getParamMap().entrySet().stream().filter(entry -> !typeParamSet.contains(entry.getKey())).map(entry -> new IdTitle((Integer)entry.getKey(), ((ObjectParam)entry.getValue()).getTitle())).collect(Collectors.toList());
    }

    @Override
    public void updateLinkParameterWithObjectType(int objectTypeId, int parameterId, boolean add) throws BGException {
        TypeParam typeParam = new TypeParam();
        typeParam.setTypeId(objectTypeId);
        typeParam.setParamId(parameterId);
        if (add) {
            new TypeParamManager(this.getConnection()).addTypeParam(typeParam);
        } else {
            new TypeParamManager(this.getConnection()).deleteTypeParam(typeParam);
        }
    }

    @Override
    public void parameterMoving(int objectTypeParameterId, int parameterId, boolean moveToUp) throws BGException {
        TypeParam typeParam = new TypeParam();
        typeParam.setTypeId(objectTypeParameterId);
        typeParam.setParamId(parameterId);
        if (moveToUp) {
            new TypeParamManager(this.getConnection()).moveUp(typeParam);
        } else {
            new TypeParamManager(this.getConnection()).moveDown(typeParam);
        }
    }

    @Override
    public List<ListValue> getValuesForListParameter(int parameterId) throws BGException, BGMessageException {
        return new ListValueManager(this.getConnection()).getValues(parameterId);
    }

    @Override
    public List<ContractObjectParam> getListParameters() throws BGException, BGMessageException {
        return new ParamManager(this.getConnection()).getParamList(2).stream().map(o -> ObjectUtils.convertObjectParamToContractObjectParam(o)).collect(Collectors.toList());
    }

    @Override
    public void updateListParameterValue(ListValue listValue) throws BGException {
        new ListValueManager(this.getConnection()).updateValue(listValue);
    }

    @Override
    public void deleteListParameterValue(int valueId) throws BGException, BGMessageException {
        new ListValueManager(this.getConnection()).deleteValue(valueId);
    }
}

