/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.server.service;

import bitel.billing.server.contract.object.bean.ListValueManager;
import bitel.billing.server.contract.object.bean.ObjectParam;
import bitel.billing.server.contract.object.bean.ParamManager;
import bitel.billing.server.contract.object.bean.TypeParam;
import bitel.billing.server.contract.object.bean.TypeParamManager;
import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObjectParam;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ListValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectTypeParameter;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ParameterObjectTypeService;
import ru.bitel.bgbilling.kernel.contract.object.server.utils.ObjectUtils;
import ru.bitel.common.model.IdTitle;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.object.common.service.ParameterObjectTypeService")
public class ParameterObjectTypeServiceImpl
extends AbstractService
implements ParameterObjectTypeService {
    private TypeParamManager typeParameterManager;
    private ParamManager paramManager;
    private ListValueManager listValueManager;

    @PostConstruct
    public void init() {
        this.typeParameterManager = new TypeParamManager(this.getConnection());
        this.paramManager = new ParamManager(this.getConnection());
        this.listValueManager = new ListValueManager(this.getConnection());
    }

    @Override
    public List<ObjectTypeParameter> objectTypeParameterList(int objectTypeId) throws BGException, BGMessageException {
        ArrayList<ObjectTypeParameter> objectTypeParameters = new ArrayList<ObjectTypeParameter>();
        Map paramMap = this.paramManager.getParamMap();
        for (TypeParam typeParam : this.typeParameterManager.getTypeParamList(objectTypeId)) {
            ObjectTypeParameter objectTypeParameter = new ObjectTypeParameter();
            objectTypeParameter.setParameterId(typeParam.getParamId());
            ObjectParam param = (ObjectParam)paramMap.get(typeParam.getParamId());
            if (param != null) {
                objectTypeParameter.setParameterTitle(param.getTitle());
                objectTypeParameter.setParameterTypeTitle(param.getTypeString());
            } else {
                objectTypeParameter.setParameterTitle("???");
                objectTypeParameter.setParameterTypeTitle("???");
            }
            objectTypeParameters.add(objectTypeParameter);
        }
        return objectTypeParameters;
    }

    @Override
    public List<IdTitle> getAvaliableTypeForObjectType(int objectTypeId) throws BGException {
        Set typeParamSet = this.typeParameterManager.getTypeParamList(objectTypeId).stream().mapToInt(TypeParam::getParamId).boxed().collect(Collectors.toSet());
        return this.paramManager.getParamMap().entrySet().stream().filter(entry -> !typeParamSet.contains(entry.getKey())).map(entry -> new IdTitle((Integer)entry.getKey(), ((ObjectParam)entry.getValue()).getTitle())).collect(Collectors.toList());
    }

    @Override
    public void updateLinkParameterWithObjectType(int objectTypeId, int parameterId, boolean add) throws BGException {
        TypeParam typeParam = new TypeParam();
        typeParam.setTypeId(objectTypeId);
        typeParam.setParamId(parameterId);
        if (add) {
            this.typeParameterManager.addTypeParam(typeParam);
        } else {
            this.typeParameterManager.deleteTypeParam(typeParam);
        }
    }

    @Override
    public void parameterMoving(int objectTypeParameterId, int parameterId, boolean moveToUp) throws BGException {
        TypeParam typeParam = new TypeParam();
        typeParam.setTypeId(objectTypeParameterId);
        typeParam.setParamId(parameterId);
        if (moveToUp) {
            this.typeParameterManager.moveUp(typeParam);
        } else {
            this.typeParameterManager.moveDown(typeParam);
        }
    }

    @Override
    public List<ListValue> getValuesForListParameter(int parameterId) throws BGException, BGMessageException {
        return this.listValueManager.getValues(parameterId);
    }

    @Override
    public List<ContractObjectParam> getListParameters() throws BGException, BGMessageException {
        return this.paramManager.getParamList(2).stream().map(o -> ObjectUtils.convertObjectParamToContractObjectParam(o)).collect(Collectors.toList());
    }

    @Override
    public void updateListParameterValue(ListValue listValue) throws BGException {
        this.listValueManager.updateValue(listValue);
    }

    @Override
    public void deleteListParameterValue(int valueId) throws BGException, BGMessageException {
        this.listValueManager.deleteValue(valueId);
    }
}

