/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.param.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComboBoxWithSearch;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.common.table.BGTableColumn;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.oss.kernel.directories.address.common.bean.House;

public class AddressHouseSearchDialog
extends BGEditorDialog<House> {
    private ClientContext context;
    private BGComboBoxWithSearch street = new BGComboBoxWithSearch(2);
    private BGTextField house = new BGTextField(5);
    private BGTable searchTable = new BGTable();

    public AddressHouseSearchDialog(String title, House data, ClientContext context) {
        super(title, data);
        this.context = context;
    }

    @Override
    public void doDialogPanel() {
        this.panel.add((Component)this.getFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.getTablePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.streetEntered();
    }

    @Override
    public JDialog getDialog() {
        JDialog dialog = super.getDialog();
        this.optionPane.setInitialValue(null);
        return dialog;
    }

    @Override
    public boolean doApply() throws Exception {
        if (this.tableInStreetsMode(this.searchTable)) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0434\u043e\u043c");
            return false;
        }
        int rowId = this.searchTable.getSelectedRow();
        if (rowId < 0) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0434\u043e\u043c");
            return false;
        }
        ((House)this.data).setId(Utils.parseInt(this.searchTable.getColumnValueString(rowId, "houseId")));
        return true;
    }

    private JPanel getFilterPanel() {
        this.street.addActionListener(event -> {
            if (((long)event.getModifiers() & 0x10L) > 0L) {
                this.streetEntered();
            }
        });
        this.street.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("fillText")) {
                this.fillStreetList(String.valueOf(evt.getNewValue()));
            } else if (evt.getPropertyName().equals("textEntered")) {
                this.streetEntered();
            }
        });
        this.street.setEditable(true);
        this.house.setHorizontalAlignment(0);
        this.house.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                int selectedStreetId;
                if (e.getKeyChar() == '\n' && (selectedStreetId = Integer.valueOf(AddressHouseSearchDialog.this.street.getSelectedId()).intValue()) > 0) {
                    AddressHouseSearchDialog.this.fillListByHouses(selectedStreetId, AddressHouseSearchDialog.this.house.getText());
                }
            }
        });
        JButton searchButton = new JButton("\u041d\u0430\u0439\u0442\u0438");
        searchButton.addActionListener(e -> this.streetEntered());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0423\u043b\u0438\u0446\u0430:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 10, 0, 5), 0, 0));
        panel.add((Component)this.street, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(2, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u0414\u043e\u043c [\u0434\u0440\u043e\u0431\u044c]:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 10, 0, 5), 0, 0));
        panel.add((Component)this.house, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(2, 5, 0, 5), 0, 0));
        panel.add((Component)searchButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(2, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getTablePanel() {
        this.searchTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    BGTable table = (BGTable)mouseEvent.getSource();
                    int row = table.getSelectedRow();
                    int rowId = Integer.valueOf(AddressHouseSearchDialog.this.tableInStreetsMode(table) ? table.getColumnValueString(row, "streetId") : table.getColumnValueString(row, "houseId"));
                    if (rowId > 0) {
                        if (AddressHouseSearchDialog.this.tableInStreetsMode(table)) {
                            AddressHouseSearchDialog.this.fillListByHouses(rowId, AddressHouseSearchDialog.this.house.getText());
                        } else {
                            ((JButton)AddressHouseSearchDialog.this.optionPane.getOptions()[0]).doClick();
                        }
                    }
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0438\u0441\u0438:"), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane(this.searchTable, 1000, 300), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    protected void clearHouseSearchPanel() {
        this.searchTable.removeRows();
        ((JTextComponent)this.street.getEditor().getEditorComponent()).setText("");
        this.house.setText("");
    }

    private void fillStreetList(String streetTitle) {
        Request request = new Request();
        request.setModule("admin");
        request.setAction("GetAddressStreet");
        request.setPageIndex(1);
        request.setPageSize(25);
        int pos = streetTitle.indexOf(40);
        if (pos < 0) {
            request.setAttribute("stname", streetTitle.trim());
        } else {
            request.setAttribute("stname", streetTitle.substring(0, pos).trim());
            if (pos < streetTitle.length() - 1) {
                request.setAttribute("city_title", streetTitle.substring(pos + 1).trim());
            }
        }
        Document doc = TransferManager.getDocument(request);
        Iterable<Element> streets = XMLUtils.selectElements(doc, "data/table/data/row");
        this.street.initPopup(streetTitle);
        for (Element s : streets) {
            Integer streetId = Integer.valueOf(XMLUtils.getAttribute(s, "f0"));
            String streetName = XMLUtils.getAttribute(s, "f1") + " (" + XMLUtils.getAttribute(s, "f2") + ")";
            this.street.addItem(new ComboBoxItem(streetId, streetName));
        }
    }

    private void fillListByStreets(String streetSubstring) {
        this.searchTable.removeRows();
        if (Utils.notBlankString(streetSubstring)) {
            this.searchTable.removeColumns();
            BGTableColumn column = null;
            column = BGTableColumn.getInstance("cityTitle", "\u0413\u043e\u0440\u043e\u0434", new int[]{150, 150, 800}, false, "");
            column.setEditable(false);
            column.setCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.searchTable.addColumn(column);
            column = BGTableColumn.getInstance("streetTitle", "\u0423\u043b\u0438\u0446\u0430", new int[]{150, 150, 1000}, false, "");
            column.setEditable(false);
            column.setCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.searchTable.addColumn(column);
            this.searchTable.setAutoResizeMode(1);
            column = BGTableColumn.getInstance("streetId", "ID", new int[]{80, 80, 80}, false, "");
            column.setEditable(false);
            column.setCellRenderer(DecimalTableCellRenderer.INTEGER());
            this.searchTable.addColumn(column);
            Request request = new Request();
            request.setModule("admin");
            request.setAction("GetStreetsBySubstring");
            request.setAttribute("streetSubstring", streetSubstring);
            Document doc = TransferManager.getDocument(request);
            for (Element streetEl : XMLUtils.selectElements(doc, "data/streetList/street")) {
                Vector<String> row = new Vector<String>();
                row.add(streetEl.getAttribute("cityTitle"));
                row.add(streetEl.getAttribute("streetTitle"));
                row.add(streetEl.getAttribute("streetId"));
                this.searchTable.addRow(row);
            }
        }
    }

    private void fillListByHouses(int streetId, String houseNum) {
        this.searchTable.removeRows();
        if (streetId > 0) {
            Request request = new Request();
            request.setModule("admin");
            request.setAction("FilterHouse");
            request.setAttribute("street", streetId);
            request.setAttribute("house_frac", houseNum);
            Document doc = TransferManager.getDocument(request);
            Iterable<Element> houses = XMLUtils.selectElements(doc, "data/list/item");
            this.searchTable.removeColumns();
            BGTableColumn column = null;
            column = BGTableColumn.getInstance("house", "\u0414\u043e\u043c", new int[]{-1, -1, -1}, false, "");
            column.setEditable(false);
            column.setCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.searchTable.addColumn(column);
            this.searchTable.setAutoResizeMode(3);
            column = BGTableColumn.getInstance("houseId", "ID", new int[]{80, 80, 80}, false, "");
            column.setEditable(false);
            column.setCellRenderer(DecimalTableCellRenderer.INTEGER());
            this.searchTable.addColumn(column);
            for (Element houseItem : houses) {
                String address;
                int pos;
                String addressHouse = houseItem.getAttribute("house");
                if (addressHouse.isEmpty() && (pos = (address = houseItem.getAttribute("title")).indexOf(",")) > -1 && pos < address.length()) {
                    addressHouse = address.substring(pos + 1);
                }
                if (!houseNum.equals("") && addressHouse.indexOf(houseNum) <= -1) continue;
                HashMap<String, String> row = new HashMap<String, String>();
                row.put("house", houseItem.getAttribute("title"));
                row.put("houseId", houseItem.getAttribute("id"));
                this.searchTable.addRow(row);
            }
        }
    }

    private void streetEntered() {
        Object selectedItem = this.street.getSelectedItem();
        if (selectedItem != null) {
            int selectedStreetId = Utils.parseInt(this.street.getSelectedId());
            if (selectedStreetId > 0) {
                this.fillListByHouses(selectedStreetId, this.house.getText());
            } else {
                this.fillListByStreets(selectedItem.toString());
            }
        }
    }

    private boolean tableInStreetsMode(BGTable table) {
        return table.getColumnCount() == 3;
    }
}

