/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.param.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerContactType;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.param.client.CustomerParamEditorData;
import ru.bitel.bgbilling.kernel.contract.param.client.CustomerParamEmailEditorDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.CustomerParamHistoryDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.CustomerParamPanel;
import ru.bitel.bgbilling.kernel.contract.param.client.CustomerParamPhoneEditorDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.CustomerParamTextArea;
import ru.bitel.common.client.AbstractBGUPanel;

public abstract class CustomerCommonParamPanel
extends BGUPanel {
    protected CustomerParamPanel customerParamPanel;
    protected ClientSetup clientSetup = ClientSetup.getInstance();
    protected List<CustomerContactField> contacts = new ArrayList<CustomerContactField>();

    protected CustomerCommonParamPanel(CustomerParamPanel customerParamPanel) {
        this.customerParamPanel = customerParamPanel;
        this.init();
    }

    protected JPanel getContactsPanel(CustomerContactType ... types) {
        JPanel panelWithContants = new JPanel(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(panelWithContants);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setPreferredSize(new Dimension(100, 100));
        JPanel contactPanel = new JPanel(new GridBagLayout());
        contactPanel.setBorder(BorderFactory.createTitledBorder("\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u044b"));
        contactPanel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 0, 0), 0, 0));
        int gridy = 0;
        for (CustomerContactType contactType : types) {
            CustomerContactField customerContactField = new CustomerContactField(contactType);
            this.contacts.add(customerContactField);
            String title = contactType != null ? "customer_" + contactType.name().toLowerCase() + ".png" : "";
            panelWithContants.add((Component)new JLabel(ClientUtils.getIcon(title)), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 0), 0, 0));
            panelWithContants.add((Component)customerContactField, new GridBagConstraints(1, gridy, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
            panelWithContants.add((Component)new ContactEditButton(contactType), new GridBagConstraints(2, gridy, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            ++gridy;
        }
        panelWithContants.add(Box.createGlue(), new GridBagConstraints(0, gridy, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelWithContants.revalidate();
        panelWithContants.repaint();
        return contactPanel;
    }

    @Override
    protected void initActions() {
        (AbstractBGUPanel)this.new AbstractBGUPanel.BGDefaultAction("contact.editor.email", "", e -> {
            CustomerParamEditorData data = new CustomerParamEditorData();
            data.setCustomerParamPanel(this.customerParamPanel);
            data.setContactType(CustomerContactType.EMAIL);
            data.setParameterTitle("E-mail");
            data.setClientContext((ClientContext)this.getContext());
            data.setData(this.getContactData(CustomerContactType.EMAIL));
            new CustomerParamEmailEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440", data).open();
        });
        (AbstractBGUPanel)this.new AbstractBGUPanel.BGDefaultAction("contact.editor.mobile", "", e -> {
            CustomerParamEditorData data = new CustomerParamEditorData();
            data.setCustomerParamPanel(this.customerParamPanel);
            data.setContactType(CustomerContactType.MOBILE);
            data.setParameterTitle("\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d");
            data.setClientContext((ClientContext)this.getContext());
            data.setData(this.getContactData(CustomerContactType.MOBILE));
            String formats = ((ClientContext)this.getContext()).getWebService(ContractParameterService.class, 0).paramPhoneFormats();
            new CustomerParamPhoneEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440", data, formats).open();
        });
        (AbstractBGUPanel)this.new AbstractBGUPanel.BGDefaultAction("contact.editor.phone", "", e -> {
            CustomerParamEditorData data = new CustomerParamEditorData();
            data.setCustomerParamPanel(this.customerParamPanel);
            data.setContactType(CustomerContactType.PHONE);
            data.setParameterTitle("\u0421\u0442\u0430\u0446\u0438\u043e\u043d\u0430\u0440\u043d\u044b\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d");
            data.setClientContext((ClientContext)this.getContext());
            data.setData(this.getContactData(CustomerContactType.PHONE));
            String formats = ((ClientContext)this.getContext()).getWebService(ContractParameterService.class, 0).paramPhoneFormats();
            new CustomerParamPhoneEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440", data, formats).open();
        });
    }

    private JSONArray getContactData(CustomerContactType contactType) {
        Object obj = ((ClientContext)this.customerParamPanel.getContext()).getCustomer().optQuery("/customer/contact");
        JSONObject contactJson = obj instanceof JSONObject ? (JSONObject)obj : new JSONObject();
        return Optional.ofNullable(contactJson.optJSONArray(contactType.name().toLowerCase())).orElse(new JSONArray());
    }

    protected JPanel wrapTextArea(CustomerParamTextArea customerParamTextArea) {
        Dimension dimension = new Dimension(300, customerParamTextArea.getPreferredSize().height + 3);
        JScrollPane scrollPane = new JScrollPane(customerParamTextArea);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        JButton button = new JButton(ClientUtils.getIcon("dots"));
        button.setPreferredSize(new Dimension(21, 12));
        button.setMaximumSize(new Dimension(21, 12));
        button.addActionListener(e -> new CustomerParamHistoryDialog(customerParamTextArea.getTitle(), customerParamTextArea.getFieldKey(), this.customerParamPanel));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(customerParamTextArea.getTitle() + ":"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        panel.add((Component)button, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    class CustomerContactField
    extends JTextField {
        private CustomerContactType contactType;

        public CustomerContactField(CustomerContactType contactType) {
            this.contactType = contactType;
            Color bgColor = this.getBackground();
            this.setEditable(false);
            this.setBackground(bgColor);
            this.addMouseListener(new CustomerContactMouseAdapter(contactType));
        }

        public void setData() {
            JSONArray data = CustomerCommonParamPanel.this.getContactData(this.contactType);
            StringBuilder txt = new StringBuilder();
            if (data != null) {
                for (int index = 0; index < data.length(); ++index) {
                    JSONObject entity = data.optJSONObject(index);
                    txt.append(txt.length() > 0 ? "; " : "").append(entity.optString("value"));
                }
            }
            this.setText(txt.toString());
        }
    }

    class ContactEditButton
    extends JButton {
        public ContactEditButton(CustomerContactType contactType) {
            this.setMargin(new Insets(0, 3, 0, 3));
            this.setAction(CustomerCommonParamPanel.this.getActionMap().get("contact.editor." + contactType.name().toLowerCase()));
            this.setIcon(ClientUtils.getIcon("edit"));
        }
    }

    class CustomerContactMouseAdapter
    extends MouseAdapter {
        CustomerContactType contactType;

        public CustomerContactMouseAdapter(CustomerContactType contactType) {
            this.contactType = contactType;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                JMenuItem menuItem = new JMenuItem("\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439");
                menuItem.addActionListener(ae -> new CustomerParamHistoryDialog(this.contactType.description, this.contactType.key, CustomerCommonParamPanel.this.customerParamPanel));
                JPopupMenu popupMenu = new JPopupMenu();
                popupMenu.add(menuItem);
                popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

