/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.param.server.bean;

import bitel.billing.server.admin.bean.ContractParameterGroupManager;
import bitel.billing.server.contract.bean.ContractAddressParamValue;
import bitel.billing.server.contract.bean.ContractParameterManager;
import java.sql.Connection;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ListParamValue;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.MultiListParamValues;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameterPrefDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;

public class ContractParameters {
    public static Set<Integer> getContractParameterIdsInGroup(int contractParamGroupId, Connection con) throws BGException {
        Set ids = null;
        if (contractParamGroupId > 0) {
            ids = new ContractParameterGroupManager(con).getParameterSetInGroup(contractParamGroupId);
        }
        return ids;
    }

    public static List<ContractParameterPref> getContractParameterPrefList(Set<Integer> parameterIds, Connection con) throws BGException {
        ArrayList<ContractParameterPref> list = new ArrayList<ContractParameterPref>();
        ContractParameterPrefDao prefDao = new ContractParameterPrefDao(con);
        for (ContractParameterPref contractParameterPref : prefDao.getContractParameterPrefList(parameterIds)) {
            if (!contractParameterPref.isRead() && !contractParameterPref.isWrite()) continue;
            list.add(contractParameterPref);
        }
        prefDao.close();
        return list;
    }

    public static Map<Integer, String> getContractParameterValue(List<ContractParameterPref> showList, int contractId, Connection con) throws BGException {
        HashSet<Integer> paramIds = new HashSet<Integer>();
        for (ContractParameterPref contractParameterPref : showList) {
            if (!contractParameterPref.isRead() && !contractParameterPref.isWrite()) continue;
            paramIds.add(contractParameterPref.getId());
        }
        return ContractParameters.getContractParameterValue(paramIds, contractId, con);
    }

    public static Map<Integer, String> getContractParameterValue(Set<Integer> paramIds, int contractId, Connection con) throws BGException {
        Object listParamValue;
        HashMap<Integer, String> paramValue = new HashMap<Integer, String>();
        ContractDao contractDao = new ContractDao(con, 0);
        ContractParameterManager contractParameterManager = new ContractParameterManager(con);
        Map<Integer, EntityAttr> paramValueMap = contractDao.getContractParameters(contractId, paramIds);
        for (Map.Entry<Integer, EntityAttr> entry : paramValueMap.entrySet()) {
            if (!(entry.getValue() instanceof EntityAttrText)) continue;
            paramValue.put(entry.getKey(), ((EntityAttrText)entry.getValue()).getValue());
        }
        for (Map.Entry<Integer, Object> entry : contractParameterManager.getAddressParamMap(contractId, paramIds).entrySet()) {
            ContractAddressParamValue contractAddressParamValue = (ContractAddressParamValue)entry.getValue();
            if (contractAddressParamValue == null) continue;
            paramValue.put(entry.getKey(), contractAddressParamValue.getAddress());
        }
        for (Map.Entry<Integer, Object> entry : paramValueMap.entrySet()) {
            if (!(entry.getValue() instanceof EntityAttrBoolean)) continue;
            String string4 = ((EntityAttrBoolean)entry.getValue()).toString().trim();
            string4 = string4.replaceAll("\n", "; ");
            string4 = string4.replaceAll("<", "&lt;");
            string4 = string4.replaceAll(">", "&gt;");
            paramValue.put(entry.getKey(), string4);
        }
        for (Map.Entry<Integer, Object> entry : paramValueMap.entrySet()) {
            Boolean bl;
            if (!(entry.getValue() instanceof EntityAttrBoolean) || (bl = Boolean.valueOf(((EntityAttrBoolean)entry.getValue()).getValue())) == null) continue;
            paramValue.put(entry.getKey(), bl != false ? "\u0432\u043a\u043b\u044e\u0447\u0435\u043d\u043e" : "\u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u043e");
        }
        DateFormat format = TimeUtils.getDateFormat("dd.MM.yyyy");
        for (Map.Entry<Integer, EntityAttr> entry : paramValueMap.entrySet()) {
            Date dateParamValue;
            if (!(entry.getValue() instanceof EntityAttrDate) || (dateParamValue = ((EntityAttrDate)entry.getValue()).getValue()) == null) continue;
            paramValue.put(entry.getKey(), TimeUtils.format(dateParamValue, format));
        }
        for (Map.Entry entry : contractParameterManager.getListParamValueMap(contractId, paramIds).entrySet()) {
            listParamValue = (ListParamValue)entry.getValue();
            if (listParamValue == null) continue;
            paramValue.put((Integer)entry.getKey(), ((ListParamValue)listParamValue).toString());
        }
        for (Map.Entry<Integer, EntityAttr> entry : paramValueMap.entrySet()) {
            EntityAttrPhone attrPhone;
            if (!(entry.getValue() instanceof EntityAttrPhone) || (attrPhone = (EntityAttrPhone)entry.getValue()) == null) continue;
            paramValue.put(entry.getKey(), attrPhone.toString());
        }
        for (Map.Entry entry : contractParameterManager.getMultiListParamValueMap(contractId, paramIds).entrySet()) {
            listParamValue = (MultiListParamValues)entry.getValue();
            if (listParamValue == null) continue;
            paramValue.put((Integer)entry.getKey(), ((MultiListParamValues)listParamValue).toStringValue());
        }
        contractParameterManager.close();
        return paramValue;
    }
}

