/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.RadioButtonTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPattern;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternBaseTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.table.PatternTable;
import ru.bitel.bgbilling.kernel.contract.pattern.client.table.PatternTableModelItem;
import ru.bitel.bgbilling.kernel.contract.pattern.common.bean.RowData;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroup;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;

public class PatternTariffTabPanel
extends PatternBaseTabPanel {
    private static final String TARIFF_GROUPS = "tariff_groups";
    private static final String TARIFF = "tariff";
    private TariffService tariffService = null;
    private TariffModel tariffTableModel = new TariffModel(TariffModel.class.getName());
    private BGUTable tariffTable = new BGUTable(this.tariffTableModel);
    private TariffGroupModel tariffGroupTableModel = new TariffGroupModel(TariffGroupModel.class.getName());
    private PatternTable tariffGroupTable = new PatternTable(this.tariffGroupTableModel);
    private List<KeyValue> tariffPeriodModeFrom = Arrays.asList(new KeyValue("currentDate", "\u0421 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0434\u0430\u0442\u044b"), new KeyValue("nextDate", "\u0421\u043e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u0434\u043d\u044f"), new KeyValue("nextWeek", "\u0421 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u043f\u043e\u043d\u0435\u0434\u0435\u043b\u044c\u043d\u0438\u043a\u0430"), new KeyValue("nextMonth", "\u0421 1 \u0447\u0438\u0441\u043b\u0430 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u043c\u0435\u0441\u044f\u0446\u0430"), new KeyValue("nextYear", "\u0421 1 \u0447\u0438\u0441\u043b\u0430 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u0433\u043e\u0434\u0430"), new KeyValue("plusDay", "\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0434\u0430\u0442\u0430 \u043f\u043b\u044e\u0441 \u0434\u043d\u0435\u0439:"), new KeyValue("plusMonth", "\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0434\u0430\u0442\u0430 \u043f\u043b\u044e\u0441 \u043c\u0435\u0441\u044f\u0446\u0435\u0432:"), new KeyValue("plusMonth1", "\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0434\u0430\u0442\u0430 \u043f\u043b\u044e\u0441 \u043c\u0435\u0441\u044f\u0446\u0435\u0432 (\u0441 \u043d\u0430\u0447\u0430\u043b\u0430):"), new KeyValue("plusYear", "\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0434\u0430\u0442\u0430 \u043f\u043b\u044e\u0441 \u0433\u043e\u0434:"), new KeyValue("plusYear1", "\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0434\u0430\u0442\u0430 \u043f\u043b\u044e\u0441 \u0433\u043e\u0434 (\u0441 \u043d\u0430\u0447\u0430\u043b\u0430):"));
    private List<KeyValue> tariffPeriodModeTo = Arrays.asList(new KeyValue("unlim", "\u0431\u0435\u0441\u0441\u0440\u043e\u0447\u043d\u043e"), new KeyValue("currentDate", "\u0414\u043e \u043d\u0430\u0447\u0430\u043b\u0430"), new KeyValue("nextDate", "\u0414\u043e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u0434\u043d\u044f"), new KeyValue("endWeek", "\u0414\u043e \u0432\u043e\u0441\u043a\u0440\u0435\u0441\u0435\u043d\u044c\u044f"), new KeyValue("endMonth", "\u0414\u043e \u043a\u043e\u043d\u0446\u0430 \u043c\u0435\u0441\u044f\u0446\u0430"), new KeyValue("endYear", "\u0414\u043e \u043a\u043e\u043d\u0446\u0430 \u0433\u043e\u0434\u0430"), new KeyValue("plusDay", "\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u043b\u044e\u0441 \u0434\u043d\u0435\u0439:"), new KeyValue("plusMonth", "\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u043b\u044e\u0441 \u043c\u0435\u0441\u044f\u0446\u0435\u0432:"), new KeyValue("plusMonth31", "\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u043b\u044e\u0441 \u043c\u0435\u0441\u044f\u0446\u0435\u0432 (\u0434\u043e \u043a\u043e\u043d\u0446\u0430):"), new KeyValue("plusYear", "\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u043b\u044e\u0441 \u0433\u043e\u0434:"), new KeyValue("plusYear31", "\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u043b\u044e\u0441 \u0433\u043e\u0434 (\u0434\u043e \u043a\u043e\u043d\u0446\u0430):"));

    public PatternTariffTabPanel(Document moduleDoc) {
        int gridy = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getTariffGroupPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getTariffPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private TariffService getTariffService() {
        if (this.tariffService == null) {
            this.tariffService = this.getContext().getPort(TariffService.class);
        }
        return this.tariffService;
    }

    private JPanel getTariffGroupPanel() {
        this.setMouseListener(this.tariffGroupTable, 0);
        Dimension dimension = new Dimension(500, 200);
        JScrollPane scrollPane = new JScrollPane(this.tariffGroupTable);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u0430 \u0442\u0430\u0440\u0438\u0444\u043e\u0432 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getTariffPanel() {
        this.tariffTable.setSelectionMode(0);
        AbstractAction newAction = new AbstractAction("new", ClientUtils.getIcon("item_add")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RowData rowData = new RowData();
                rowData.setPosition("0");
                rowData.setGroupId(-1);
                new TariffEditor("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430", rowData).getDialog().setVisible(true);
            }
        };
        AbstractAction editAction = new AbstractAction("edit", ClientUtils.getIcon("item_edit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RowData rowData = (RowData)PatternTariffTabPanel.this.tariffTableModel.getSelectedRow();
                if (rowData != null) {
                    new TariffEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430", rowData).getDialog().setVisible(true);
                }
            }
        };
        AbstractAction deleteAction = new AbstractAction("delete", ClientUtils.getIcon("item_delete")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RowData rowData = (RowData)PatternTariffTabPanel.this.tariffTableModel.getSelectedRow();
                if (rowData != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0438\u0441\u0438?") == 0) {
                    PatternTariffTabPanel.this.tariffTableModel.deleteRow(rowData);
                }
            }
        };
        BGDialogToolBar tariffToolBar = new BGDialogToolBar();
        tariffToolBar.add(newAction);
        tariffToolBar.add(editAction);
        tariffToolBar.add(deleteAction);
        tariffToolBar.compact();
        this.setMouseListener(this.tariffTable, 0);
        int gridx = 0;
        JPanel topPanle = new JPanel(new GridBagLayout());
        topPanle.add((Component)new JLabel("\u0422\u0430\u0440\u0438\u0444\u044b:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        topPanle.add((Component)tariffToolBar, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)topPanle, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane(this.tariffTable), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, -114, 0, 0), 0, 0));
        return panel;
    }

    @Override
    public void setData(Document doc) {
        ArrayList<PatternTableModelItem> tariffGroupRowData = new ArrayList<PatternTableModelItem>();
        for (Element element : XMLUtils.selectElements(doc, "//tariff_groups/data/row")) {
            PatternTableModelItem item = new PatternTableModelItem();
            item.setId(Utils.parseInt(element.getAttribute("id")));
            item.setTitle(element.getAttribute("title"));
            tariffGroupRowData.add(item);
        }
        this.tariffGroupTableModel.setData(tariffGroupRowData);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPatternData(ContractPattern contractPattern) {
        ArrayList<RowData> currentRariffRowData = new ArrayList<RowData>();
        try {
            Directory<TariffPlan> tariffPalnDirectory = this.getContext().getDirectory(TariffPlan.class);
            for (String string : contractPattern.getTariffPlanList()) {
                void var5_7;
                String[] aa = string.split(":");
                int tariffId = Utils.parseInt(aa[0]);
                TariffPlan tariffPlan = tariffPalnDirectory.get(tariffId);
                if (tariffPlan == null) continue;
                if (aa.length < 2) {
                    String string2 = string + ":0:-1:currentDate:0:unlim:0";
                } else if (aa.length < 3) {
                    String string3 = string + ":-1:currentDate:0:unlim:0";
                }
                aa = var5_7.split(":");
                RowData rowData = new RowData();
                rowData.setId(tariffId);
                rowData.setGroupId(this.getInt(aa, 2, -1));
                rowData.setPosition(String.valueOf(this.getInt(aa, 1, 0)));
                rowData.setTitle(tariffPlan.getTitle());
                rowData.setPeriodModeFrom(this.getString(aa, 3, "currentDate"));
                rowData.setPeriodValueFrom(this.getInt(aa, 4, 0));
                rowData.setPeriodModeTo(this.getString(aa, 5, "unlim"));
                rowData.setPeriodValueTo(this.getInt(aa, 6, 0));
                currentRariffRowData.add(rowData);
            }
        }
        catch (Exception e2) {
            ClientUtils.showErrorMessageDialog(e2);
        }
        this.tariffTableModel.setData(currentRariffRowData);
        List<Integer> tariffGroupList = contractPattern.getTariffGroupList();
        int tarifGroupId = tariffGroupList.size() > 0 ? tariffGroupList.get(0) : 0;
        this.tariffGroupTableModel.getRows().stream().forEach(e -> e.setSelected(e.getId() == tarifGroupId));
    }

    private int getInt(String[] data, int index, int defValue) {
        if (data != null && data.length > index) {
            return Utils.parseInt(data[index]);
        }
        return defValue;
    }

    private String getString(String[] data, int index, String defValue) {
        if (data != null && data.length > index) {
            return data[index];
        }
        return defValue;
    }

    @Override
    public void resetData() {
        this.tariffTableModel.deleteRows();
        this.tariffGroupTableModel.getRows().stream().forEach(e -> e.setSelected(e.getId() == 0));
    }

    @Override
    public boolean setRequestData(Request request) {
        ArrayList tariffPlans = new ArrayList();
        this.tariffTableModel.getRows().stream().forEach(rowData -> {
            Object tpid = String.valueOf(rowData.getId());
            tpid = (String)tpid + ":" + Utils.parseInt(rowData.getPosition());
            tpid = (String)tpid + ":" + rowData.getGroupId();
            tpid = (String)tpid + ":" + rowData.getPeriodModeFrom();
            tpid = (String)tpid + ":" + rowData.getPeriodValueFrom();
            tpid = (String)tpid + ":" + rowData.getPeriodModeTo();
            tpid = (String)tpid + ":" + rowData.getPeriodValueTo();
            tariffPlans.add(tpid);
        });
        request.setAttribute(TARIFF, Utils.toString(tariffPlans));
        request.setAttribute("tgid", Utils.toString(this.tariffGroupTableModel.getRows().stream().filter(e -> e.isSelected()).map(t -> t.getId()).collect(Collectors.toList())));
        return true;
    }

    class TariffModel
    extends BGTableModel<RowData> {
        private Directory<TariffGroup> tariffGroupDirectory;

        public TariffModel(String name) {
            super(name);
            this.tariffGroupDirectory = null;
            try {
                this.tariffGroupDirectory = PatternTariffTabPanel.this.getContext().getDirectory(TariffGroup.class);
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u043e\u0437\u0438\u0446\u0438\u044f", 90, 90, 90, "position", true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430", -1, -1, -1, "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0430\u0440\u0438\u0444\u043d\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430", -1, -1, -1, "groupId", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", Period.class, 200, 200, 200, "period", true);
        }

        @Override
        public Object getValueAt(RowData rowData, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("groupId".equals(identifier)) {
                int groupId = rowData.getGroupId();
                if (groupId == -1) {
                    return "\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e";
                }
                if (groupId == 0) {
                    return "<\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430>";
                }
                TariffGroup tariffGroup = this.tariffGroupDirectory.get(groupId);
                return tariffGroup != null ? tariffGroup.getTitle() : "<\u0433\u0440\u0443\u043f\u043f\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 #" + groupId + ">";
            }
            if ("period".equals(identifier)) {
                LocalDate periodFrom = TimeUtils.getPeriodFrom(LocalDate.now(), rowData.getPeriodModeFrom(), rowData.getPeriodValueFrom());
                LocalDate periodTo = TimeUtils.getPeriodTo(periodFrom, rowData.getPeriodModeTo(), rowData.getPeriodValueTo());
                return new Period(periodFrom, periodTo);
            }
            return super.getValueAt(rowData, column);
        }
    }

    class TariffGroupModel
    extends BGTableModel<PatternTableModelItem> {
        public TariffGroupModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("V", 50, 50, 50, "selected").setTableCellRenderer(new RadioButtonTableCellRenderer());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title").setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class TariffEditor
    extends BGEditorDialog<RowData> {
        private BGUList<IdTitle> tariffs;
        private BGUComboBox<IdTitle> tariffGroup;
        private BGUComboBox<KeyValue> periodModeFrom;
        private BGUComboBox<KeyValue> periodModeTo;
        private JTextField periodValueFrom;
        private JTextField periodValueTo;
        private JTextField position;

        public TariffEditor(String title, RowData data) {
            super(title, data);
            this.tariffs = new BGUList();
            this.tariffGroup = new BGUComboBox();
            this.periodModeFrom = new BGUComboBox();
            this.periodModeTo = new BGUComboBox();
            this.periodValueFrom = new JTextField(5);
            this.periodValueTo = new JTextField(5);
            this.position = new JTextField(5);
        }

        @Override
        public void doDialogPanel() {
            this.tariffs.setSelectionMode(0);
            JScrollPane scrollPane = new JScrollPane(this.tariffs);
            scrollPane.setMinimumSize(new Dimension(500, 250));
            scrollPane.setPreferredSize(new Dimension(500, 250));
            this.panel.add((Component)new JLabel("\u0422\u0430\u0440\u0438\u0444:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 13, 1, new Insets(3, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.getPeriodPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 13, 1, new Insets(3, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.getGroupAndPositionPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 13, 1, new Insets(10, 0, 0, 0), 0, 0));
            ArrayList tariffData = new ArrayList();
            ArrayList<IdTitle> tariffGroupItems = new ArrayList<IdTitle>();
            try {
                PatternTariffTabPanel.this.getTariffService().tariffPlanList(new ArrayList<Integer>(), null, null).stream().forEach(g -> tariffData.add(new IdTitle(g.getId(), g.getTitle())));
                this.tariffs.setData(tariffData);
                tariffGroupItems.add(new IdTitle(-1, "\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e"));
                tariffGroupItems.add(new IdTitle(0, "<\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430>"));
                PatternTariffTabPanel.this.getTariffService().tariffGroupList().forEach(g -> tariffGroupItems.add(new IdTitle(g.getId(), g.getTitle())));
                this.tariffGroup.setData(tariffGroupItems);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            if (tariffData.isEmpty()) {
                this.tariffs.setSelectedIndex(-1);
            } else {
                this.tariffs.setSelectedValue(tariffData.stream().filter(a -> a.getId() == ((RowData)this.data).getId()).findFirst().orElse((IdTitle)tariffData.get(0)), true);
            }
            this.tariffGroup.setSelectedItem(tariffGroupItems.stream().filter(a -> a.getId() == ((RowData)this.data).getGroupId()).findFirst().orElse((IdTitle)tariffGroupItems.get(0)));
            this.position.setText(String.valueOf(((RowData)this.data).getPosition()));
            this.periodModeFrom.setSelectedItem(PatternTariffTabPanel.this.tariffPeriodModeFrom.stream().filter(a -> a.getKey().equals(((RowData)this.data).getPeriodModeFrom())).findFirst().orElse(PatternTariffTabPanel.this.tariffPeriodModeFrom.get(0)));
            this.periodValueFrom.setText(String.valueOf(((RowData)this.data).getPeriodValueFrom()));
            this.periodModeTo.setSelectedItem(PatternTariffTabPanel.this.tariffPeriodModeTo.stream().filter(a -> a.getKey().equals(((RowData)this.data).getPeriodModeTo())).findFirst().orElse(PatternTariffTabPanel.this.tariffPeriodModeTo.get(0)));
            this.periodValueTo.setText(String.valueOf(((RowData)this.data).getPeriodValueTo()));
        }

        private JPanel getGroupAndPositionPanel() {
            this.position.setHorizontalAlignment(0);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u0430 \u0442\u0430\u0440\u0438\u0444\u043e\u0432:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add(this.tariffGroup, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041f\u043e\u0437\u0438\u0446\u0438\u044f:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
            panel.add((Component)this.position, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getPeriodPanel() {
            this.periodValueFrom.setHorizontalAlignment(0);
            this.periodValueTo.setHorizontalAlignment(0);
            this.periodModeFrom.setData(PatternTariffTabPanel.this.tariffPeriodModeFrom);
            this.periodModeTo.setData(PatternTariffTabPanel.this.tariffPeriodModeTo);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0447\u0430\u043b\u043e:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add(this.periodModeFrom, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.periodValueFrom, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add(this.periodModeTo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.periodValueTo, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            return panel;
        }

        @Override
        public boolean doApply() throws Exception {
            IdTitle idTitle = (IdTitle)this.tariffs.getSelectedValue();
            if (idTitle == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \"\u0422\u0430\u0440\u0438\u0444\"!");
                return false;
            }
            if (((RowData)this.data).getId() == 0) {
                PatternTariffTabPanel.this.tariffTableModel.addRow((RowData)this.data);
            }
            ((RowData)this.data).setId(idTitle.getId());
            ((RowData)this.data).setTitle(idTitle.getTitle());
            ((RowData)this.data).setValue(Boolean.TRUE);
            ((RowData)this.data).setGroupId(((IdTitle)this.tariffGroup.getSelectedItem()).getId());
            ((RowData)this.data).setPosition(String.valueOf(Utils.parseInt(this.position.getText())));
            ((RowData)this.data).setPeriodModeFrom(((KeyValue)this.periodModeFrom.getSelectedItem()).getKey());
            ((RowData)this.data).setPeriodValueFrom(Utils.parseInt(this.periodValueFrom.getText()));
            ((RowData)this.data).setPeriodModeTo(((KeyValue)this.periodModeTo.getSelectedItem()).getKey());
            ((RowData)this.data).setPeriodValueTo(Utils.parseInt(this.periodValueTo.getText()));
            PatternTariffTabPanel.this.tariffTableModel.fireTableDataChanged();
            return true;
        }
    }
}

