/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.period.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.period.common.bean.ContractPeriod;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public class ContractPeriodDao
extends AbstractIdDao<ContractPeriod> {
    private PreparedStatement psUpdateSet = null;

    public ContractPeriodDao(Connection con) {
        super(con, 0, "contract_period");
    }

    public void searchContractPeriod(SearchResult<ContractPeriod> searchResult, int contractId) throws BGException {
        Page page = searchResult.getPage();
        if (page == null) {
            page = new Page(1, -1);
        }
        List<ContractPeriod> list = searchResult.getList();
        try {
            String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " WHERE true";
            if (contractId > 0) {
                query = query + " AND contract_id=?";
            }
            query = query + page.sqlLimit();
            int parameterIndex = 1;
            PreparedStatement ps = this.con.prepareStatement(query, 1);
            if (contractId > 0) {
                ps.setInt(parameterIndex++, contractId);
            }
            ResultSet resultSet = ps.executeQuery();
            while (resultSet.next()) {
                list.add(this.getFromRS(resultSet));
            }
            resultSet.close();
            ps.close();
            page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    public boolean setSentCloseEventFlag(int id) throws BGException {
        try {
            if (this.psUpdateSet == null) {
                String query = "UPDATE " + this.tableName + " SET generate_event=2 WHERE  id=? AND generate_event=1";
                this.psUpdateSet = this.con.prepareStatement(query, 1);
            }
            this.psUpdateSet.setInt(1, id);
            return this.psUpdateSet.executeUpdate() > 0;
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    @Override
    protected ContractPeriod getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractPeriod contractPeriod = new ContractPeriod();
        contractPeriod.setId(rs.getInt("id"));
        contractPeriod.setContractId(rs.getInt("contract_id"));
        contractPeriod.setUserId(rs.getInt("user_id"));
        contractPeriod.setPeriod(new PeriodWithTime(rs.getTimestamp("date_from"), rs.getTimestamp("date_to")));
        contractPeriod.setLastUpdate(TimeUtils.convertTimestampToLocalDateTime(rs.getTimestamp("lm")));
        int generateEvent = rs.getInt("generate_event");
        contractPeriod.setGenerateCloseEvent(generateEvent > 0);
        contractPeriod.setSentCloseEvent(generateEvent > 1);
        contractPeriod.setJobId(rs.getLong("job_id"));
        return contractPeriod;
    }

    @Override
    protected void updateImpl(ContractPeriod contractPeriod) throws BGException, SQLException {
        Objects.requireNonNull(contractPeriod);
        try {
            int parameterIndex = 1;
            boolean isInsert = contractPeriod.getId() < 1;
            String query = (isInsert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET contract_id =?, date_from=?, date_to=?, generate_event=?, user_id=?, job_id=?" + (isInsert ? "" : " WHERE id=?");
            PreparedStatement ps = this.con.prepareStatement(query, 1);
            ps.setInt(parameterIndex++, contractPeriod.getContractId());
            ps.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp(contractPeriod.getPeriod().getDateFrom()));
            ps.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp(contractPeriod.getPeriod().getDateTo()));
            ps.setInt(parameterIndex++, contractPeriod.isGenerateCloseEvent() ? (contractPeriod.isSentCloseEvent() ? 2 : 1) : 0);
            ps.setInt(parameterIndex++, contractPeriod.getUserId());
            ps.setLong(parameterIndex++, contractPeriod.getJobId());
            if (contractPeriod.getId() > 0) {
                ps.setInt(parameterIndex++, contractPeriod.getId());
            }
            ps.executeUpdate();
            ps.close();
            contractPeriod.setId(ServerUtils.lastInsertId((Connection)this.con));
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    public List<ContractPeriod> getContractPeriodList(long period) throws BGException {
        ArrayList<ContractPeriod> list = new ArrayList<ContractPeriod>();
        try {
            LocalDateTime date = LocalDateTime.now().plusSeconds(period);
            String query = "SELECT * FROM " + this.tableName + " WHERE date_to < ? AND generate_event=1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setTimestamp(1, TimeUtils.convertLocalDateTimeToTimestamp(date));
            ResultSet resultSet = ps.executeQuery();
            while (resultSet.next()) {
                list.add(this.getFromRS(resultSet));
            }
            resultSet.close();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException(e);
        }
        return list;
    }

    public void deleteForContract(int contractId) throws BGException {
        try {
            String query = "DELETE  FROM " + this.tableName + " WHERE contract_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex.getMessage(), ex);
        }
    }

    @Override
    public void close() throws BGException {
        if (this.psUpdateSet != null) {
            try {
                this.psUpdateSet.close();
                this.psUpdateSet = null;
            }
            catch (SQLException e) {
                throw new BGException(e);
            }
        }
        super.close();
    }
}

