/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.server;

import bitel.billing.server.admin.errorlog.AlarmSender;
import bitel.billing.server.admin.errorlog.bean.AlarmErrorMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.CompilationMessage;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.CompilationResult;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicClass;
import ru.bitel.bgbilling.kernel.dynamic.server.CompilerWrapper;
import ru.bitel.bgbilling.kernel.dynamic.server.DatabaseClassLoader;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.dynamic.server.bean.DynamicCodeDao;
import ru.bitel.bgbilling.kernel.dynamic.server.event.ScriptSavingEvent;
import ru.bitel.bgbilling.kernel.dynamic.server.event.ScriptUpdatedEvent;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.model.Pair;

public class ReadWriteClassManager
extends DynamicClassManager {
    private CompilerWrapper javac = new CompilerWrapper(new File(DynamicCodeDao.getScriptsDir()), new File(System.getProperty("java.io.tmpdir")));

    public ReadWriteClassManager() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ReadWriteClassManager(ClassLoader parentClassLoader) {
        super(parentClassLoader);
    }

    @Override
    protected void addListeners() throws BGException {
        EventProcessor.getInstance().addListener(new EventListener<ScriptSavingEvent>(){

            /*
             * Loose catch block
             */
            @Override
            public void notify(ScriptSavingEvent e, EventListenerContext ctx) throws BGException {
                CompilationResult result = null;
                Connection con = null;
                try {
                    con = Setup.getSetup().getDBConnectionFromPool();
                    con.setAutoCommit(false);
                    if (e.isClearTable()) {
                        new DynamicCodeDao(con).clearTables();
                    }
                    ReadWriteClassManager.this.flushLoadedClassCache();
                    Pair<CompilationResult, List<CompilerWrapper.CompiledUnit>> pair = ReadWriteClassManager.this.recompile(con, e.getClassNames(), true);
                    result = pair.getFirst();
                    List<String> classNames = pair.getSecond().stream().map(f -> f.className).collect(Collectors.toList());
                    con.commit();
                    EventProcessor.getInstance().publish(new ScriptUpdatedEvent(classNames));
                }
                catch (CompilerWrapper.CompilationFailedException ex) {
                    try {
                        con.rollback();
                    }
                    catch (SQLException ex1) {
                        throw new BGException(ex1);
                    }
                    result = ex.getCompilationResult();
                    ServerUtils.closeConnection((Connection)con);
                    e.setCompilationResult(result != null ? result : new CompilationResult());
                }
                catch (Exception ex2) {
                    ReadWriteClassManager.this.logger.error(ex2.getMessage(), (Throwable)ex2);
                    throw new BGException(ex2);
                    {
                        catch (Throwable throwable) {
                            ServerUtils.closeConnection((Connection)con);
                            e.setCompilationResult(result != null ? result : new CompilationResult());
                            throw throwable;
                        }
                    }
                }
                ServerUtils.closeConnection((Connection)con);
                e.setCompilationResult(result != null ? result : new CompilationResult());
            }
        }, ScriptSavingEvent.class);
    }

    public void recompileAll() {
        BGNestedContext.push("script");
        try {
            this.recompileAll0();
        }
        finally {
            BGNestedContext.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void recompileAll0() {
        block32: {
            Connection con;
            CompilationResult result;
            Exception t;
            block29: {
                t = null;
                result = null;
                con = null;
                con = Setup.getSetup().getDBConnectionFromPool();
                con.setAutoCommit(false);
                result = this.recompileAllClasses(con);
                if (result != null && result.getErrors().size() <= 0) break block29;
                String key = "dynamic.code.recompilation.error";
                long time = System.currentTimeMillis();
                String subject = "\u041a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u044f \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043a\u043b\u0430\u0441\u0441\u043e\u0432 \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442 \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438!";
                StringBuilder text = new StringBuilder();
                if (result != null) {
                    text.append("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043d\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u0443\u0435\u043c\u044b\u0435 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b! \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u043e\u0448\u0438\u0431\u043a\u0438 \u043f\u043e\u044f\u0432\u0438\u043b\u0438\u0441\u044c \u0432 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f API \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430: \u0442\u0435\u043a\u0443\u0449\u0438\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0435 \u0432 \u0411\u0414 \u043a\u043b\u0430\u0441\u0441\u044b \u043c\u043e\u0433\u0443\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e! \u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u043f\u0435\u0440\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0441\u0435 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b \u0438 \u0438\u0441\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043e\u0448\u0438\u0431\u043a\u0438!\n\n");
                    for (CompilationMessage msg : result.getErrors()) {
                        text.append(msg.getMessage());
                        text.append(" at ");
                        text.append(msg.getSource());
                        text.append(" on ");
                        text.append(msg.getLine());
                        text.append(":");
                        text.append(msg.getColumn());
                        text.append("\n");
                    }
                } else {
                    text.append("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u0438 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d!");
                }
                AlarmErrorMessage message = t != null ? new AlarmErrorMessage(key, subject, text.toString(), (Throwable)t) : new AlarmErrorMessage(key, subject, text.toString());
                AlarmSender.sendAlarm((AlarmErrorMessage)message, (long)time);
            }
            try {
                con.rollback();
            }
            catch (SQLException ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
            }
            ServerUtils.closeConnection((Connection)con);
            break block32;
            catch (CompilerWrapper.CompilationFailedException ex) {
                block30: {
                    result = ex.getCompilationResult();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Dynamic class recompilation FAILED: " + ex.getCompilationResult().getErrors().size() + "errors!!!");
                    }
                    if (result != null && result.getErrors().size() <= 0) break block30;
                    String key = "dynamic.code.recompilation.error";
                    long time = System.currentTimeMillis();
                    String subject = "\u041a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u044f \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043a\u043b\u0430\u0441\u0441\u043e\u0432 \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442 \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438!";
                    StringBuilder text = new StringBuilder();
                    if (result != null) {
                        text.append("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043d\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u0443\u0435\u043c\u044b\u0435 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b! \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u043e\u0448\u0438\u0431\u043a\u0438 \u043f\u043e\u044f\u0432\u0438\u043b\u0438\u0441\u044c \u0432 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f API \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430: \u0442\u0435\u043a\u0443\u0449\u0438\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0435 \u0432 \u0411\u0414 \u043a\u043b\u0430\u0441\u0441\u044b \u043c\u043e\u0433\u0443\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e! \u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u043f\u0435\u0440\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0441\u0435 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b \u0438 \u0438\u0441\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043e\u0448\u0438\u0431\u043a\u0438!\n\n");
                        for (CompilationMessage msg : result.getErrors()) {
                            text.append(msg.getMessage());
                            text.append(" at ");
                            text.append(msg.getSource());
                            text.append(" on ");
                            text.append(msg.getLine());
                            text.append(":");
                            text.append(msg.getColumn());
                            text.append("\n");
                        }
                    } else {
                        text.append("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u0438 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d!");
                    }
                    AlarmErrorMessage message = t != null ? new AlarmErrorMessage(key, subject, text.toString(), (Throwable)t) : new AlarmErrorMessage(key, subject, text.toString());
                    AlarmSender.sendAlarm((AlarmErrorMessage)message, (long)time);
                }
                try {
                    con.rollback();
                }
                catch (SQLException ex2) {
                    this.logger.error(ex2.getMessage(), (Throwable)ex2);
                }
                ServerUtils.closeConnection((Connection)con);
            }
            catch (Exception ex2) {
                block31: {
                    t = ex2;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Dynamic class recompilation FAILED: " + ex2.getMessage() + "!", (Throwable)ex2);
                    }
                    if (result != null && result.getErrors().size() <= 0) break block31;
                    String key = "dynamic.code.recompilation.error";
                    long time = System.currentTimeMillis();
                    String subject = "\u041a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u044f \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043a\u043b\u0430\u0441\u0441\u043e\u0432 \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442 \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438!";
                    StringBuilder text = new StringBuilder();
                    if (result != null) {
                        text.append("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043d\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u0443\u0435\u043c\u044b\u0435 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b! \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u043e\u0448\u0438\u0431\u043a\u0438 \u043f\u043e\u044f\u0432\u0438\u043b\u0438\u0441\u044c \u0432 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f API \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430: \u0442\u0435\u043a\u0443\u0449\u0438\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0435 \u0432 \u0411\u0414 \u043a\u043b\u0430\u0441\u0441\u044b \u043c\u043e\u0433\u0443\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e! \u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u043f\u0435\u0440\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0441\u0435 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b \u0438 \u0438\u0441\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043e\u0448\u0438\u0431\u043a\u0438!\n\n");
                        for (CompilationMessage msg : result.getErrors()) {
                            text.append(msg.getMessage());
                            text.append(" at ");
                            text.append(msg.getSource());
                            text.append(" on ");
                            text.append(msg.getLine());
                            text.append(":");
                            text.append(msg.getColumn());
                            text.append("\n");
                        }
                    } else {
                        text.append("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u0438 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d!");
                    }
                    AlarmErrorMessage message = t != null ? new AlarmErrorMessage(key, subject, text.toString(), (Throwable)t) : new AlarmErrorMessage(key, subject, text.toString());
                    AlarmSender.sendAlarm((AlarmErrorMessage)message, (long)time);
                }
                try {
                    con.rollback();
                }
                catch (SQLException ex3) {
                    this.logger.error(ex3.getMessage(), (Throwable)ex3);
                }
                ServerUtils.closeConnection((Connection)con);
                {
                    catch (Throwable throwable) {
                        if (result == null || result.getErrors().size() > 0) {
                            String key = "dynamic.code.recompilation.error";
                            long time = System.currentTimeMillis();
                            String subject = "\u041a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u044f \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043a\u043b\u0430\u0441\u0441\u043e\u0432 \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442 \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438!";
                            StringBuilder text = new StringBuilder();
                            if (result != null) {
                                text.append("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043d\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u0443\u0435\u043c\u044b\u0435 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b! \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u043e\u0448\u0438\u0431\u043a\u0438 \u043f\u043e\u044f\u0432\u0438\u043b\u0438\u0441\u044c \u0432 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f API \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430: \u0442\u0435\u043a\u0443\u0449\u0438\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0435 \u0432 \u0411\u0414 \u043a\u043b\u0430\u0441\u0441\u044b \u043c\u043e\u0433\u0443\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e! \u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u043f\u0435\u0440\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0441\u0435 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b \u0438 \u0438\u0441\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043e\u0448\u0438\u0431\u043a\u0438!\n\n");
                                for (CompilationMessage msg : result.getErrors()) {
                                    text.append(msg.getMessage());
                                    text.append(" at ");
                                    text.append(msg.getSource());
                                    text.append(" on ");
                                    text.append(msg.getLine());
                                    text.append(":");
                                    text.append(msg.getColumn());
                                    text.append("\n");
                                }
                            } else {
                                text.append("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u0438 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d!");
                            }
                            AlarmErrorMessage message = t != null ? new AlarmErrorMessage(key, subject, text.toString(), (Throwable)t) : new AlarmErrorMessage(key, subject, text.toString());
                            AlarmSender.sendAlarm((AlarmErrorMessage)message, (long)time);
                        }
                        try {
                            con.rollback();
                        }
                        catch (SQLException ex4) {
                            this.logger.error(ex4.getMessage(), (Throwable)ex4);
                        }
                        ServerUtils.closeConnection((Connection)con);
                        throw throwable;
                    }
                }
            }
        }
    }

    private Pair<CompilationResult, List<CompilerWrapper.CompiledUnit>> recompile(Connection con, List<String> targetClassNames, boolean needConnectionCommit) throws BGException {
        DynamicCodeDao dao = new DynamicCodeDao(con);
        ArrayList<File> srcFiles = new ArrayList<File>();
        for (String name : targetClassNames) {
            if (!DynamicClass.isJavaSource(name)) continue;
            srcFiles.add(DynamicCodeDao.getClassFile(name));
        }
        if (srcFiles.size() == 0) {
            return new Pair<CompilationResult, List<CompilerWrapper.CompiledUnit>>(new CompilationResult(), Collections.emptyList());
        }
        Pair<CompilationResult, List<CompilerWrapper.CompiledUnit>> result = this.javac.compile(srcFiles);
        List<CompilerWrapper.CompiledUnit> units = result.getSecond();
        DatabaseClassLoader loader = new DatabaseClassLoader(this.parentClassLoader);
        for (CompilerWrapper.CompiledUnit unit : units) {
            try {
                FileInputStream fis = new FileInputStream(unit.classFile);
                byte[] data = Utils.readByBlock(fis);
                dao.updateClassData(unit.className, data, unit.srcFile.lastModified());
            }
            catch (IOException ex) {
                throw new BGException(unit.className + ": " + ex.getMessage(), ex);
            }
        }
        if (needConnectionCommit) {
            ServerUtils.commitConnection((Connection)con);
        }
        this.javac.deleteClassDir();
        for (CompilerWrapper.CompiledUnit unit : units) {
            try {
                Class<?> loaded = loader.loadClass(unit.className);
                this.addLoadedClass(unit.className, loaded);
                dao.updateClassInterfaces(loaded);
            }
            catch (ClassNotFoundException e) {
                throw new BGException(unit.className + ": " + e.getMessage(), e);
            }
            catch (Throwable e) {
                throw new BGException(unit.className + ": " + e.getMessage(), e);
            }
        }
        return result;
    }

    public CompilationResult recompileAllClasses(Connection con) throws BGException {
        DynamicCodeDao dao = new DynamicCodeDao(con);
        dao.clearTables();
        this.flushLoadedClassCache();
        List<String> classes = dao.getDynamicClasses().stream().map(DynamicClass::getClassName).collect(Collectors.toList());
        Pair<CompilationResult, List<CompilerWrapper.CompiledUnit>> pair = this.recompile(con, classes, false);
        CompilationResult result = pair.getFirst();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Dynamic class recompilation OK!");
        }
        return result;
    }
}

