/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.info;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;

public class AbinaryInfo
extends RadiusAttributeInfo<String> {
    private static final Logger logger = LogManager.getLogger();

    public AbinaryInfo(int vendor, int code, String name, Element attr, List<RadiusAttributeInfo<?>> children) {
        super(vendor, code, name, 11, attr, children);
    }

    private byte[] encode(String data) {
        int len = data.length();
        if (len > 0 && data.charAt(0) == '\\') {
            byte prefix = Byte.decode(data.substring(1, 4));
            byte[] encoded = this.vendor != -1 && this.addAvpName ? (this.name.toLowerCase() + "=" + data.substring(4)).getBytes(StandardCharsets.UTF_8) : data.substring(4).getBytes(StandardCharsets.UTF_8);
            byte[] result = new byte[encoded.length + 1];
            result[0] = prefix;
            System.arraycopy(encoded, 0, result, 1, encoded.length);
            return result;
        }
        return data.getBytes(StandardCharsets.UTF_8);
    }

    private String decode(byte[] data) {
        int pos;
        if (data.length == 0) {
            return "";
        }
        byte prefix = data[0];
        byte[] encoded = new byte[data.length - 1];
        System.arraycopy(data, 1, encoded, 0, encoded.length);
        String decoded = new String(encoded, StandardCharsets.UTF_8);
        if (this.vendor != -1 && this.addAvpName && decoded != null && (pos = decoded.indexOf("=")) > 0) {
            return "\\0x" + Integer.toHexString(prefix) + decoded.substring(pos + 1);
        }
        return "\\0x" + Integer.toHexString(prefix) + decoded;
    }

    @Override
    public String unwrapValue(ByteBuffer data) {
        byte[] encoded = new byte[data.limit()];
        data.get(encoded);
        data.rewind();
        return this.decode(encoded);
    }

    @Override
    public ByteBuffer wrapValue(String value) {
        return ByteBuffer.wrap(this.encode(value));
    }
}

