/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.script.common.bean.EventType;
import ru.bitel.common.Utils;

public class EventTypeManager {
    private Connection con;

    public EventTypeManager(Connection con) {
        this.con = con;
    }

    public List<EventType> getEventTypeList(int mode) {
        ArrayList<EventType> result = new ArrayList<EventType>();
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM script_event_type WHERE 1=1");
            if (mode > -1) {
                query.append(" AND event_mode=");
                query.append(mode);
            }
            query.append(" ORDER BY mid, title");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                EventType et = new EventType();
                this.loadEventTypeFromRS(et, rs);
                result.add(et);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<EventType> getEventTypeList(String idFilter) {
        ArrayList<EventType> result = new ArrayList<EventType>();
        if (Utils.notEmptyString(((String)idFilter).trim())) {
            try {
                idFilter = ((String)idFilter).replaceAll(",", "','");
                idFilter = "'" + (String)idFilter + "'";
                String query = "SELECT * FROM script_event_type WHERE CONCAT(mid, '_', event_id) IN ( " + (String)idFilter + " ) ORDER BY mid, title";
                PreparedStatement ps = this.con.prepareStatement(query);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    EventType et = new EventType();
                    this.loadEventTypeFromRS(et, rs);
                    result.add(et);
                }
                rs.close();
                ps.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    private void loadEventTypeFromRS(EventType result, ResultSet rs) throws SQLException {
        result.setId(rs.getInt("id"));
        result.setModuleId(rs.getString("mid"));
        result.setEventId(rs.getString("event_id"));
        result.setTitle(rs.getString("title"));
    }

    public List<EventType> getEventTypesByEventId(String eventId) throws BGException {
        ArrayList<EventType> result = new ArrayList<EventType>();
        try {
            String query = "SELECT * FROM script_event_type WHERE event_id=? ORDER BY mid, title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, eventId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                EventType et = new EventType();
                this.loadEventTypeFromRS(et, rs);
                result.add(et);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public List<EventType> filterNewEvents(List<EventType> in) {
        ArrayList<EventType> out = new ArrayList<EventType>();
        for (EventType et : in) {
            if (Utils.parseInt(et.getEventId(), -1) != -1) continue;
            out.add(et);
        }
        return out;
    }
}

