/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client;

import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroup;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroupTariff;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGLabeledControl;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.oss.kernel.directories.domain.common.bean.Domain;

public class TariffPlanGroupEditor
extends BGTabPanel {
    public static final String TAB_ID = "tariffPlanGroupEditor";
    private int tariffGroupId = -1;
    private TariffService tariffService = null;
    private BGTextField tariffGroupTitle = new BGTextField();
    private CardLayout cardLayout1 = new CardLayout();
    private TariffGroupTableModel tariffGroupTableModel = new TariffGroupTableModel(TariffGroupTableModel.class.getName());
    private TariffGroupTariffTableModel tariffPlansTableModel = new TariffGroupTariffTableModel();
    private BGUTable tariffPlansTable;
    private BGUTable tariffGroupTable;
    private JComboBox<ComboBoxItem> transferMode;
    private BGUComboBox<ComboBoxItem> domain = new BGUComboBox();
    private IntTextField tariffGroupPosition = new IntTextField();
    private IntTextField tariffGroupDaysForward = new IntTextField();
    private JPanel rightPanel = new JPanel();

    public TariffPlanGroupEditor() {
        super(TAB_ID, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0433\u0440\u0443\u043f\u043f \u0442\u0430\u0440\u0438\u0444\u043e\u0432");
        this.module = "tariff";
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setData();
        this.cardLayout1.show(this.rightPanel, "info");
    }

    private void jbInit() throws Exception {
        ComboBoxItem[] items = new ComboBoxItem[]{new ComboBoxItem("1", "\u043b\u044e\u0431\u043e\u0433\u043e \u0434\u043d\u044f, \u043d\u0430\u0447\u0438\u043d\u0430\u044f \u0441 \u0441\u0435\u0433\u043e\u0434\u043d\u044f\u0448\u043d\u0435\u0433\u043e"), new ComboBoxItem("4", "\u043b\u044e\u0431\u043e\u0433\u043e \u0434\u043d\u044f, \u043d\u0430\u0447\u0438\u043d\u0430\u044f \u0441 \u0437\u0430\u0432\u0442\u0440\u0430\u0448\u043d\u0435\u0433\u043e"), new ComboBoxItem("2", "\u043d\u0430\u0447\u0430\u043b\u0430 \u043d\u0435\u0434\u0435\u043b\u0438"), new ComboBoxItem("3", "\u043d\u0430\u0447\u0430\u043b\u0430 \u043c\u0435\u0441\u044f\u0446\u0430")};
        this.transferMode = new JComboBox<ComboBoxItem>(items);
        this.tariffPlansTable = new BGUTable(this.tariffPlansTableModel);
        this.tariffPlansTable.setSelectionMode(0);
        this.tariffPlansTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TariffPlanGroupEditor.this.toolbarPositionAction(BGDialogToolBar.ButtonData.EDIT_ITEM.getName());
                }
            }
        });
        this.tariffGroupTable = new BGUTable(this.tariffGroupTableModel);
        this.tariffGroupTable.setSelectionMode(0);
        this.tariffGroupTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TariffPlanGroupEditor.this.editItem();
                }
            }
        });
        BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();
        okCancelPanel.addActionListener(e -> this.exitGroupEditor(e.getActionCommand().equals("ok")));
        this.tariffGroupPosition.setMinimumSize(new Dimension(50, 24));
        this.tariffGroupDaysForward.setMinimumSize(new Dimension(100, 24));
        this.tariffGroupDaysForward.setText("intTextField1");
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.setBorder(new BGTitleBorder(" \u0413\u0440\u0443\u043f\u043f\u044b \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0445 \u043f\u043b\u0430\u043d\u043e\u0432 "));
        leftPanel.add((Component)new JScrollPane(this.tariffGroupTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel labelPanel = new JPanel(new GridBagLayout());
        JLabel jLabel1 = new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0433\u0440\u0443\u043f\u043f\u0443", 0);
        labelPanel.add((Component)jLabel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 50, 0, 50), 0, 0));
        BGDialogToolBar tariffToolBar = new BGDialogToolBar();
        tariffToolBar.setDefaultButtons(e -> this.toolbarPositionAction(e.getActionCommand()), BGDialogToolBar.ButtonData.NEW_ITEM, BGDialogToolBar.ButtonData.EDIT_ITEM, BGDialogToolBar.ButtonData.DELETE_ITEM, BGDialogToolBar.ButtonData.SEPARATOR, BGDialogToolBar.ButtonData.REFRESH);
        tariffToolBar.setFloatable(false);
        tariffToolBar.setOrientation(0);
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)new BGLabeledControl(this.transferMode, "\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u0441:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel2.add((Component)new BGLabeledControl(this.domain, "\u0414\u043e\u043c\u0435\u043d:"), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 20, 0, 0), 0, 0));
        JPanel editorPanel = new JPanel(new GridBagLayout());
        editorPanel.add((Component)new BGLabeledControl(this.tariffGroupTitle, "\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435: "), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        editorPanel.add((Component)new BGLabeledControl(this.tariffGroupPosition, "\u041f\u043e\u0437\u0438\u0446\u0438\u044f \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430: "), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        editorPanel.add((Component)panel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        editorPanel.add((Component)new BGLabeledControl(this.tariffGroupDaysForward, "\u0417\u0430\u0434\u0430\u043d\u0438\u044f \u0437\u0430 (\u0434\u043d\u0435\u0439 \u0432\u043f\u0435\u0440\u0451\u0434): "), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        editorPanel.add((Component)tariffToolBar, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        editorPanel.add((Component)new JScrollPane(this.tariffPlansTable), new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        editorPanel.add((Component)okCancelPanel, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.rightPanel.setLayout(this.cardLayout1);
        this.rightPanel.add((Component)editorPanel, "editor");
        this.rightPanel.add((Component)labelPanel, "info");
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, leftPanel, (Component)this.rightPanel, 800L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void toolbarPositionAction(String command) {
        switch (BGDialogToolBar.ButtonData.of(command)) {
            case NEW_ITEM: {
                new TariffGroupTariffEditor("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0442\u0430\u0440\u0438\u0444 \u0432 \u0433\u0440\u0443\u043f\u043f\u0443", new TariffGroupTariff()).getDialog().setVisible(true);
                break;
            }
            case EDIT_ITEM: {
                TariffGroupTariff tariffGroupTariff = (TariffGroupTariff)this.tariffPlansTableModel.getSelectedRow();
                if (tariffGroupTariff == null) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                    return;
                }
                new TariffGroupTariffEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430 \u0432 \u0433\u0440\u0443\u043f\u043f\u0435", tariffGroupTariff).getDialog().setVisible(true);
                break;
            }
            case DELETE_ITEM: {
                this.tariffPlansTableModel.deleteSelectedRows();
                break;
            }
            case REFRESH: {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430?", "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435", 0) != 0) break;
                this.editTariffGroup();
                break;
            }
        }
    }

    @Override
    public void setData() {
        try {
            this.tariffGroupTableModel.setData(this.getTariffService().tariffGroupList());
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    private void editTariffGroup() {
        Async<List> domainList = Async.of(() -> {
            List<Domain> list = this.getContext().getDirectory(Domain.class, 0).list();
            Set parentIds = list.stream().map(a -> a.getParentId()).collect(Collectors.toSet());
            ArrayList<Domain> list2 = new ArrayList<Domain>(list.size() + 1);
            Domain domain = new Domain();
            domain.setTitle("---");
            list2.add(domain);
            list.stream().filter(a -> !parentIds.contains(a.getId())).collect(Collectors.toCollection(() -> list2));
            return list2;
        });
        try {
            ArrayList items = new ArrayList();
            domainList.get().forEach(d -> items.add(new ComboBoxItem(String.valueOf(d.getId()), d.getTitle())));
            this.domain.setData(items);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tariffGroupTable.setEnabled(false);
        if (this.tariffGroupId < 1) {
            this.tariffGroupTitle.setText("");
            this.tariffGroupPosition.setText("0");
            this.transferMode.setSelectedIndex(0);
            this.tariffPlansTableModel.setData(new ArrayList());
            this.domain.setSelectedIndex(0);
        } else {
            try {
                TariffGroup tariffGroup = this.getTariffService().tariffGroupGet(this.tariffGroupId);
                if (tariffGroup != null) {
                    this.tariffGroupTitle.setText(tariffGroup.getTitle());
                    ClientUtils.setComboBoxSelection(this.transferMode, String.valueOf(tariffGroup.getTransferMode()));
                    this.tariffGroupPosition.setText(String.valueOf(tariffGroup.getPos()));
                    this.tariffGroupDaysForward.setText(String.valueOf(tariffGroup.getDaysForward()));
                    ClientUtils.setComboBoxSelection(this.domain, String.valueOf(tariffGroup.getDomainId()));
                    this.tariffPlansTableModel.setData(tariffGroup.getPlanList());
                }
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        }
        this.cardLayout1.show(this.rightPanel, "editor");
    }

    @Override
    public void newItem() {
        if (this.tariffGroupTable.isEnabled()) {
            this.tariffGroupId = -1;
            this.editTariffGroup();
        }
    }

    @Override
    public void editItem() {
        TariffGroup tariffGroup = (TariffGroup)this.tariffGroupTableModel.getSelectedRow();
        if (tariffGroup != null && this.tariffGroupTable.isEnabled()) {
            this.tariffGroupId = tariffGroup.getId();
            this.editTariffGroup();
        }
    }

    @Override
    public void deleteItem() {
        TariffGroup tariffGroup = (TariffGroup)this.tariffGroupTableModel.getSelectedRow();
        if (tariffGroup != null && this.tariffGroupTable.isEnabled() && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u0443 \u0442\u0430\u0440\u0438\u0444\u043e\u0432 '" + tariffGroup.getTitle() + "'?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            try {
                this.getTariffService().tariffGroupDelete(tariffGroup.getId());
                this.setData();
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        }
    }

    private TariffService getTariffService() {
        if (this.tariffService == null) {
            this.tariffService = this.getContext().getPort(TariffService.class);
        }
        return this.tariffService;
    }

    private void exitGroupEditor(boolean save) {
        if (save) {
            try {
                TariffGroup tariffGroup = new TariffGroup();
                tariffGroup.setId(this.tariffGroupId);
                tariffGroup.setTitle(this.tariffGroupTitle.getText());
                tariffGroup.setPos((int)this.tariffGroupPosition.getValue());
                tariffGroup.setTransferMode(Utils.parseInt(String.valueOf(((ComboBoxItem)this.transferMode.getSelectedItem()).getObject())));
                tariffGroup.setDaysForward(Utils.parseInt(this.tariffGroupDaysForward.getText()));
                tariffGroup.setDomainId(Utils.parseInt(String.valueOf(((ComboBoxItem)this.domain.getSelectedItem()).getObject())));
                tariffGroup.setPlanList(this.tariffPlansTableModel.getRows());
                this.getTariffService().tariffGroupUpdate(tariffGroup);
                this.cardLayout1.show(this.rightPanel, "info");
                this.tariffGroupTable.setEnabled(true);
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        } else {
            this.cardLayout1.show(this.rightPanel, "info");
            this.tariffGroupTable.setEnabled(true);
        }
        this.setData();
    }

    @Override
    public int getModuleId() {
        return 0;
    }

    @Override
    public ClientContext getContext() {
        return super.getContext();
    }

    class TariffGroupTableModel
    extends BGTableModel<TariffGroup> {
        private Directory<Domain> directory;

        public TariffGroupTableModel(String name) {
            super(name);
            this.directory = null;
            try {
                this.directory = TariffPlanGroupEditor.this.getContext().getDirectory(Domain.class);
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 150, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u043e\u043c\u0435\u043d", 50, 100, -1, "domainId", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumnId();
        }

        @Override
        public Object getValue(TariffGroup tariffGroup, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("domainId".equals(identifier)) {
                Domain domain = this.directory.get(tariffGroup.getDomainId());
                return domain == null ? "<\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d>" : domain.getTitle();
            }
            return super.getValue(tariffGroup, column);
        }
    }

    class TariffGroupTariffTableModel
    extends BGTableModel<TariffGroupTariff> {
        public TariffGroupTariffTableModel() {
            super(TariffGroupTariffTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, 300, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, 400, -1, "comment", false);
            this.addColumn("\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430", -1, 100, -1, "date1", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("\u041a\u043e\u043d\u0435\u0446 \u043f\u0435\u0440\u0438\u043e\u0434\u0430", -1, 100, -1, "date2", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
        }
    }

    class TariffGroupTariffEditor
    extends BGEditorDialog<TariffGroupTariff> {
        private BGUComboBox<ComboBoxItem> tariffComboBox;
        private BGControlPanelPeriodNoB tariffPanelPeriod;
        private JTextArea tariffComment;

        public TariffGroupTariffEditor(String title, TariffGroupTariff data) {
            super(title, data);
            this.tariffComboBox = new BGUComboBox();
            this.tariffPanelPeriod = new BGControlPanelPeriodNoB();
            this.tariffComment = new JTextArea();
        }

        @Override
        public void doDialogPanel() {
            Async<List> tariffPlanList = Async.of(() -> TariffPlanGroupEditor.this.getContext().getDirectory(TariffPlan.class).list());
            try {
                ArrayList tariffItemList = new ArrayList();
                tariffPlanList.get().forEach(tp -> tariffItemList.add(new ComboBoxItem(String.valueOf(tp.getId()), tp.getTitle())));
                this.tariffComboBox.setData(tariffItemList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int gridy = 0;
            this.panel.add((Component)new JLabel("\u0422\u0430\u0440\u0438\u0444:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 5), 0, 0));
            this.panel.add(this.tariffComboBox, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 5), 0, 0));
            this.panel.add((Component)this.tariffPanelPeriod, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 5), 0, 0));
            this.panel.add((Component)this.getTariffCommentField(), new GridBagConstraints(1, gridy++, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
            ClientUtils.setComboBoxSelection(this.tariffComboBox, String.valueOf(((TariffGroupTariff)this.data).getId()));
            this.tariffPanelPeriod.setDateString1(TimeUtils.formatDate(((TariffGroupTariff)this.data).getDate1()));
            this.tariffPanelPeriod.setDateString2(TimeUtils.formatDate(((TariffGroupTariff)this.data).getDate2()));
            this.tariffComment.setText(((TariffGroupTariff)this.data).getComment());
        }

        @Override
        public boolean doApply() throws Exception {
            if (((TariffGroupTariff)this.data).getId() < 1) {
                TariffPlanGroupEditor.this.tariffPlansTableModel.getRows().add((TariffGroupTariff)this.data);
            }
            ComboBoxItem cbItem = (ComboBoxItem)this.tariffComboBox.getSelectedItem();
            ((TariffGroupTariff)this.data).setId(Utils.parseInt((String)cbItem.getObject()));
            ((TariffGroupTariff)this.data).setTitle(cbItem.toString());
            ((TariffGroupTariff)this.data).setDate1(this.tariffPanelPeriod.getDateFrom());
            ((TariffGroupTariff)this.data).setDate2(this.tariffPanelPeriod.getDateTo());
            ((TariffGroupTariff)this.data).setComment(this.tariffComment.getText());
            TariffPlanGroupEditor.this.tariffPlansTable.updateUI();
            return super.doApply();
        }

        private JScrollPane getTariffCommentField() {
            JScrollPane commentScrollPane = new JScrollPane(this.tariffComment);
            this.tariffComment.setLineWrap(true);
            Dimension dimension = new Dimension(100, 100);
            commentScrollPane.setMinimumSize(dimension);
            commentScrollPane.setPreferredSize(dimension);
            commentScrollPane.setHorizontalScrollBarPolicy(31);
            return commentScrollPane;
        }
    }
}

