/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGToolBar;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVar;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVarType;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.BGUAction;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class TariffVarsPanel
extends BGUPanel {
    private int tariffPlanId = 0;
    private TariffService tariffService;
    private VarsTableModel tableModel = new VarsTableModel();
    private List<BGModule> modules = new ArrayList<BGModule>();
    BGUAction editAction = new BGUAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u043d\u0430\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439", (Icon)ClientUtils.getIcon("edit")){

        @Override
        public void actionPerformed(ActionEvent e) {
            TariffVar tariffVar = (TariffVar)TariffVarsPanel.this.tableModel.getSelectedRow();
            if (tariffVar == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                return;
            }
            VarEditor editor = new VarEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439", tariffVar);
            editor.getDialog().setVisible(true);
            if (editor.getData() != null) {
                try {
                    TariffVarsPanel.this.tariffService.tariffVarUpdate((TariffVar)editor.getData());
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
                TariffVarsPanel.this.loadTariffVars();
            }
        }
    };

    public TariffVarsPanel(TariffService tariffService) {
        this.tariffService = tariffService;
    }

    @Override
    protected void jbInit() throws Exception {
        BGUTable table = new BGUTable(this.tableModel);
        table.setSelectionMode(0);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    TariffVarsPanel.this.editAction.actionPerformed(null);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getToolBar(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    private BGToolBar getToolBar() {
        BGToolBar toolBar = new BGToolBar(true);
        toolBar.add(new BGUAction("add", "\u041d\u043e\u0432\u0430\u044f \u0442\u0430\u0440\u0438\u0444\u043d\u0430\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439", (Icon)ClientUtils.getIcon("add")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TariffVar tariffVar = new TariffVar();
                tariffVar.setTariffPlanId(TariffVarsPanel.this.tariffPlanId);
                VarEditor editor = new VarEditor("\u041d\u043e\u0432\u0430\u044f \u0442\u0430\u0440\u0438\u0444\u043d\u0430\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439", tariffVar);
                editor.getDialog().setVisible(true);
                if (editor.getData() != null) {
                    try {
                        TariffVarsPanel.this.tariffService.tariffVarUpdate((TariffVar)editor.getData());
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                    TariffVarsPanel.this.loadTariffVars();
                }
            }
        });
        toolBar.add(Box.createHorizontalStrut(5));
        toolBar.add(this.editAction);
        toolBar.add(Box.createHorizontalStrut(5));
        toolBar.add(new BGUAction("delete", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439", (Icon)ClientUtils.getIcon("delete")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TariffVar tariffVar = (TariffVar)TariffVarsPanel.this.tableModel.getSelectedRow();
                if (tariffVar == null) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                    return;
                }
                if (ClientUtils.confirmDelete(tariffVar.getTitle())) {
                    try {
                        TariffVarsPanel.this.tariffService.tariffVarDelete(tariffVar.getId());
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                    TariffVarsPanel.this.loadTariffVars();
                }
            }
        });
        return toolBar;
    }

    public void setData(List<TariffVar> tatiffVars) {
        this.tableModel.setData(tatiffVars);
    }

    public void loadTariffVars() {
        try {
            this.setData(this.tariffService.tariffVars(null, Arrays.asList(this.tariffPlanId)));
            if (this.modules.isEmpty()) {
                this.modules.addAll(((ClientContext)this.getContext()).getPort(ModuleService.class, 0).moduleList());
            }
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    public void setTariffPlanId(int tariffPlanId) {
        this.tariffPlanId = tariffPlanId;
    }

    class VarsTableModel
    extends BGTableModel<TariffVar> {
        public VarsTableModel() {
            super(VarsTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041c\u043e\u0434\u0443\u043b\u044c", 100, 200, 300, "moduleId", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0422\u0438\u043f", 100, 150, 200, "type", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 150, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e", 150, 200, -1, "defaultValue", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(TariffVar tariffVar, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("moduleId".equals(identifier)) {
                return TariffVarsPanel.this.modules.stream().filter(a -> a.getId() == tariffVar.getModuleId()).findAny().orElse(TariffVarsPanel.this.modules.get(0)).getTitle();
            }
            if ("type".equals(identifier)) {
                return tariffVar.getType().getTitle();
            }
            if ("defaultValue".equals(identifier)) {
                if ("list".equals(tariffVar.getType().getType())) {
                    return tariffVar.getDefaultValue().replaceFirst("^(\\d+):(.*)", "$2 [#$1]");
                }
                return tariffVar.getDefaultValue();
            }
            return super.getValue(tariffVar, column);
        }
    }

    private class VarEditor
    extends BGEditorDialog<TariffVar> {
        private BGUComboBox<IdTitle> module;
        private BGUComboBox<TariffVarType> varType;
        private BGUComboBox<IdTitle> varListDefault;
        private JTextField varTitle;
        private JTextField varDefault;
        private List<IdTitle> moduleItems;

        public VarEditor(String title, TariffVar data) {
            super(title, data);
            this.module = new BGUComboBox();
            this.varType = new BGUComboBox();
            this.varListDefault = new BGUComboBox();
            this.varTitle = new JTextField(30);
            this.varDefault = new JTextField(30);
            this.moduleItems = new ArrayList<IdTitle>();
            this.moduleItems.addAll(Arrays.asList(new IdTitle(0, "\u041b\u044e\u0431\u043e\u0439")));
            TariffVarsPanel.this.modules.forEach(a -> this.moduleItems.add(new IdTitle(a.getId(), a.getTitle())));
            this.varDefault.setVisible(false);
            this.varListDefault.setVisible(false);
        }

        @Override
        public void doDialogPanel() {
            CardLayout cardLayout = new CardLayout();
            JPanel varDefaultPanel = new JPanel(cardLayout);
            varDefaultPanel.add((Component)this.varDefault, "text");
            varDefaultPanel.add(this.varListDefault, "list");
            int gridy = 0;
            this.panel.add((Component)new JLabel("\u041c\u043e\u0434\u0443\u043b\u044c:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.panel.add(this.module, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.panel.add((Component)new JLabel("\u0422\u0438\u043f:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.panel.add(this.varType, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.panel.add((Component)new JLabel("\u0418\u043c\u044f:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.varTitle, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.panel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.panel.add((Component)varDefaultPanel, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            boolean edit = ((TariffVar)this.data).getId() < 1;
            this.module.setData(this.moduleItems);
            this.module.setEnabled(edit);
            this.module.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.setVarTypeItems();
                }
            });
            this.module.setSelectedIndex(-1);
            this.module.setSelectedItem(this.moduleItems.stream().filter(a -> a.getId() == ((TariffVar)this.data).getModuleId()).findFirst().orElse(this.moduleItems.get(0)));
            this.varType.setEnabled(edit);
            this.varType.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    String type = ((TariffVarType)this.varType.getSelectedItem()).getType();
                    cardLayout.show(varDefaultPanel, type);
                    if ("list".equals(type)) {
                        this.setVarListItems();
                    }
                }
            });
            if (((TariffVar)this.data).getType() != null) {
                this.varType.setSelectedItem(((TariffVar)this.data).getType());
            }
            this.varTitle.setText(((TariffVar)this.data).getTitle());
            this.varDefault.setText(((TariffVar)this.data).getDefaultValue());
        }

        private void setVarListItems() {
            int moduleId = ((IdTitle)this.module.getSelectedItem()).getId();
            String varTypeCode = ((TariffVarType)this.varType.getSelectedItem()).getCode();
            try {
                this.varListDefault.setData(TariffVarsPanel.this.tariffService.tariffVarListItems(moduleId, varTypeCode));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }

        private void setVarTypeItems() {
            int moduleId = ((IdTitle)this.module.getSelectedItem()).getId();
            ArrayList tariffVarTypes = new ArrayList();
            Arrays.asList(TariffVarType.values()).forEach(a -> {
                String moduleName;
                BGModule bgModule = TariffVarsPanel.this.modules.stream().filter(m -> m.getId() == moduleId).findFirst().orElse(null);
                String string = moduleName = bgModule != null ? bgModule.getName() : null;
                if (a.getModuleName() == null || Arrays.asList(a.getModuleName()).contains(moduleName)) {
                    tariffVarTypes.add(a);
                }
            });
            this.varType.setData(tariffVarTypes);
        }

        @Override
        public boolean doApply() throws Exception {
            block7: {
                String text;
                if (((TariffVarType)this.varType.getSelectedItem()).equals(TariffVarType.COST)) {
                    try {
                        text = this.varDefault.getText();
                        BigDecimal bigDecimal = new BigDecimal(text);
                        if (!bigDecimal.setScale(2, RoundingMode.HALF_UP).toString().equals(text) && !bigDecimal.setScale(0, RoundingMode.HALF_UP).toString().equals(text)) {
                            throw new BGException("");
                        }
                        break block7;
                    }
                    catch (Exception e) {
                        ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u0432\u043e\u0434\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
                        return false;
                    }
                }
                if ("long".equals(((TariffVarType)this.varType.getSelectedItem()).getType()) && !(text = this.varDefault.getText()).matches("^\\d*$")) {
                    ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u0432\u043e\u0434\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e, \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u043e");
                    return false;
                }
            }
            ((TariffVar)this.data).setType((TariffVarType)this.varType.getSelectedItem());
            ((TariffVar)this.data).setModuleId(((IdTitle)this.module.getSelectedItem()).getId());
            ((TariffVar)this.data).setTitle(this.varTitle.getText().trim());
            if ("list".equals(((TariffVarType)this.varType.getSelectedItem()).getType())) {
                IdTitle selectedItem = (IdTitle)this.varListDefault.getSelectedItem();
                ((TariffVar)this.data).setDefaultValue(selectedItem.getId() + ":" + selectedItem.getTitle());
            } else {
                ((TariffVar)this.data).setDefaultValue(this.varDefault.getText().trim());
            }
            return true;
        }

        @Override
        protected BGOptionPane getBGOptionPane() {
            return new BGOptionPane(this.panel, this.title){

                @Override
                protected void doCancel() {
                    VarEditor.this.data = null;
                }
            };
        }
    }
}

