/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class ModuleServiceTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon("services");
    private JPanel propsPanel;
    private BGComboBox<IdTitle> combo = new BGComboBox();
    private JLabel view = new JLabel();
    private Directory dir;
    private String serviceTitle;

    @Override
    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> nodes) {
        super.init(id, mtree, type, tree, config, parent, nodes);
        this.dir = this.getDirManager().getDirectory("services");
        this.initView();
    }

    private void initView() {
        this.view.setIcon(icon);
    }

    @Override
    protected JPanel getEditorPanel() {
        this.propsPanel = new JPanel();
        if (this.dir != null) {
            this.combo = new BGComboBox<IdTitle>(this.dir.getItems());
        }
        this.propsPanel.add(this.combo);
        return this.propsPanel;
    }

    @Override
    public Component getView() {
        this.extractData();
        StringBuffer str = new StringBuffer("\u0423\u0441\u043b\u0443\u0433\u0430: ");
        str.append(this.serviceTitle);
        this.view.setText(str.toString());
        return this.view;
    }

    @Override
    protected void loadData() {
        String data = this.getData();
        this.setDirectoryItemSelection(this.combo, Utils.parseInt(data, 0));
    }

    @Override
    protected void serializeData() {
        IdTitle di = this.combo.getSelectedItem();
        if (di != null) {
            super.setData(String.valueOf(di.getId()));
        }
    }

    private void extractData() {
        this.serviceTitle = Utils.maskNull(this.dir.getValue(Utils.parseInt(this.getData())));
    }

    @Override
    public void serializeToXML(Element el) {
        super.serializeToXML(el);
        el.setAttribute("sid", this.getData());
        this.serializeChildsToXML(el);
    }

    @Override
    public void loadFromXML(Element el) {
        this.setData(el.getAttribute("sid"));
        this.saveData();
        this.loadChildsFromXML(el);
    }
}

