/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.webapi.server;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Map;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class WebApiBase {
    protected int moduleId = 0;
    protected Setup setup = null;
    protected HttpServletRequest request = null;
    protected Map<String, Object> dataMap = null;

    public WebApiBase(HttpServletRequest request) {
        this.request = request;
        this.setup = Setup.getSetup();
        this.dataMap = (Map)request.getAttribute("dataMap");
    }

    public void setError(int code, String message) {
        this.dataMap.put("status", "Error");
        this.dataMap.put("errorCode", String.valueOf(code));
        this.dataMap.put("errorMessage", message != null ? message : "");
    }

    protected Page getPage() {
        Page page = new Page();
        page.setPageIndex(Utils.parseInt(this.request.getParameter("pageIndex"), 1));
        page.setPageSize(Utils.parseInt(this.request.getParameter("pageSize"), 25));
        this.dataMap.put("page", page);
        return page;
    }

    protected Period getPeriod() {
        GregorianCalendar nowDate = new GregorianCalendar();
        int mm = Utils.parseInt(this.request.getParameter("month"), nowDate.get(2) + 1);
        int yy = Utils.parseInt(this.request.getParameter("year"), nowDate.get(1));
        Period period = new Period(yy, mm - 1, 1, 32);
        this.dataMap.put("period", period);
        this.dataMap.put("month", period.getMonthFrom());
        this.dataMap.put("year", period.getYearFrom());
        return period;
    }

    protected String getStatus(AbstractTransactionStatus statusDefault) {
        String status = this.request.getParameter("status");
        if (status == null) {
            status = statusDefault.getCode();
        }
        this.dataMap.put("status", status);
        try {
            this.dataMap.put("statusList", Arrays.asList((AbstractTransactionStatus[])statusDefault.getClass().getMethod("values", new Class[0]).invoke((Object)statusDefault, new Object[0])));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return status;
    }
}

