/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.RowSorter;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.PeriodTableCellRenderer;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.GroupParent;
import ru.bitel.common.client.table.AbstractBGTableModel;
import ru.bitel.common.client.table.BGUTableRowSorter;
import ru.bitel.common.client.table.BasicBGTableModel;
import ru.bitel.common.client.table.Column;
import ru.bitel.common.localize.Localizer;
import ru.bitel.common.model.Period;

public class AbstractBGUTable<C>
extends JTable {
    protected JButton tableHeaderButton;
    private boolean autoRowHeight = false;
    private C context;

    public AbstractBGUTable(TableModel tableModel) {
        super(tableModel);
        this.initRowSorter();
        if (this.getRowSorter() != null) {
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int code;
                    if ((e.getModifiersEx() & 0x200) > 0 && (code = e.getKeyCode()) >= 49 && code <= 57 && (code -= 49) < AbstractBGUTable.this.getColumnCount()) {
                        AbstractBGUTable.this.getRowSorter().toggleSortOrder(code);
                    }
                }
            });
        }
        this.setAutoResizeMode(3);
    }

    protected void initRowSorter() {
        this.setRowSorter(null);
        TableModel tableModel = this.getModel();
        if (tableModel instanceof AbstractBGTableModel) {
            AbstractBGTableModel model = (AbstractBGTableModel)tableModel;
            this.setName(model.getName());
            int size = model.getColumnCount();
            for (int i = 0; i < size; ++i) {
                if (!model.isColumnSortable(i)) continue;
                this.setRowSorter((RowSorter<? extends TableModel>)new BGUTableRowSorter<TableModel>(tableModel){

                    @Override
                    public boolean isSortable(int column) {
                        TableModel model = (TableModel)this.getModel();
                        if (model instanceof AbstractBGTableModel) {
                            return ((AbstractBGTableModel)model).isColumnSortable(column);
                        }
                        return super.isSortable(column);
                    }
                });
                break;
            }
        }
    }

    public void setAutoRowHeight(boolean auto) {
        this.autoRowHeight = auto;
        if (this.autoRowHeight) {
            this.defaultRenderersByColumnClass.put(String.class, new MultiStringRenderer());
        } else {
            this.defaultRenderersByColumnClass.remove(String.class);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        TableModel tableModel;
        super.tableChanged(e);
        if (this.autoRowHeight) {
            this.packRows(e.getFirstRow(), Math.min(this.getRowCount(), e.getLastRow()), 0);
        }
        if ((tableModel = this.getModel()) instanceof AbstractBGTableModel) {
            AbstractBGTableModel tableModel2 = (AbstractBGTableModel)tableModel;
            tableModel2.hideColumns();
        }
    }

    private int getPreferredRowHeight(int rowIndex, int margin) {
        int height = this.getRowHeight();
        for (int c = 0; c < this.getColumnCount(); ++c) {
            TableCellRenderer renderer = this.getCellRenderer(rowIndex, c);
            Component comp = this.prepareRenderer(renderer, rowIndex, c);
            int h = comp.getPreferredSize().height + 2 * margin;
            height = Math.max(height, h);
        }
        return height;
    }

    private void packRows(int start, int end, int margin) {
        for (int r = 0; r < this.getRowCount(); ++r) {
            int h = this.getPreferredRowHeight(r, margin);
            if (this.getRowHeight(r) == h) continue;
            this.setRowHeight(r, h);
        }
    }

    @Override
    public void addColumn(TableColumn aColumn) {
        if (this.getModel() instanceof AbstractBGTableModel) {
            AbstractBGTableModel model = (AbstractBGTableModel)this.getModel();
            this.setTableColumnWidths(model, aColumn);
        }
        if (aColumn.getHeaderValue() == null) {
            int modelColumn = aColumn.getModelIndex();
            String columnName = this.getModel().getColumnName(modelColumn);
            aColumn.setHeaderValue(columnName);
        }
        this.getColumnModel().addColumn(aColumn);
    }

    private void setTableColumnWidths(AbstractBGTableModel model, TableColumn aColumn) {
        int modelColumn = aColumn.getModelIndex();
        int width = model.getColumnMinWidth(modelColumn);
        if (width >= 0) {
            aColumn.setMinWidth(width);
        } else {
            aColumn.setMinWidth(15);
        }
        width = model.getColumnMaxWidth(modelColumn);
        if (width >= 0) {
            aColumn.setMaxWidth(width);
        } else {
            aColumn.setMaxWidth(Integer.MAX_VALUE);
        }
        width = model.getColumnPrefferedWidth(modelColumn);
        if (width >= 0) {
            aColumn.setPreferredWidth(width);
        } else {
            aColumn.setPreferredWidth(75);
        }
    }

    public void resetColumnsWidths() {
        if (this.getModel() instanceof AbstractBGTableModel) {
            AbstractBGTableModel model = (AbstractBGTableModel)this.getModel();
            int size = this.getColumnCount();
            for (int i = 0; i < size; ++i) {
                this.setTableColumnWidths(model, this.getColumnModel().getColumn(i));
            }
        }
        this.resizeAndRepaint();
        if (this.tableHeader != null) {
            this.tableHeader.resizeAndRepaint();
        }
    }

    @Override
    protected void createDefaultEditors() {
        super.createDefaultEditors();
        this.defaultEditorsByColumnClass.put(Integer.TYPE, new UIDefaults.ProxyLazyValue("javax.swing.JTable$NumberEditor"));
    }

    @Override
    protected void createDefaultRenderers() {
        super.createDefaultRenderers();
        this.defaultRenderersByColumnClass.put(Integer.TYPE, new UIDefaults.ProxyLazyValue("javax.swing.table.DefaultTableCellRenderer$UIResource"));
        this.defaultRenderersByColumnClass.put(Integer.class, new UIDefaults.ProxyLazyValue("javax.swing.table.DefaultTableCellRenderer$UIResource"));
        this.defaultRenderersByColumnClass.put(Date.class, new DatetimeTableCellRenderer("dd.MM.yyyy"));
        this.defaultRenderersByColumnClass.put(Column.Date.class, new DatetimeTableCellRenderer("dd.MM.yyyy"));
        this.defaultRenderersByColumnClass.put(Column.DateTime.class, new DatetimeTableCellRenderer("dd.MM.yyyy HH:mm:ss"));
        this.defaultRenderersByColumnClass.put(Column.DateHour.class, new DatetimeTableCellRenderer("dd.MM.yyyy HH"));
        this.defaultRenderersByColumnClass.put(BigDecimal.class, new BigDecimalRenderer());
        this.defaultRenderersByColumnClass.put(Column.Radio.class, new RadioTableCellRenderer());
        this.defaultRenderersByColumnClass.put(Period.class, new PeriodTableCellRenderer());
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer tableCellRenderer = null;
        TableModel tableModel = this.getModel();
        if (tableModel instanceof BasicBGTableModel) {
            TableColumn tableColumn = this.getColumnModel().getColumn(column);
            tableCellRenderer = ((BasicBGTableModel)tableModel).getTableCellRenderer(tableColumn.getModelIndex());
        }
        return tableCellRenderer != null ? tableCellRenderer : super.getCellRenderer(row, column);
    }

    @Override
    public TableCellRenderer getDefaultRenderer(Class<?> columnClass) {
        return super.getDefaultRenderer(columnClass);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.initHeaderMenu();
        this.initPopupMenu();
        Component parent = this.getGroupParent();
        if (parent instanceof JComponent) {
            BGSwingUtilites.buildPopupMenu(this, (Container)((JComponent)parent), this.getName() + ".");
        }
    }

    protected void initHeaderMenu() {
        if (this.tableHeaderButton == null) {
            return;
        }
        if (BGSwingUtilites.buildPopupMenu(this.tableHeaderButton, this, "table.", false).size() == 0) {
            this.tableHeaderButton.setVisible(false);
        } else {
            this.tableHeaderButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractBGUTable.this.tableHeaderButton.getComponentPopupMenu().show(AbstractBGUTable.this.tableHeaderButton, 0, AbstractBGUTable.this.tableHeaderButton.getHeight());
                }
            });
            JPopupMenu popupMenu = this.tableHeaderButton.getComponentPopupMenu();
            for (Component c : popupMenu.getComponents()) {
                if (!(c instanceof JComponent)) continue;
                ((JComponent)c).putClientProperty("table", this);
            }
        }
    }

    protected void initPopupMenu() {
        for (BGPlugInElement extension : BGPluginManagerClient.getManager().getExtensions("bitel.billing.module.common.table.AbstractBGUTable", true)) {
            try {
                ClientContext cc = ClientContext.get();
                String moduleTable = cc != null ? cc.getModule() : null;
                String nameTableModel = null;
                try {
                    nameTableModel = ((AbstractBGTableModel)this.getModel()).getName();
                }
                catch (Exception e) {
                    break;
                }
                Element extensionElement = extension.getElement();
                String module = XMLUtils.getAttribute(extensionElement, "module", null);
                String tablemodel = XMLUtils.getAttribute(extensionElement, "tablemodel", null);
                if (module == null || tablemodel == null || !module.equals(moduleTable) || !tablemodel.equals(nameTableModel)) continue;
                BGPluginClient plugin = (BGPluginClient)extension.getPlugin();
                NodeList popupitemList = extensionElement.getElementsByTagName("popupitem");
                for (int index1 = 0; index1 < popupitemList.getLength(); ++index1) {
                    Element popupitemElement = (Element)popupitemList.item(index1);
                    String actionCommand = XMLUtils.getAttribute(popupitemElement, "ActionCommand", null);
                    String actionListener = XMLUtils.getAttribute(popupitemElement, "ActionListener", null);
                    String title = XMLUtils.getAttribute(popupitemElement, "title", null);
                    if (actionCommand == null || actionListener == null || title == null) continue;
                    JMenuItem menuItemPlugin = new JMenuItem(plugin.getResourceString(title));
                    menuItemPlugin.setActionCommand(actionCommand);
                    menuItemPlugin.addActionListener((ActionListener)Class.forName(actionListener).newInstance());
                    this.addPopupMenuIfNotExists(menuItemPlugin);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected Component getGroupParent() {
        Container parent = this;
        do {
            if (!(parent instanceof GroupParent)) continue;
            return parent;
        } while ((parent = parent.getParent()) != null);
        return this;
    }

    @Override
    protected void configureEnclosingScrollPane() {
        Container gp;
        super.configureEnclosingScrollPane();
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            scrollPane.setVerticalScrollBarPolicy(22);
            this.tableHeaderButton = new JButton("...");
            this.tableHeaderButton.setBorder(null);
            this.tableHeaderButton.setFocusable(false);
            this.tableHeaderButton.putClientProperty("table", this);
            scrollPane.add((Component)this.tableHeaderButton, "UPPER_RIGHT_CORNER");
        }
    }

    @Override
    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
        this.initRowSorter();
        if (dataModel instanceof BasicBGTableModel) {
            ((BasicBGTableModel)dataModel).table = this;
        }
    }

    public C getContext() {
        if (this.context != null) {
            return this.context;
        }
        Container parent = this;
        while ((parent = parent.getParent()) != null) {
            if (parent instanceof AbstractBGUPanel) {
                this.context = ((AbstractBGUPanel)parent).getContext();
                return this.context;
            }
            this.context = this.innerGetContext(parent);
            if (this.context == null) continue;
            return this.context;
        }
        this.context = this.innerGetContext(null);
        return this.context;
    }

    protected C innerGetContext(Container parent) {
        return null;
    }

    public JPopupMenu getPopupMenu() {
        JPopupMenu popupMenu = this.getComponentPopupMenu();
        if (popupMenu == null) {
            popupMenu = new JPopupMenu();
            this.setComponentPopupMenu(popupMenu);
        }
        return popupMenu;
    }

    private void addPopupMenuIfNotExists(JMenuItem item) {
        JPopupMenu popupMenu = this.getPopupMenu();
        for (int i = 0; i < popupMenu.getComponentCount(); ++i) {
            if (!(popupMenu.getComponent(i) instanceof JMenuItem) || !((JMenuItem)popupMenu.getComponent(i)).getActionCommand().equals(item.getActionCommand())) continue;
            return;
        }
        popupMenu.add(item);
    }

    static class MultiStringRenderer
    extends DefaultTableCellRenderer.UIResource {
        MultiStringRenderer() {
        }

        @Override
        public void setValue(Object value) {
            if (value != null) {
                this.setText("<html><span>" + Utils.escapeHTML(value.toString()).replaceAll("\\n", "</span><br/><span>") + "</span></html>");
            } else {
                this.setText("");
            }
        }
    }

    static class BigDecimalRenderer
    extends DefaultTableCellRenderer.UIResource {
        final DecimalFormat formatter = new DecimalFormat("0.00###", Localizer.getDecimalFormatSymbols());

        BigDecimalRenderer() {
        }

        @Override
        public void setValue(Object value) {
            if (value != null) {
                value = ((BigDecimal)value).setScale(5, RoundingMode.HALF_EVEN);
                this.setText(this.formatter.format(value));
            } else {
                this.setText("");
            }
        }
    }

    class RadioTableCellRenderer
    extends JRadioButton
    implements TableCellRenderer {
        protected Border noFocusBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        private Color unselectedForeground;
        private Color unselectedBackground;

        public RadioTableCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
            this.setBorder(this.noFocusBorder);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
            }
            this.setFont(table.getFont());
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (table.isCellEditable(row, column)) {
                    super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    super.setBackground(UIManager.getColor("Table.focusCellBackground"));
                }
            } else {
                this.setBorder(this.noFocusBorder);
            }
            if (value instanceof Boolean) {
                this.setSelected((Boolean)value);
            }
            return this;
        }

        @Override
        public void setForeground(Color c) {
            super.setForeground(c);
            this.unselectedForeground = c;
        }

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            this.unselectedBackground = c;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setForeground(null);
            this.setBackground(null);
        }

        @Override
        public boolean isOpaque() {
            Color back = this.getBackground();
            Container p = this.getParent();
            if (p != null) {
                p = p.getParent();
            }
            boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
            return !colorMatch && super.isOpaque();
        }
    }
}

