/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.client.table.BGTableModelColumn;
import ru.bitel.common.client.table.BasicBGTableModel;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;

public abstract class BGTableModel<K>
extends BasicBGTableModel<K> {
    List<K> rows = new ArrayList<K>();
    private boolean keepSelection;

    public BGTableModel(String name) {
        this(name, null, true);
    }

    public BGTableModel(String name, Class<K> clazz) {
        this(name, clazz, true);
    }

    public BGTableModel(String name, Class<K> clazz, boolean keepSelection) {
        super(name, clazz);
        this.keepSelection = keepSelection;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        try {
            return this.getValueAt(this.rows.get(rowIndex), columnIndex);
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog(ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        ((BGTableModelColumn)this.columns.get(columnIndex)).setValue(this.rows.get(rowIndex), value);
    }

    public void setData(List<K> data) {
        this.setData(data, this.keepSelection);
    }

    public void setData(List<K> data, boolean keepSelection) {
        if (keepSelection) {
            List<K> selected = this.getSelectedRows();
            if (this.clazz != null && Id.class.isAssignableFrom(this.clazz)) {
                Set<Integer> selectedIdSet = Id.newIdSet(selected);
                selected.clear();
                selected = null;
                this.setData0(data);
                data = null;
                this.setSelectedRows(selectedIdSet);
            } else {
                this.setData0(data);
                data = null;
                this.setSelectedRows(selected);
            }
        } else {
            this.setData0(data);
        }
    }

    private void setData0(List<K> data) {
        this.rows.clear();
        if (data != null) {
            this.rows = new ArrayList<K>(data);
        }
        this.fireTableDataChanged();
    }

    @Override
    public List<K> getSelectedRows() {
        ArrayList<K> result;
        block4: {
            result = new ArrayList<K>();
            if (this.table == null) break block4;
            int[] rows = this.table.getSelectedRows();
            if (this.table.getRowSorter() != null) {
                int size = rows.length;
                for (int i = 0; i < size; ++i) {
                    result.add(this.rows.get(this.table.getRowSorter().convertRowIndexToModel(rows[i])));
                }
            } else {
                int size = rows.length;
                for (int i = 0; i < size; ++i) {
                    result.add(this.rows.get(rows[i]));
                }
            }
        }
        return result;
    }

    @Override
    public K getSelectedRow() {
        int row = this.table.getSelectedRow();
        if (row >= 0 && row < this.rows.size()) {
            if (this.table.getRowSorter() != null) {
                return this.rows.get(this.table.getRowSorter().convertRowIndexToModel(row));
            }
            return this.rows.get(row);
        }
        return null;
    }

    public int getSelectedRowIndex() {
        return this.table.getSelectedRow();
    }

    public String getValueFromSelectedRow(String columnName) {
        String result = null;
        int row = this.table.getSelectedRow();
        if (row >= 0 && columnName != null) {
            Object object = null;
            object = this.table.getRowSorter() != null ? this.rows.get(this.table.getRowSorter().convertRowIndexToModel(row)) : this.rows.get(row);
            if (object instanceof String[][]) {
                for (String[] values : (String[][])object) {
                    if (values == null || values.length != 2 || !columnName.equals(values[0])) continue;
                    result = values[1];
                    break;
                }
            } else if (object instanceof Element) {
                result = ((Element)object).getAttribute(columnName);
            } else if (object instanceof Id) {
                int id = ((Id)object).getId();
                result = id > 0 ? String.valueOf(id) : null;
            }
        }
        return result;
    }

    public void setSelectedRows(Set<Integer> selected) {
        if (!Idable.class.isAssignableFrom(this.clazz)) {
            throw new IllegalStateException();
        }
        if (this.table != null) {
            ListSelectionModel selectionModel = this.table.getSelectionModel();
            selectionModel.clearSelection();
            selectionModel.setValueIsAdjusting(true);
            int size = this.rows.size();
            for (int i = 0; i < size; ++i) {
                if (!selected.contains(((Idable)this.rows.get(i)).getId())) continue;
                if (this.table.getRowSorter() != null) {
                    int row = this.table.getRowSorter().convertRowIndexToView(i);
                    selectionModel.addSelectionInterval(row, row);
                    continue;
                }
                selectionModel.addSelectionInterval(i, i);
            }
            selectionModel.setValueIsAdjusting(false);
        }
    }

    public void setSelectedRows(List<K> selected) {
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.clearSelection();
        selectionModel.setValueIsAdjusting(true);
        HashSet<K> set = new HashSet<K>(selected);
        int size = this.rows.size();
        for (int i = 0; i < size; ++i) {
            if (!set.contains(this.rows.get(i))) continue;
            if (this.table.getRowSorter() != null) {
                int row = this.table.getRowSorter().convertRowIndexToView(i);
                selectionModel.addSelectionInterval(row, row);
                continue;
            }
            selectionModel.addSelectionInterval(i, i);
        }
        selectionModel.setValueIsAdjusting(false);
    }

    public void setSelectedRow(Integer id) {
        if (!Idable.class.isAssignableFrom(this.clazz)) {
            throw new IllegalStateException();
        }
        this.setSelectedRows(Collections.singleton(id));
    }

    public void setSelectedRow(K k) {
        this.setSelectedRows(Collections.singletonList(k));
    }

    public List<K> getRows() {
        return this.rows;
    }

    public void upSelectedRow() {
        int row = this.table.getSelectedRow();
        if (row < 1) {
            return;
        }
        int prevRow = row - 1;
        K prevRowValue = this.rows.get(prevRow);
        K rowValue = this.rows.get(row);
        this.rows.set(prevRow, rowValue);
        this.rows.set(row, prevRowValue);
        this.fireTableRowsUpdated(prevRow, row);
        this.setSelectedRow(rowValue);
    }

    public void downSelectedRow() {
        int row = this.table.getSelectedRow();
        if (row > this.table.getRowCount() - 2) {
            return;
        }
        int nextRow = row + 1;
        K nextRowValue = this.rows.get(nextRow);
        K rowValue = this.rows.get(row);
        this.rows.set(row, nextRowValue);
        this.rows.set(nextRow, rowValue);
        this.fireTableRowsUpdated(row, nextRow);
        this.setSelectedRow(rowValue);
    }

    public void deleteSelectedRows() {
        String message;
        int[] row = this.table.getSelectedRows();
        if (row.length == 0) {
            return;
        }
        String string = message = row.length > 1 ? "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0441\u0442\u0440\u043e\u043a\u0438?" : "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u0441\u0442\u0440\u043e\u043a\u0443?";
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), message, "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            for (int i = row.length; i > 0; --i) {
                this.rows.remove(this.table.convertRowIndexToModel(row[i - 1]));
            }
            this.fireTableDataChanged();
        }
    }

    public void addRow(K item) {
        this.rows.add(item);
        this.fireTableDataChanged();
    }

    public void insertRow(int index, K item) {
        this.rows.add(index, item);
        this.fireTableDataChanged();
    }

    public void deleteRow(K item) {
        this.rows.remove(item);
        this.fireTableDataChanged();
    }

    public void deleteRows() {
        this.rows.clear();
        this.fireTableDataChanged();
    }

    public void setRow(int index, K item) {
        this.rows.set(index, item);
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean edit = false;
        if (columnIndex < this.columns.size()) {
            edit = ((BGTableModelColumn)this.columns.get((int)columnIndex)).editable;
        }
        return edit;
    }
}

