/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.inet;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.math.BigInteger;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;

public class IpRange {
    protected byte[] addressFrom;
    protected byte[] addressTo;

    public IpRange() {
    }

    public IpRange(byte[] addressFrom, byte[] addressTo) {
        this.addressFrom = addressFrom;
        this.addressTo = addressTo;
    }

    @XmlAttribute(name="from")
    public byte[] getAddressFrom() {
        return this.addressFrom;
    }

    public void setAddressFrom(byte[] ipFrom) {
        this.addressFrom = ipFrom;
    }

    @XmlAttribute(name="to")
    public byte[] getAddressTo() {
        return this.addressTo;
    }

    public void setAddressTo(byte[] ipTo) {
        this.addressTo = ipTo;
    }

    public String toString() {
        return IpRange.toString(this.addressFrom, this.addressTo);
    }

    public static String toString(IpAddress addressFrom, IpAddress addressTo) {
        if (addressTo == null || addressTo.address == null) {
            return IpAddress.toString(addressFrom.address);
        }
        StringBuilder sb = new StringBuilder(addressFrom != null ? addressFrom.address.length * 6 : 32);
        return sb.append(IpAddress.toString(addressFrom.address)).append('-').append(IpAddress.toString(addressTo.address)).toString();
    }

    public static String toString(byte[] addressFrom, byte[] addressTo) {
        if (addressTo == null) {
            return IpAddress.toString(addressFrom);
        }
        StringBuilder sb = new StringBuilder(addressFrom != null ? addressFrom.length * 6 : 32);
        return sb.append(IpAddress.toString(addressFrom)).append('-').append(IpAddress.toString(addressTo)).toString();
    }

    public static IpRange newInstance(byte[] subnet, int mask) {
        assert (subnet != null);
        BigInteger i = new BigInteger(subnet);
        byte[] addressTo = switch (subnet.length) {
            case 4 -> IpAddress.convertBigIntToIp4Address(i.or(IpAddress.mask4.mod(IpAddress.two.pow(32 - mask))));
            case 16 -> i.or(IpAddress.mask16.mod(IpAddress.two.pow(128 - mask))).toByteArray();
            default -> throw new IllegalArgumentException("Subnet size=" + subnet.length);
        };
        assert (addressTo.length == subnet.length);
        return new IpRange(subnet, addressTo);
    }

    public static IpRange newInstance(IpNet net) {
        return IpRange.newInstance(net.subnet, net.mask);
    }

    public static IpRange newInstance(byte[] subnet, byte[] mask) {
        assert (subnet != null && mask != null && subnet.length == mask.length);
        BigInteger i = new BigInteger(subnet);
        BigInteger i2 = new BigInteger(mask);
        byte[] addressTo = i.or(i2.not()).toByteArray();
        return new IpRange(subnet, addressTo);
    }

    public static boolean intersects(byte[] addressFrom1, byte[] addressTo1, byte[] addressFrom2, byte[] addressTo2) {
        return IpAddress.compare(addressFrom1, addressTo2) <= 0 && IpAddress.compare(addressTo1, addressFrom2) >= 0;
    }

    public static boolean inRange(byte[] addressFrom1, byte[] addressTo1, byte[] addressFrom2, byte[] addressTo2) {
        return IpAddress.compare(addressFrom2, addressFrom1) <= 0 && IpAddress.compare(addressTo2, addressTo1) >= 0;
    }
}

