/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.text.NumberFormat;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class AverageCounter {
    private final TimeUnit timeUnit;
    private final int period;
    private final AtomicLongArray amount;
    private final long delimeter;
    private final AtomicLong currentPeriod = new AtomicLong();

    public AverageCounter(long period, TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        this.period = (int)period + 2 + 10;
        this.amount = new AtomicLongArray(this.period);
        this.delimeter = TimeUnit.MILLISECONDS.convert(1L, this.timeUnit);
    }

    public void add(long nowMillis, long value) {
        long currentPeriod = nowMillis / this.delimeter;
        this.update(currentPeriod);
        int p = (int)(currentPeriod % (long)this.period);
        this.amount.getAndAdd(p, value);
    }

    public long getSum(long nowMillis) {
        return this.getSum(nowMillis, this.period - 2 - 10);
    }

    public long getSum(long nowMillis, int period) {
        long currentPeriod = nowMillis / this.delimeter;
        this.update(currentPeriod);
        int p = (int)((currentPeriod - 1L) % (long)this.period);
        return this.sum(p, period);
    }

    public long getSum(long nowMillis, int period, TimeUnit timeUnit) {
        long currentPeriod = nowMillis / this.delimeter;
        this.update(currentPeriod);
        int p = (int)((currentPeriod - 1L) % (long)this.period);
        int period2 = (int)this.timeUnit.convert(period, timeUnit);
        return this.sum(p, period2);
    }

    public double getAverage(long nowMillis) {
        return (double)this.getSum(nowMillis) / (double)(this.period - 2 - 10);
    }

    public double getAverage(long nowMillis, MathContext mc) {
        return BigDecimal.valueOf(this.getSum(nowMillis)).divide(BigDecimal.valueOf(this.period - 2 - 10), mc).doubleValue();
    }

    public double getAverage(long nowMillis, int period) {
        return (double)this.getSum(nowMillis, period) / (double)period;
    }

    public double getAverage(long nowMillis, int period, MathContext mc) {
        return BigDecimal.valueOf(this.getSum(nowMillis, period)).divide(BigDecimal.valueOf(period), mc).doubleValue();
    }

    public double getAverage(long nowMillis, int period, TimeUnit timeUnit) {
        int period2 = (int)this.timeUnit.convert(period, timeUnit);
        return (double)this.getSum(nowMillis, period2) / (double)period;
    }

    public double getAverage(long nowMillis, int period, TimeUnit timeUnit, MathContext mc) {
        int period2 = (int)this.timeUnit.convert(period, timeUnit);
        return BigDecimal.valueOf(this.getSum(nowMillis, period2)).divide(BigDecimal.valueOf(period), mc).doubleValue();
    }

    public long getPrevious(long nowMillis) {
        long currentPeriod = nowMillis / this.delimeter;
        return this.amount.get((int)((currentPeriod - 1L) % (long)this.period));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(long currentPeriod) {
        long lastPeriod = this.currentPeriod.get();
        if (lastPeriod >= currentPeriod) {
            return;
        }
        long delta = currentPeriod - lastPeriod;
        if (this.currentPeriod.compareAndSet(lastPeriod, currentPeriod)) {
            AverageCounter averageCounter = this;
            synchronized (averageCounter) {
                if (delta >= (long)this.period) {
                    if ((delta -= (long)this.period) >= (long)this.period) {
                        this.clear(0, this.period);
                    } else {
                        this.clear((int)this.currentPeriod.get() % this.period, (int)delta);
                    }
                } else {
                    int i = (int)((currentPeriod + 1L) % (long)this.period);
                    this.amount.set(i, 0L);
                }
            }
        }
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    private void clear(int pos, int length) {
        int i;
        for (i = pos; i >= 0 && length-- > 0; --i) {
            this.amount.set(i, 0L);
        }
        for (i = this.period - 1; length-- > 0 && i > pos; --i) {
            this.amount.set(i, 0L);
        }
    }

    private synchronized long sum(int pos, int length) {
        int i;
        long result = 0L;
        for (i = pos; i >= 0 && length-- > 0; --i) {
            result += this.amount.get(i);
        }
        for (i = this.period - 1; length-- > 0 && i > pos; --i) {
            result += this.amount.get(i);
        }
        return result;
    }

    public long get(long nowMillis) {
        return this.getSum(nowMillis);
    }

    public static void main(String[] args) {
        AverageCounter c = new AverageCounter(60L, TimeUnit.SECONDS);
        Runnable r = () -> {
            for (int i = 0; i < 50000000; ++i) {
                c.add(System.currentTimeMillis(), 1L);
            }
        };
        Runnable r2 = () -> {
            for (int i = 0; i < 5000000; ++i) {
                System.out.println(NumberFormat.getInstance().format(c.getSum(System.currentTimeMillis())));
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < 20; ++i) {
            new Thread(r).start();
        }
        new Thread(r2).start();
    }
}

