/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CopyOnWriteListMap<K, V> {
    private final ConcurrentMap<K, Holder<V>> map;

    public CopyOnWriteListMap(int initialCapacity, int initialListCapacity) {
        this.map = new ConcurrentHashMap<K, Holder<V>>(initialCapacity);
    }

    public List<V> get(K key) {
        Holder holder = (Holder)this.map.get(key);
        return holder != null ? holder.unmodifiable : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(K key, V value) {
        while (true) {
            Holder oldHolder;
            if ((oldHolder = (Holder)this.map.get(key)) != null) {
                Holder holder = new Holder(new ArrayList(oldHolder.value.size() + 1));
                holder.value.addAll(oldHolder.value);
                holder.value.add(value);
                if (!this.map.replace(key, oldHolder, holder)) continue;
                return;
            }
            Holder<V> holder = new Holder<V>(Collections.singletonList(value), true);
            if (this.map.putIfAbsent(key, holder) == null) return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addIfAbsent(K key, V value) {
        while (true) {
            Holder oldHolder;
            if ((oldHolder = (Holder)this.map.get(key)) != null) {
                List oldList = oldHolder.value;
                int size = oldList.size();
                for (int i = 0; i < size; ++i) {
                    if (!value.equals(oldList.get(i))) continue;
                    return false;
                }
                Holder newHolder = new Holder(new ArrayList(oldHolder.value.size() + 1));
                newHolder.value.addAll(oldHolder.value);
                newHolder.value.add(value);
                if (!this.map.replace(key, oldHolder, newHolder)) continue;
                return true;
            }
            Holder<V> newHolder = new Holder<V>(Collections.singletonList(value), true);
            if (this.map.putIfAbsent(key, newHolder) == null) return true;
        }
    }

    public boolean remove(K key, V value) {
        block2: {
            Holder oldHolder;
            Holder newHolder;
            do {
                if ((oldHolder = (Holder)this.map.get(key)) == null) {
                    return false;
                }
                newHolder = new Holder(new ArrayList(oldHolder.value));
                if (!newHolder.value.remove(value)) break block2;
            } while (!(newHolder.value.size() == 0 ? this.map.remove(key, oldHolder) : this.map.replace(key, oldHolder, newHolder)));
            return true;
        }
        return false;
    }

    public List<V> remove(K key) {
        Holder holder = (Holder)this.map.remove(key);
        return holder != null ? holder.unmodifiable : null;
    }

    public void clear() {
        this.map.clear();
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return new AbstractSet<Map.Entry<K, List<V>>>(){
            final Set<Map.Entry<K, Holder<V>>> set;
            {
                this.set = CopyOnWriteListMap.this.map.entrySet();
            }

            @Override
            public Iterator<Map.Entry<K, List<V>>> iterator() {
                final Iterator iterator = this.set.iterator();
                return new Iterator<Map.Entry<K, List<V>>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, List<V>> next() {
                        final Map.Entry entry = (Map.Entry)iterator.next();
                        return new Map.Entry<K, List<V>>(){

                            @Override
                            public K getKey() {
                                return entry.getKey();
                            }

                            @Override
                            public List<V> getValue() {
                                return ((Holder)entry.getValue()).unmodifiable;
                            }

                            @Override
                            public List<V> setValue(List<V> value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return this.set.size();
            }
        };
    }

    public int size() {
        return this.map.size();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    static final class Holder<V> {
        final List<V> unmodifiable;
        final List<V> value;

        public Holder(List<V> value, boolean u) {
            this.value = value;
            this.unmodifiable = value;
        }

        public Holder(List<V> value) {
            this.value = value;
            this.unmodifiable = Collections.unmodifiableList(value);
        }
    }
}

