/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.worker;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.DefaultContext;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.concurrent.ConcurrentUtils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerTask;

public abstract class Conveyor<T, S extends ConveyorContext<T>, C extends ThreadContext>
implements ThreadContextFactory<S> {
    private static final Logger logger = LogManager.getLogger();
    static final int RUNNING = 0;
    static final int SHUTDOWN = 1;
    private final Sync sync = new Sync();
    protected volatile int runState;
    protected final int count;
    protected final int batchSize;
    protected final BlockingQueue<List<T>>[] queues;
    protected final Queue<List<T>>[] finishQueues;
    private final FutureTask<Boolean>[] tasks;
    private final Thread[] threads;
    private final ThreadContextFactory<C> factory;

    public Conveyor(int count, int queueSize, int batchSize, ThreadContextFactory<C> factory) {
        this.count = count;
        this.batchSize = batchSize;
        this.factory = factory;
        BlockingQueue[] queues = new BlockingQueue[count];
        Queue[] finishQueues = new Queue[count];
        FutureTask[] tasks = new FutureTask[count];
        Thread[] threads = new Thread[count];
        for (int i = 0; i < count; ++i) {
            ArrayBlockingQueue queue = new ArrayBlockingQueue(queueSize);
            ConcurrentLinkedQueue finishQueue = new ConcurrentLinkedQueue();
            FutureTask<Boolean> task = new FutureTask<Boolean>(new ConveyorWorker(factory, queue, finishQueue), Boolean.TRUE);
            queues[i] = queue;
            finishQueues[i] = finishQueue;
            tasks[i] = task;
            threads[i] = new Thread(task);
            threads[i].start();
        }
        this.queues = queues;
        this.finishQueues = finishQueues;
        this.tasks = tasks;
        this.threads = threads;
        this.runState = 0;
    }

    void processByIndex(int index, List<T> item) throws InterruptedException {
        if (this.runState != 0) {
            throw new IllegalStateException();
        }
        this.queues[index].put(item);
    }

    void processLast(int index, List<T> item) {
        if (this.runState != 0) {
            throw new IllegalStateException();
        }
        this.finishQueues[index].add(item);
    }

    protected abstract void process(List<T> var1, C var2) throws BGException;

    public void shutdown() throws InterruptedException {
        this.runState = 1;
        for (Thread thread : this.threads) {
            thread.interrupt();
        }
        for (Runnable runnable : this.tasks) {
            if (((FutureTask)runnable).isDone()) continue;
            try {
                ((FutureTask)runnable).get();
            }
            catch (CancellationException cancellationException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        if (this.factory instanceof Conveyor && this.factory != this) {
            ((Conveyor)this.factory).shutdown();
        }
    }

    public static <T, C> void process(String name, Conveyor<T, ? extends ConveyorContext<T>, ? extends ThreadContext> conveyor, List<? extends Callable<C>> tasks) throws InterruptedException {
        ExecutorService executorService = WorkerTask.newFixedThreadPool(name, null, conveyor, tasks.size());
        List futures = executorService.invokeAll(tasks);
        ConcurrentUtils.awaitFutures(futures);
        executorService.shutdown();
        executorService.awaitTermination(1L, TimeUnit.DAYS);
        conveyor.sync.acquire();
        conveyor.shutdown();
    }

    private class Sync
    extends Semaphore {
        public Sync() {
            super(1);
        }

        public void reduce() {
            super.reducePermits(1);
        }
    }

    private class ConveyorWorker
    implements Runnable {
        private final ThreadContextFactory<C> factory;
        private final BlockingQueue<List<T>> workQueue;
        private final Queue<List<T>> finishQueue;
        private C context;

        ConveyorWorker(ThreadContextFactory<C> factory, BlockingQueue<List<T>> workQueue, Queue<List<T>> finishQueue) {
            this.factory = factory;
            this.workQueue = workQueue;
            this.finishQueue = finishQueue;
        }

        @Override
        public void run() {
            this.context = this.factory.newThreadContext();
            ((ThreadContext)this.context).init();
            try {
                List task;
                while ((task = this.getTask()) != null) {
                    Conveyor.this.process(task, this.context);
                }
                while ((task = this.getFinishTask()) != null) {
                    Conveyor.this.process(task, this.context);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                ((ThreadContext)this.context).destroy();
            }
        }

        List<T> getTask() {
            while (true) {
                try {
                    do {
                        int state;
                        if ((state = Conveyor.this.runState) > 1) {
                            return null;
                        }
                        List r = state == 1 ? (List)this.workQueue.poll() : this.workQueue.take();
                        if (r == null) continue;
                        return r;
                    } while (!this.workQueue.isEmpty());
                    return null;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        List<T> getFinishTask() {
            do {
                int state;
                if ((state = Conveyor.this.runState) > 1) {
                    return null;
                }
                List r = this.finishQueue.poll();
                if (r == null) continue;
                return r;
            } while (!this.finishQueue.isEmpty());
            return null;
        }
    }

    public static abstract class DefaultConveyor<T>
    extends Conveyor<T, ConveyorContext<T>, DefaultContext> {
        private final DefaultServerSetup setup;

        public DefaultConveyor(int count, int queueSize, int batchSize, final DefaultServerSetup setup) {
            super(count, queueSize, batchSize, new ThreadContextFactory<DefaultContext>(){

                @Override
                public DefaultContext newThreadContext() {
                    return new DefaultContext(ConnectionSet.newInstance(setup, true));
                }
            });
            this.setup = setup;
        }

        @Override
        public ConveyorContext<T> newThreadContext() {
            return new ConveyorContext(ConnectionSet.newInstance(this.setup, true), this);
        }
    }

    public static abstract class AbstractConveyor<T, C extends ThreadContext>
    extends Conveyor<T, ConveyorContext<T>, C> {
        private final DefaultServerSetup setup;

        public AbstractConveyor(int count, int queueSize, int batchSize, DefaultServerSetup setup, ThreadContextFactory<C> factory) {
            super(count, queueSize, batchSize, factory);
            this.setup = setup;
        }

        @Override
        public ConveyorContext<T> newThreadContext() {
            return new ConveyorContext(ConnectionSet.newInstance(this.setup, true), this);
        }
    }

    public static abstract class ConveyorTask<T, C extends ConveyorContext<T>>
    extends WorkerTask<C>
    implements Callable<Void> {
        @Override
        public Void call() throws Exception {
            this.run();
            return null;
        }
    }

    public static class ConveyorContext<T>
    extends DefaultContext {
        private final Conveyor<T, ?, ?> conveyor;
        private final int batchSize;
        private final int count;
        private final List<T>[] tasks;

        public ConveyorContext(ConnectionSet connectionSet, Conveyor<T, ?, ?> conveyor) {
            super(connectionSet);
            this.conveyor = conveyor;
            this.count = conveyor.count;
            this.batchSize = conveyor.batchSize;
            this.tasks = new List[this.count];
            for (int i = 0; i < this.count; ++i) {
                this.tasks[i] = new ArrayList<T>(this.batchSize);
            }
        }

        @Override
        public void init() {
            this.conveyor.sync.reduce();
            super.init();
        }

        @Override
        public void destroy() {
            for (int i = 0; i < this.count; ++i) {
                List<T> list = this.tasks[i];
                if (list.size() <= 0) continue;
                this.tasks[i] = null;
                this.conveyor.processLast(i, list);
            }
            super.destroy();
            this.conveyor.sync.release();
        }

        public void add(int id, T task) {
            int index = id % this.count;
            List<T> list = this.tasks[index];
            list.add(task);
            if (list.size() >= this.batchSize) {
                try {
                    this.tasks[index] = new ArrayList<T>(list.size());
                    this.conveyor.processByIndex(index, list);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    Thread.interrupted();
                }
            }
        }
    }
}

