/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.domain.client;

import bitel.billing.module.common.BGTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.oss.kernel.directories.domain.common.bean.Domain;
import ru.bitel.oss.kernel.directories.domain.common.service.DomainService;

public class DomainPanel
extends BGUPanel {
    private final Set<Integer> cutSet = new HashSet<Integer>();
    private DomainTreeTableModel model = new DomainTreeTableModel();

    public DomainPanel() {
        super(new BorderLayout());
    }

    @Override
    protected void jbInit() {
        BGUTreeTable table = new BGUTreeTable(this.model);
        this.setLayout(new GridBagLayout());
        this.add((Component)BGSwingUtilites.wrapEmptyBorder(new JScrollPane(table)), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.7, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.handleEdit(table, this);
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                DomainPanel.this.model.setData(((ClientContext)DomainPanel.this.getContext()).getPort(DomainService.class).domainTree());
            }
        };
        new AbstractBGUPanel.MenuAction("domain.cut", "\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c", (Icon)ClientUtils.getIcon("cut")){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                DomainPanel.this.cutSet.clear();
                List selectedRows = DomainPanel.this.model.getSelectedRows();
                if (selectedRows == null) {
                    return;
                }
                for (Domain d : selectedRows) {
                    DomainPanel.this.cutSet.add(d.getId());
                }
            }
        };
        new AbstractBGUPanel.MenuAction("domain.paste", "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", (Icon)ClientUtils.getIcon("paste")){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                Domain parent = (Domain)DomainPanel.this.model.getSelectedRow();
                if (parent != null && DomainPanel.this.cutSet.size() > 0) {
                    ((ClientContext)DomainPanel.this.getContext()).getPort(DomainService.class).domainMove(parent.getId(), DomainPanel.this.cutSet);
                    DomainPanel.this.cutSet.clear();
                    DomainPanel.this.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                Domain current = new Domain();
                Domain parent = (Domain)DomainPanel.this.model.getSelectedRow();
                if (parent != null) {
                    current.setParentId(parent.getId());
                }
                new Editor("\u041d\u043e\u0432\u044b\u0439 \u0434\u043e\u043c\u0435\u043d", current).getDialog().setVisible(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                Domain current = (Domain)DomainPanel.this.model.getSelectedRow();
                if (current != null && current.getId() != 0) {
                    current = ((ClientContext)DomainPanel.this.getContext()).getPort(DomainService.class).domainGet(current.getId());
                    new Editor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0434\u043e\u043c\u0435\u043d\u0430", current).getDialog().setVisible(true);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                Domain current = (Domain)DomainPanel.this.model.getSelectedRow();
                if (current != null && current.getId() != 0 && BGSwingUtilites.confirmDelete("\u0434\u043e\u043c\u0435\u043d", current)) {
                    ((ClientContext)DomainPanel.this.getContext()).getPort(DomainService.class).domainDelete(current.getId());
                    DomainPanel.this.performAction("refresh");
                }
            }
        };
    }

    @Override
    public boolean performAction(String action) {
        if ("newItem".equals(action)) {
            action = "new";
        } else if ("editItem".equals(action)) {
            action = "edit";
        } else if ("deleteItem".equals(action)) {
            action = "delete";
        }
        return super.performAction(action);
    }

    class DomainTreeTableModel
    extends BGTreeTableModel<Domain> {
        private Icon folder2;
        private Icon leaf;
        private Domain rootDomain;

        public DomainTreeTableModel() {
            super(DomainTreeTableModel.class.getName());
            this.folder2 = ClientUtils.getIcon("fugue/tree");
            this.leaf = ClientUtils.getIcon("fugue/leaf");
        }

        @Override
        protected void initColumns() {
            this.rootDomain = new Domain();
            this.rootDomain.setId(0);
            this.rootDomain.setTitle("\u0414\u043e\u043c\u0435\u043d\u044b");
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", Domain.class, false);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", "comment", false);
            this.addColumnId();
        }

        @Override
        public Object getValue(Domain val, int column) throws BGException {
            switch (column) {
                case 0: {
                    return val == this.root ? this.rootDomain : val;
                }
            }
            return super.getValue(val, column);
        }

        @Override
        public Icon getIcon(Domain value) {
            if (value == this.root) {
                return this.folder2;
            }
            if (value.getChildren() == null || value.getChildren().size() == 0) {
                return this.leaf;
            }
            return this.folder2;
        }
    }

    class Editor
    extends BGEditorDialog<Domain> {
        private BGTextField title;
        private BGTextArea comment;

        public Editor(String title, Domain data) {
            super(title, data);
            this.title = new BGTextField(40);
            this.comment = new BGTextArea(3, 40);
        }

        @Override
        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, new Insets(2, 0, 0, 0), 0, 0));
            this.title.setText(((Domain)this.data).getTitle());
            this.comment.setText(((Domain)this.data).getComment());
        }

        @Override
        public boolean doApply() throws Exception {
            if (this.title.getText().trim().length() == 0) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435");
                return false;
            }
            ((Domain)this.data).setTitle(this.title.getText());
            ((Domain)this.data).setComment(this.comment.getText());
            int id = ((ClientContext)DomainPanel.this.getContext()).getPort(DomainService.class).domainUpdate((Domain)this.data);
            DomainPanel.this.performAction("refresh");
            DomainPanel.this.model.setSelectedRow(id);
            return true;
        }
    }
}

