/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.table.TableCellEditor;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.oss.kernel.entity.client.table.EntityAttrEntry;
import ru.bitel.oss.kernel.entity.client.table.EntityAttributesTable;
import ru.bitel.oss.kernel.entity.client.table.EntityAttributesTableModel;
import ru.bitel.oss.kernel.entity.common.bean.Entity;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttr;
import ru.bitel.oss.kernel.entity.common.service.EntityService;

public class EntityAttributesForm
extends BGUPanel {
    private EntityAttributesTable table;
    private EntityAttributesTableModel model;
    private Entity current;
    private final AtomicReference<? extends Entity> currentRef;
    private Map<Integer, BGUPanel> editors = new HashMap<Integer, BGUPanel>();

    public EntityAttributesForm(AtomicReference<? extends Entity> currentRef, ClientContext context) {
        super((LayoutManager)new GridBagLayout(), context);
        this.currentRef = currentRef;
        this.model = new EntityAttributesTableModel(context);
    }

    @Override
    protected void jbInit() {
        this.table = new EntityAttributesTable(this.model, () -> (ClientContext)this.getContext());
        this.table.setSelectionMode(0);
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.addButton(this.getActionMap().get("edit"));
        toolBar.setFloatable(false);
        this.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 0), 0, 0));
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        toolBar.compact();
        this.addHierarchyListener(e -> {
            if (e.getChanged() == this && e.getChangeFlags() == 4L && this.isVisible()) {
                this.refresh();
            }
        });
        BGSwingUtilites.handleEdit(this.table, this, "attribute.edit");
    }

    public void reset() {
        this.model.setData(new ArrayList());
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionNew(e -> this.refresh());
        new AbstractBGUPanel.BGActionEdit(e -> {
            Entity entity;
            this.model.setData(entity, (entity = this.currentRef.get()) != null ? ((ClientContext)this.getContext()).getPort(EntityService.class, 0).entitySpecGet(entity.getEntitySpecId()) : null);
        });
        new AbstractBGUPanel.DefaultAction("ok", "Ok"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                TableCellEditor editor;
                if (EntityAttributesForm.this.table.getSelectedRow() > -1 && EntityAttributesForm.this.table.isCellEditable(EntityAttributesForm.this.table.getSelectedRow(), EntityAttributesForm.this.table.getSelectedColumn()) && (editor = EntityAttributesForm.this.table.getCellEditor(EntityAttributesForm.this.table.getSelectedRow(), EntityAttributesForm.this.table.getSelectedColumn())) != null) {
                    editor.stopCellEditing();
                }
                HashMap<Integer, EntityAttr> entityAttributes = new HashMap<Integer, EntityAttr>();
                for (EntityAttrEntry entry : EntityAttributesForm.this.model.getRows()) {
                    EntityAttr a = entry.getAttr();
                    if (a == null) continue;
                    entityAttributes.put(a.getEntitySpecAttrId(), a);
                }
                if (EntityAttributesForm.this.current != null) {
                    EntityAttributesForm.this.current.setEntityAttributes(entityAttributes);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("attribute.edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0430\u0442\u0440\u0438\u0431\u0443\u0442"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                BGUPanel form;
                EntitySpecAttr sa;
                EntityAttrEntry entityAttrEntry = (EntityAttrEntry)EntityAttributesForm.this.model.getSelectedRow();
                if (entityAttrEntry != null && (sa = entityAttrEntry.getSpecAttr()) != null && (form = EntityAttributesForm.this.editors.get(sa.getType())) != null) {
                    form.performAction("edit");
                }
            }
        };
    }

    public void refresh() {
        this.current = this.currentRef.get();
        if (this.current == null) {
            return;
        }
        new SwingWorker<EntitySpec, Void>(){

            @Override
            protected EntitySpec doInBackground() throws Exception {
                return ((ClientContext)EntityAttributesForm.this.getContext()).getPort(EntityService.class, 0).entitySpecGet(EntityAttributesForm.this.currentRef.get().getEntitySpecId());
            }

            @Override
            protected void done() {
                try {
                    if (EntityAttributesForm.this.model.getRows().size() == 0) {
                        EntityAttributesForm.this.model.setData(EntityAttributesForm.this.current, (EntitySpec)this.get());
                    } else {
                        HashMap<Integer, EntityAttr> entityAttributes = new HashMap<Integer, EntityAttr>();
                        for (EntityAttrEntry entry : EntityAttributesForm.this.model.getRows()) {
                            EntityAttr a = entry.getAttr();
                            if (a == null) continue;
                            entityAttributes.put(a.getEntitySpecAttrId(), a);
                        }
                        ArrayList<EntityAttrEntry> list = new ArrayList<EntityAttrEntry>();
                        if (this.get() != null) {
                            for (EntitySpecAttr specAttr : ((EntitySpec)this.get()).getAttributeList()) {
                                list.add(new EntityAttrEntry(EntityAttributesForm.this.current, specAttr, (EntityAttr)entityAttributes.get(specAttr.getId())));
                            }
                        }
                        EntityAttributesForm.this.model.setData(list);
                    }
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
        }.execute();
    }
}

