/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.oss.kernel.entity.client.model.EntitySpecTableModel;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttr;
import ru.bitel.oss.kernel.entity.common.service.EntityService;

public class EntitySpecPanel
extends BGUPanel {
    private EntitySpecTableModel model = new EntitySpecTableModel();
    private EntityService entityService = null;

    public EntitySpecPanel() {
        super(new GridBagLayout());
    }

    @Override
    protected void shownNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this);
    }

    @Override
    protected void jbInit() {
        BGUTable table = new BGUTable(this.model);
        table.setSelectionMode(0);
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        BGSwingUtilites.handleEdit(table, this);
    }

    private EntityService getEntityService() {
        if (this.entityService == null) {
            this.entityService = ((ClientContext)this.getContext()).getPort(EntityService.class);
        }
        return this.entityService;
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                EntitySpecPanel.this.model.setData(EntitySpecPanel.this.getEntityService().entitySpecList());
            }
        };
        new AbstractBGUPanel.DefaultAction("new", "\u0421\u043e\u0437\u0434\u0430\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                new EntitySpecEditor("\u041d\u043e\u0432\u044b\u0439 \u043d\u0430\u0431\u043e\u0440 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u0432", new EntitySpec()).getDialog().setVisible(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                EntitySpec entitySpec = (EntitySpec)EntitySpecPanel.this.model.getSelectedRow();
                if (entitySpec != null) {
                    new EntitySpecEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u0431\u043e\u0440\u0430 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u0432", entitySpec).getDialog().setVisible(true);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ClientUtils.showErrorMessageDialog("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u0442.\u043a. \u043d\u0430\u0431\u043e\u0440 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u0430 \u043a \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044f\u043c \u043c\u043e\u0434\u0443\u043b\u044f.");
            }
        };
    }

    class MoveEntitySpecAttr
    implements ActionListener {
        private JList<EntitySpecAttr> from;
        private JList<EntitySpecAttr> to;

        MoveEntitySpecAttr(JList<EntitySpecAttr> from, JList<EntitySpecAttr> to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (EntitySpecAttr entitySpecAttr : this.from.getSelectedValuesList()) {
                ((DefaultListModel)this.to.getModel()).addElement(entitySpecAttr);
                ((DefaultListModel)this.from.getModel()).removeElement(entitySpecAttr);
            }
        }
    }

    class EntitySpecEditor
    extends BGEditorDialog<EntitySpec> {
        private JList<EntitySpecAttr> selectAttr;
        private JList<EntitySpecAttr> avaiblAttr;
        private BGTextField title;
        private JTextArea comment;

        public EntitySpecEditor(String title, EntitySpec data) {
            super(title, data);
            this.selectAttr = new JList();
            this.avaiblAttr = new JList();
            this.title = new BGTextField(50);
            this.comment = new JTextArea(3, 50);
        }

        @Override
        public void doDialogPanel() {
            DefaultListCellRenderer listCellRenderer = new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    EntitySpecAttr entitySpecAttr = (EntitySpecAttr)value;
                    JLabel component = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    component.setText(entitySpecAttr.getTitle() + " [" + entitySpecAttr.getTypeName() + "]");
                    return component;
                }
            };
            this.selectAttr.setCellRenderer(listCellRenderer);
            this.avaiblAttr.setCellRenderer(listCellRenderer);
            this.comment.setMargin(new Insets(3, 3, 3, 3));
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.panel.add((Component)this.getAttrListPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.title.setText(((EntitySpec)this.data).getTitle());
            this.comment.setText(((EntitySpec)this.data).getComment());
            HashSet<Object> selectSet = new HashSet<Object>();
            DefaultListModel<EntitySpecAttr> selectListModel = new DefaultListModel<EntitySpecAttr>();
            if (((EntitySpec)this.data).getAttributeList() != null) {
                for (Object entitySpecAttr : ((EntitySpec)this.data).getAttributeList()) {
                    selectListModel.addElement((EntitySpecAttr)entitySpecAttr);
                    selectSet.add(entitySpecAttr);
                }
            }
            this.selectAttr.setModel(selectListModel);
            DefaultListModel<EntitySpecAttr> avaibleListModel = new DefaultListModel<EntitySpecAttr>();
            try {
                for (EntitySpecAttr entitySpecAttr : EntitySpecPanel.this.getEntityService().entitySpecAttrList()) {
                    if (selectSet.contains(entitySpecAttr)) continue;
                    avaibleListModel.addElement(entitySpecAttr);
                }
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog(e);
            }
            this.avaiblAttr.setModel(avaibleListModel);
        }

        private JPanel getAttrListPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.getSelectPanel("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u044b:", this.selectAttr), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.getButtonPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
            panel.add((Component)this.getSelectPanel("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u044b:", this.avaiblAttr), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getSelectPanel(String title, JList<EntitySpecAttr> list) {
            Dimension dimension = new Dimension(400, 300);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setMinimumSize(dimension);
            panel.setPreferredSize(dimension);
            panel.add((Component)new JLabel(title), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)new JScrollPane(list), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getButtonPanel() {
            JButton addButton = new JButton("<<<");
            JButton delButton = new JButton(">>>");
            addButton.addActionListener(new MoveEntitySpecAttr(this.avaiblAttr, this.selectAttr));
            delButton.addActionListener(new MoveEntitySpecAttr(this.selectAttr, this.avaiblAttr));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel(" "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)addButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)delButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        @Override
        public boolean doApply() throws Exception {
            ArrayList<EntitySpecAttr> attrs = new ArrayList<EntitySpecAttr>();
            ListModel<EntitySpecAttr> listModel = this.selectAttr.getModel();
            for (int index = 0; index < listModel.getSize(); ++index) {
                attrs.add(listModel.getElementAt(index));
            }
            ((EntitySpec)this.data).setTitle(this.title.getText());
            ((EntitySpec)this.data).setComment(this.comment.getText());
            ((EntitySpec)this.data).setAttributeList(attrs);
            int id = EntitySpecPanel.this.getEntityService().entitySpecUpdate((EntitySpec)this.data);
            EntitySpecPanel.this.performAction("refresh");
            EntitySpecPanel.this.model.setSelectedRow(id);
            return true;
        }
    }
}

