/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.client.editor;

import bitel.billing.module.common.BGComboBoxWithSearch;
import bitel.billing.module.common.BGTabbedPane;
import bitel.billing.module.common.BGTextArea;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.contract.AddressUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.Column;
import ru.bitel.common.model.GuiTitlable;
import ru.bitel.common.model.KeyValue;
import ru.bitel.oss.kernel.directories.address.common.bean.Area;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.Quarter;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;
import ru.bitel.oss.kernel.entity.client.editor.HouseEditor;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityType;

public abstract class AbstractAddressEditor
extends BGUPanel {
    protected static String PANEL_ADDRESS = "address";
    protected static String PANEL_ADDRESS_CUSTOM = "address_custom";
    protected static String PANEL_EDITOR = "editor";
    protected static String PANEL_HOUSE = "house";
    protected static int MODE_ADDRESS = 0;
    protected static int MODE_HOUSE = 1;
    protected int hid;
    protected int editMode = 0;
    protected String areaValue = null;
    protected String quarterValue = null;
    protected String panel = null;
    protected BGButton houseButton = new BGButton();
    private BGButton clearHouseButton = new BGButton("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u043f\u043e\u043b\u0435");
    protected boolean addressCleared = false;
    protected boolean addressCustomFlag = true;
    protected BGTextField flat = new BGTextField();
    protected BGTextField room = new BGTextField();
    protected IntTextField pod = new IntTextField();
    protected IntTextField floor = new IntTextField();
    protected BGTextField index = new BGTextField();
    private BGTextField area = new BGTextField();
    private BGTextField quarter = new BGTextField();
    protected BGTextArea comment = new BGTextArea();
    protected CardLayout mainLayout = new CardLayout();
    protected HouseEditor houseEditor = new HouseEditor();
    private AbstractAddressEditor addressEditor = null;
    protected BGButton backToAddressPanelButton = new BGButton("\u0412\u0435\u0440\u043d\u0443\u0442\u044c\u0441\u044f \u043a \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c \u0430\u0434\u0440\u0435\u0441\u0430");
    private BGButton backToSelectHousePanelButton = new BGButton("\u0412\u0435\u0440\u043d\u0443\u0442\u044c\u0441\u044f \u0434\u043b\u044f \u0432\u044b\u0431\u043e\u0440\u0430 \u0434\u043e\u043c\u0430");
    private BGComboBoxWithSearch street = new BGComboBoxWithSearch(2);
    private BGTextField house = new BGTextField();
    private BGTable searchTable = new BGTable();
    protected BGButton newHouseButton;
    private BGButton newAddressCustomButton;
    protected AddressFormatModel addressFormatModel = new AddressFormatModel("addressFormat");
    protected JButton okButton;
    protected String houseAndFrac;
    protected String cityTitle;
    protected String streetTitle;
    protected boolean canCreateHouse = false;
    private BGTable additionalInfoTable;
    protected BGTextArea addressCustom;
    protected BGTextArea addressCustomComment;
    protected String entranceRange = null;
    private String floorRange = null;
    protected boolean isObject = false;
    protected int id;

    public AbstractAddressEditor() {
        this.addressEditor = this;
    }

    @Override
    protected void jbInit() {
        this.houseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAddressEditor.this.showPanelHouse();
                AbstractAddressEditor.this.backToAddressPanelButton.setEnabled(true);
                if (AbstractAddressEditor.this.okButton != null) {
                    AbstractAddressEditor.this.okButton.setEnabled(false);
                }
            }
        });
        this.clearHouseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAddressEditor.this.addressFormatModel.selected = null;
                AbstractAddressEditor.this.deleteAddress();
            }
        });
        final BGUTable addressFormatTable = new BGUTable(this.addressFormatModel);
        addressFormatTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                KeyValue selected;
                if (e.getClickCount() == 1 && (selected = (KeyValue)AbstractAddressEditor.this.addressFormatModel.getSelectedRow()) != null) {
                    AbstractAddressEditor.this.addressFormatModel.selected = selected != null ? (String)selected.getKey() : null;
                    addressFormatTable.repaint();
                }
            }
        });
        this.comment.setMinimumSize(new Dimension(70, 36));
        this.comment.setText("");
        this.comment.setLineWrap(true);
        this.comment.setRows(2);
        this.comment.setWrapStyleWord(true);
        this.room.setHorizontalAlignment(0);
        this.room.getDocument().addDocumentListener(new AddressDocumentListener());
        this.floor.setColumns(5);
        this.floor.getDocument().addDocumentListener(new AddressDocumentListener());
        this.pod.setColumns(5);
        this.pod.getDocument().addDocumentListener(new AddressDocumentListener());
        this.flat.setColumns(10);
        this.flat.setMinimumSize(new Dimension(80, 10));
        this.flat.getDocument().addDocumentListener(new AddressDocumentListener());
        this.flat.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AbstractAddressEditor.this.onFlatChanged();
            }
        });
        this.flat.setHorizontalAlignment(0);
        JPanel housePanel = new JPanel(new GridBagLayout());
        housePanel.add((Component)new JLabel("\u0414\u043e\u043c: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        housePanel.add((Component)this.houseButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        housePanel.add((Component)this.clearHouseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel houseInfoPanel = new JPanel(new GridBagLayout());
        houseInfoPanel.setBorder(new BGTitleBorder(" \u041a\u0432\u0430\u0440\u0442\u0438\u0440\u0430 "));
        houseInfoPanel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        houseInfoPanel.add((Component)this.flat, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        houseInfoPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043d\u0430\u0442\u0430: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        houseInfoPanel.add((Component)this.room, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        houseInfoPanel.add((Component)new JLabel("\u041f\u043e\u0434\u044a\u0435\u0437\u0434: "), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        houseInfoPanel.add((Component)this.pod, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        houseInfoPanel.add((Component)new JLabel("\u042d\u0442\u0430\u0436: "), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        houseInfoPanel.add((Component)this.floor, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        houseInfoPanel.add(Box.createGlue(), new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel commentPanel = new JPanel(new GridBagLayout());
        commentPanel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.additionalInfoTable = new BGTable();
        this.additionalInfoTable.addColumn("paramName", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", new int[]{100, 150, 200}, false);
        this.additionalInfoTable.setAutoResizeMode(1);
        this.additionalInfoTable.addColumn("paramValue", "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", new int[]{-1, -1, -1}, false);
        JPanel infoPanel = new JPanel(new BorderLayout());
        infoPanel.add((Component)new JScrollPane(this.additionalInfoTable), "Center");
        BGTabbedPane additionalHouseInfoPanel = new BGTabbedPane();
        additionalHouseInfoPanel.add((Component)commentPanel, "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
        additionalHouseInfoPanel.add((Component)infoPanel, "\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f");
        additionalHouseInfoPanel.add((Component)new JScrollPane(addressFormatTable), "\u0424\u043e\u0440\u043c\u0430\u0442 \u0430\u0434\u0440\u0435\u0441\u0430");
        JPanel addressPanel = new JPanel(new GridBagLayout());
        addressPanel.setFocusTraversalPolicy(this.getFocus());
        addressPanel.setFocusCycleRoot(true);
        addressPanel.add((Component)housePanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addressPanel.add((Component)houseInfoPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addressPanel.add((Component)additionalHouseInfoPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.street.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((long)e.getModifiers() & 0x10L) > 0L) {
                    AbstractAddressEditor.this.streetEntered();
                }
            }
        });
        this.street.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("fillText")) {
                    AbstractAddressEditor.this.fillStreetList(String.valueOf(evt.getNewValue()));
                } else if (evt.getPropertyName().equals("textEntered")) {
                    AbstractAddressEditor.this.streetEntered();
                }
            }
        });
        this.house.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                int selectedStreetId;
                if (e.getKeyChar() == '\n' && (selectedStreetId = Integer.valueOf(AbstractAddressEditor.this.street.getSelectedId()).intValue()) > 0) {
                    AbstractAddressEditor.this.fillListByHouses(selectedStreetId, AbstractAddressEditor.this.house.getText());
                }
            }
        });
        this.searchTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                BGTable table;
                int rowId;
                if (e.getClickCount() == 2 && (rowId = Integer.valueOf((table = (BGTable)e.getSource()).getValueAt(row = table.getSelectedRow(), 0).toString()).intValue()) > 0) {
                    if (AbstractAddressEditor.this.tableInStreetsMode(table)) {
                        AbstractAddressEditor.this.fillListByHouses(rowId, AbstractAddressEditor.this.house.getText());
                    } else {
                        try {
                            AbstractAddressEditor.this.setSelectedHouse(rowId);
                        }
                        catch (BGException ex) {
                            ClientUtils.showErrorMessageDialog(ex);
                        }
                    }
                }
            }
        });
        JButton searchButton = new JButton("\u041d\u0430\u0439\u0442\u0438");
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAddressEditor.this.streetEntered();
            }
        });
        this.backToAddressPanelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAddressEditor.this.mainLayout.show(AbstractAddressEditor.this.addressEditor, PANEL_ADDRESS);
                if (AbstractAddressEditor.this.okButton != null) {
                    AbstractAddressEditor.this.okButton.setEnabled(true);
                }
            }
        });
        this.newHouseButton = new BGButton("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u0434\u043e\u043c...");
        this.newHouseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAddressEditor.this.mainLayout.show(AbstractAddressEditor.this.addressEditor, PANEL_EDITOR);
                AbstractAddressEditor.this.editMode = MODE_HOUSE;
                if (AbstractAddressEditor.this.okButton != null) {
                    AbstractAddressEditor.this.okButton.setEnabled(true);
                }
            }
        });
        this.newAddressCustomButton = new BGButton("\u0414\u0440\u0443\u0433\u043e\u0435");
        this.newAddressCustomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAddressEditor.this.mainLayout.show(AbstractAddressEditor.this.addressEditor, PANEL_ADDRESS_CUSTOM);
                AbstractAddressEditor.this.addressCustom.setText("");
                AbstractAddressEditor.this.addressCustomComment.setText("");
                AbstractAddressEditor.this.okButton.setEnabled(true);
                AbstractAddressEditor.this.editMode = MODE_ADDRESS;
                AbstractAddressEditor.this.panel = PANEL_ADDRESS_CUSTOM;
            }
        });
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(new BGTitleBorder(" \u0424\u0438\u043b\u044c\u0442\u0440 "));
        jPanel4.add((Component)new JLabel("\u0423\u043b\u0438\u0446\u0430:"), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
        jPanel4.add((Component)this.street, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 5, 0, 5), 0, 0));
        jPanel4.add((Component)new JLabel("\u0414\u043e\u043c [\u0434\u0440\u043e\u0431\u044c]:"), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
        jPanel4.add((Component)this.house, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 5, 0, 5), 0, 0));
        jPanel4.add((Component)searchButton, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 11, 2, new Insets(10, 5, 0, 5), 0, 0));
        jPanel4.add((Component)this.backToAddressPanelButton, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 11, 2, new Insets(18, 5, 5, 0), 0, 0));
        jPanel4.add((Component)this.newHouseButton, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 11, 2, new Insets(18, 5, 5, 5), 0, 0));
        jPanel4.add((Component)this.newAddressCustomButton, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.street.setEditable(true);
        JPanel selectHousePanel = new JPanel(new GridBagLayout());
        selectHousePanel.add((Component)jPanel4, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        selectHousePanel.add((Component)new JLabel("\u041d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0438\u0441\u0438:"), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        selectHousePanel.add((Component)new JScrollPane(this.searchTable), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.backToSelectHousePanelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAddressEditor.this.mainLayout.show(AbstractAddressEditor.this.addressEditor, PANEL_HOUSE);
                AbstractAddressEditor.this.editMode = MODE_ADDRESS;
                if (AbstractAddressEditor.this.okButton != null) {
                    AbstractAddressEditor.this.okButton.setEnabled(false);
                }
                AbstractAddressEditor.this.panel = PANEL_HOUSE;
            }
        });
        JPanel houseEditorPanel = new JPanel(new GridBagLayout());
        houseEditorPanel.add((Component)this.backToSelectHousePanelButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        houseEditorPanel.add((Component)this.houseEditor, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        JPanel addressCustomEditor = new JPanel(new GridBagLayout());
        this.addressCustom = new BGTextArea();
        this.addressCustomComment = new BGTextArea();
        addressCustomEditor.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        addressCustomEditor.add((Component)new JScrollPane(this.addressCustom), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        addressCustomEditor.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        addressCustomEditor.add((Component)new JScrollPane(this.addressCustomComment), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.setLayout(this.mainLayout);
        this.add((Component)addressPanel, PANEL_ADDRESS);
        this.add((Component)houseEditorPanel, PANEL_EDITOR);
        this.add((Component)selectHousePanel, PANEL_HOUSE);
        this.add((Component)addressCustomEditor, PANEL_ADDRESS_CUSTOM);
    }

    public abstract void setData();

    public boolean updateData() {
        if (this.editMode == MODE_ADDRESS) {
            if (this.panel != null && this.panel.equals(PANEL_ADDRESS_CUSTOM)) {
                return this.updateAddressCustom();
            }
            return this.updateAddress();
        }
        if (this.updateHouse()) {
            this.editAddress();
        }
        return false;
    }

    protected abstract boolean updateAddressCustom();

    public void editHouse() {
        this.mainLayout.show(this, PANEL_HOUSE);
        this.editMode = MODE_HOUSE;
        this.panel = null;
        this.houseEditor.house.setText(this.houseButton.getText());
        this.houseEditor.box_index.setText(this.index.getText());
        this.houseEditor.amount.setText("0");
        this.houseEditor.comment.setText("");
        this.houseEditor.datePanel.setDateString("");
    }

    public void editAddress() {
        this.mainLayout.show(this, PANEL_ADDRESS);
        this.editMode = MODE_ADDRESS;
        this.panel = null;
        this.index.setText(this.houseEditor.box_index.getText());
        this.houseButton.setText(this.houseEditor.house.getText());
        this.houseButton.setText((GuiTitlable)this.houseEditor.city.getSelectedItem() + ", " + (GuiTitlable)this.houseEditor.street.getSelectedItem() + ", " + this.houseEditor.house.getText());
        this.areaValue = "";
        if (this.houseEditor.area.getSelectedIndex() > 0) {
            this.areaValue = ((Area)this.houseEditor.area.getSelectedItem()).toString();
            this.area.setText(this.areaValue);
        } else {
            this.area.setText("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e");
        }
        this.quarterValue = "";
        if (this.houseEditor.quarter.getSelectedIndex() > 0) {
            this.quarterValue = ((Quarter)this.houseEditor.quarter.getSelectedItem()).toString();
            this.quarter.setText(this.quarterValue);
        } else {
            this.quarter.setText("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e");
        }
        this.cityTitle = "";
        if (this.houseEditor.city.getSelectedIndex() > 0) {
            this.cityTitle = ((City)this.houseEditor.city.getSelectedItem()).toString();
        }
        this.streetTitle = ((Street)this.houseEditor.street.getSelectedItem()).toString();
        this.flat.setText("");
        this.room.setText("");
        this.pod.setText("");
        this.floor.setText("");
    }

    private boolean updateHouse() {
        if (!this.houseEditor.checkAddress()) {
            return false;
        }
        Request request = new Request();
        request.setModule("admin");
        request.setAction("UpdateAddressHouse");
        request.setAttribute("id", "new");
        request.setAttribute("cityid", String.valueOf(((City)this.houseEditor.city.getSelectedItem()).getId()));
        request.setAttribute("areaid", String.valueOf(((Area)this.houseEditor.area.getSelectedItem()).getId()));
        request.setAttribute("quarterid", String.valueOf(((Quarter)this.houseEditor.quarter.getSelectedItem()).getId()));
        request.setAttribute("streetid", String.valueOf(((Street)this.houseEditor.street.getSelectedItem()).getId()));
        request.setAttribute("houseAndFrac", this.houseEditor.house.getText().toString());
        request.setAttribute("box_index", this.houseEditor.box_index.getText().toString());
        request.setAttribute("amount", this.houseEditor.amount.getText().trim());
        request.setAttribute("dt", this.houseEditor.datePanel.getDateString());
        request.setAttribute("comment", this.houseEditor.comment.getText().trim());
        Document doc = ((ClientContext)this.getContext()).getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            Element address = XMLUtils.selectElement(doc, "data/address");
            this.hid = Integer.parseInt(XMLUtils.getAttribute(address, "hid", "-1"));
            return true;
        }
        return false;
    }

    protected abstract boolean updateAddress();

    protected abstract boolean updateAddressParameter();

    protected void setAddressDataToRequest(Request request) {
        request.setAttribute("hid", this.hid);
        request.setAttribute("flat", this.flat.getText().trim());
        request.setAttribute("room", this.room.getText().trim());
        request.setAttribute("pod", this.pod.getText().trim());
        request.setAttribute("floor", this.floor.getText().trim());
        request.setAttribute("cityStr", this.cityTitle);
        request.setAttribute("quarter", this.quarterValue);
        request.setAttribute("streetStr", this.streetTitle);
        request.setAttribute("area", this.areaValue);
        request.setAttribute("houseAndFrac", this.houseAndFrac);
        request.setAttribute("index", this.index.getText().trim());
        request.setAttribute("comment", this.comment.getText().trim());
    }

    protected abstract void deleteAddress();

    private void fillStreetList(String streetTitle) {
        Request request = new Request();
        request.setModule("admin");
        request.setAction("GetAddressStreet");
        request.setPageIndex(1);
        request.setPageSize(25);
        int pos = streetTitle.indexOf(40);
        if (pos < 0) {
            request.setAttribute("stname", streetTitle.trim());
        } else {
            request.setAttribute("stname", streetTitle.substring(0, pos).trim());
            if (pos < streetTitle.length() - 1) {
                request.setAttribute("city_title", streetTitle.substring(pos + 1).trim());
            }
        }
        Document doc = ((ClientContext)this.getContext()).getDocument(request);
        Iterable<Element> streets = XMLUtils.selectElements(doc, "data/table/data/row");
        this.street.initPopup(streetTitle);
        for (Element s : streets) {
            Integer streetId = Integer.valueOf(XMLUtils.getAttribute(s, "f0"));
            String streetName = XMLUtils.getAttribute(s, "f1") + " (" + XMLUtils.getAttribute(s, "f2") + ")";
            this.street.addItem(new ComboBoxItem(streetId, streetName));
        }
    }

    private void fillListByStreets(String streetSubstring) {
        this.searchTable.removeRows();
        if (Utils.notBlankString(streetSubstring)) {
            this.searchTable.removeColumns();
            this.searchTable.addColumn("streetId", "ID", new int[]{50, 70, 80}, false);
            this.searchTable.setAutoResizeMode(1);
            this.searchTable.addColumn("streetTitle", "\u0423\u043b\u0438\u0446\u0430", new int[]{-1, -1, -1}, false);
            this.searchTable.addColumn("cityTitle", "\u0413\u043e\u0440\u043e\u0434", new int[]{150, 200, 250}, false);
            Request request = new Request();
            request.setModule("admin");
            request.setAction("GetStreetsBySubstring");
            request.setAttribute("streetSubstring", streetSubstring);
            Document doc = ((ClientContext)this.getContext()).getDocument(request);
            for (Element streetEl : XMLUtils.selectElements(doc, "data/streetList/street")) {
                Vector<String> row = new Vector<String>();
                row.add(streetEl.getAttribute("streetId"));
                row.add(streetEl.getAttribute("streetTitle"));
                row.add(streetEl.getAttribute("cityTitle"));
                this.searchTable.addRow(row);
            }
        }
    }

    private void fillListByHouses(int streetId, String houseNum) {
        this.searchTable.removeRows();
        if (streetId > 0) {
            Request request = new Request();
            request.setModule("admin");
            request.setAction("FilterHouse");
            request.setAttribute("street", streetId);
            request.setAttribute("house_frac", houseNum);
            Document doc = ((ClientContext)this.getContext()).getDocument(request);
            Iterable<Element> houses = XMLUtils.selectElements(doc, "data/list/item");
            this.searchTable.removeColumns();
            this.searchTable.addColumn("houseId", "ID", new int[]{50, 70, 80}, false);
            this.searchTable.addColumn("house", "\u0414\u043e\u043c", new int[]{-1, -1, -1}, false);
            this.searchTable.setAutoResizeMode(3);
            for (Element houseItem : houses) {
                String address;
                int pos;
                String addressHouse = houseItem.getAttribute("house");
                if (addressHouse.isEmpty() && (pos = (address = houseItem.getAttribute("title")).indexOf(",")) > -1 && pos < address.length()) {
                    addressHouse = address.substring(pos + 1);
                }
                if (!houseNum.equals("") && addressHouse.indexOf(houseNum) <= -1) continue;
                HashMap<String, String> row = new HashMap<String, String>();
                row.put("house", houseItem.getAttribute("title"));
                row.put("houseId", houseItem.getAttribute("id"));
                this.searchTable.addRow(row);
            }
        }
    }

    private void streetEntered() {
        int selectedStreetId = Integer.valueOf(this.street.getSelectedId());
        if (selectedStreetId > 0) {
            this.fillListByHouses(selectedStreetId, this.house.getText());
        } else {
            String streetText = ((ComboBoxItem)this.street.getSelectedItem()).toString();
            this.fillListByStreets(streetText);
        }
    }

    private boolean tableInStreetsMode(BGTable table) {
        return table.getColumnCount() == 3;
    }

    protected void setAdditionalInfo(Map<String, String> info) {
        this.additionalInfoTable.removeRows();
        for (String paramName : info.keySet()) {
            this.addAdditionalParameter(paramName, info.get(paramName));
        }
    }

    private void addAdditionalParameter(String name, String value) {
        Vector<String> paramRow = new Vector<String>();
        paramRow.add(name);
        paramRow.add(value);
        this.additionalInfoTable.addRow(paramRow);
    }

    private void showPanelHouse() {
        this.addressCleared = false;
        this.mainLayout.show(this.addressEditor, PANEL_HOUSE);
        this.street.removeAllItems();
        this.house.setText("");
        this.searchTable.removeRows();
    }

    protected void setSelectedHouse(int houseId) throws BGException {
        this.clearHouseInfo();
        this.hid = houseId;
        Request request = new Request();
        request.setModule("admin");
        request.setAction("GetHouseInfo");
        request.setPageIndex(1);
        request.setPageSize(25);
        request.setAttribute("houseid", houseId);
        request.setAttribute("pid", this.id);
        request.setAttribute("isObject", this.isObject);
        Document doc = ((ClientContext)this.getContext()).getDocument(request);
        Element houseInfo = XMLUtils.selectElement(doc, "data/table/data/row");
        HashMap<String, String> additionalInfo = new HashMap<String, String>();
        additionalInfo.put("\u0418\u043d\u0434\u0435\u043a\u0441", houseInfo.getAttribute("f1"));
        additionalInfo.put("\u0420\u0430\u0439\u043e\u043d", houseInfo.getAttribute("f3"));
        additionalInfo.put("\u041a\u0432\u0430\u0440\u0442\u0430\u043b", houseInfo.getAttribute("f4"));
        this.addExtraParamsToMap(XMLUtils.selectElement(doc, "data/extraParams"), additionalInfo);
        this.setAdditionalInfo(additionalInfo);
        AddressService service = ((ClientContext)this.getContext()).getPort(AddressService.class, 0);
        EntityAttrAddress attrAddress = new EntityAttrAddress(0, 0);
        attrAddress.setHouseId(houseId);
        attrAddress.setPod((int)this.pod.getValue());
        attrAddress.setFloor((int)this.floor.getValue());
        attrAddress.setFlat(this.flat.getText());
        attrAddress.setRoom(this.room.getText());
        attrAddress.setComment(this.comment.getText());
        List addressFormatList = service.addressFormat(attrAddress, EntityType.CONTRACT_PARAMETER);
        this.addressFormatModel.setData(addressFormatList);
        this.house.setText(houseInfo.getAttribute("f6"));
        this.area.setText(this.areaValue);
        this.quarter.setText(this.quarterValue);
        this.cityTitle = houseInfo.getAttribute("f2");
        this.streetTitle = houseInfo.getAttribute("f5");
        this.houseAndFrac = houseInfo.getAttribute("f6");
        this.houseButton.setText(this.cityTitle + ", " + this.streetTitle + ", " + this.houseAndFrac);
        this.mainLayout.show(this.addressEditor, PANEL_ADDRESS);
        if (this.okButton != null) {
            this.okButton.setEnabled(true);
        }
    }

    private void addExtraParamsToMap(Element extraParams, Map<String, String> map) {
        if (extraParams != null) {
            for (Element item : XMLUtils.elements(extraParams.getChildNodes())) {
                String key = item.getAttribute("param_title");
                String value = item.getAttribute("param_value");
                String id = item.getAttribute("param_id");
                if (id.equals("floorRange")) {
                    this.floorRange = value;
                }
                if (id.equals("entranceRange")) {
                    this.entranceRange = value;
                }
                map.put(key, value);
            }
        }
    }

    public void setAddressCustomFlag(boolean addressCustomFlag) {
        this.addressCustomFlag = addressCustomFlag;
    }

    protected void clearHouseInfo() {
        this.additionalInfoTable.removeRows();
        this.houseButton.requestFocusInWindow();
        this.houseButton.setText("");
        this.flat.setText("");
        this.pod.setText("");
        this.floor.setText("");
        this.room.setText("");
        this.comment.setText("");
    }

    private void onFlatChanged() {
        String flt = this.flat.getText();
        if (flt != null && !flt.equals("") && this.entranceRange != null && this.floorRange != null) {
            int entr = AddressUtil.getEntrance(this.entranceRange, Integer.valueOf(flt));
            int fl = AddressUtil.getFloor(this.floorRange, Integer.valueOf(flt));
            this.floor.setText(String.valueOf(fl));
            this.pod.setText(String.valueOf(entr));
        }
    }

    public void setOkButton(JButton button) {
        this.okButton = button;
    }

    protected void clearHouseSearchPanel() {
        this.searchTable.removeRows();
        ((JTextComponent)this.street.getEditor().getEditorComponent()).setText("");
        this.house.setText("");
    }

    private FocusTraversalPolicy getFocus() {
        Vector<Component> focusOrder = new Vector<Component>();
        focusOrder.add(this.houseButton);
        focusOrder.add(this.flat);
        focusOrder.add(this.room);
        focusOrder.add(this.pod);
        focusOrder.add(this.floor);
        focusOrder.add(this.comment);
        return new AddressEditorFocusTraversalPolicy(focusOrder);
    }

    protected static class AddressFormatModel
    extends BGTableModel<KeyValue<String, String>> {
        String selected;

        public AddressFormatModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("", Column.Radio.class, false);
            this.addColumn("", String.class, false);
        }

        @Override
        public Object getValue(KeyValue<String, String> val, int column) throws BGException {
            switch (column) {
                case 0: {
                    return this.selected != null && this.selected.equals(val.getKey());
                }
                case 1: {
                    return val.getValue();
                }
            }
            return super.getValue(val, column);
        }
    }

    class AddressDocumentListener
    implements DocumentListener {
        AddressDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateTable(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateTable(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateTable(e);
        }

        private void updateTable(DocumentEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AddressService service = ((ClientContext)AbstractAddressEditor.this.getContext()).getPort(AddressService.class, 0);
                    try {
                        EntityAttrAddress attrAddress = new EntityAttrAddress(0, 0);
                        attrAddress.setHouseId(AbstractAddressEditor.this.hid);
                        attrAddress.setPod((int)AbstractAddressEditor.this.pod.getValue());
                        attrAddress.setFloor((int)AbstractAddressEditor.this.floor.getValue());
                        attrAddress.setFlat(AbstractAddressEditor.this.flat.getText());
                        attrAddress.setRoom(AbstractAddressEditor.this.room.getText());
                        attrAddress.setComment(AbstractAddressEditor.this.comment.getText());
                        List addressFormatList = service.addressFormat(attrAddress, EntityType.CONTRACT_PARAMETER);
                        AbstractAddressEditor.this.addressFormatModel.setData(addressFormatList);
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
            });
        }
    }

    class AddressEditorFocusTraversalPolicy
    extends FocusTraversalPolicy {
        Vector<Component> order = null;

        public AddressEditorFocusTraversalPolicy(Vector<Component> order) {
            this.order = new Vector(order.size());
            this.order.addAll(order);
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            int idx = (this.order.indexOf(aComponent) + 1) % this.order.size();
            return this.order.get(idx);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            int idx = this.order.indexOf(aComponent) - 1;
            if (idx < 0) {
                idx = this.order.size() - 1;
            }
            return this.order.get(idx);
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return this.order.lastElement();
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }
    }
}

