/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.client.editor;

import bitel.billing.module.common.BGControlPanelDate;
import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.oss.kernel.directories.address.common.bean.Area;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.Quarter;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;

public class HouseEditor
extends BGUPanel
implements ActionListener {
    public BGUComboBox<City> city = new BGUComboBox();
    public BGUComboBox<Area> area = new BGUComboBox();
    public BGUComboBox<Quarter> quarter = new BGUComboBox();
    public BGUComboBox<Street> street = new BGUComboBox();
    private Map<Integer, SoftReference<AddressList>> addressMap = new HashMap<Integer, SoftReference<AddressList>>();
    public JTextArea comment = new JTextArea();
    public JTextField house = new JTextField();
    public IntTextField box_index = new IntTextField();
    public IntTextField amount = new IntTextField();
    public BGControlPanelDate datePanel = new BGControlPanelDate();

    public HouseEditor() {
        super(new GridBagLayout());
    }

    @Override
    protected void jbInit() throws BGException {
        JPanel cityPanel = new JPanel(new GridBagLayout());
        JPanel areaPanel = new JPanel(new GridBagLayout());
        JPanel quarterPanel = new JPanel(new GridBagLayout());
        JPanel streetPanel = new JPanel(new GridBagLayout());
        JPanel housePanel = new JPanel(new GridBagLayout());
        JPanel box_indexPanel = new JPanel(new GridBagLayout());
        JPanel amountPanel = new JPanel(new GridBagLayout());
        JPanel commentPanel = new JPanel(new GridBagLayout());
        cityPanel.setBorder(new BGTitleBorder(" \u0413\u043e\u0440\u043e\u0434 "));
        areaPanel.setBorder(new BGTitleBorder(" \u0420\u0430\u0439\u043e\u043d "));
        quarterPanel.setBorder(new BGTitleBorder(" \u041a\u0432\u0430\u0440\u0442\u0430\u043b "));
        streetPanel.setBorder(new BGTitleBorder(" \u0423\u043b\u0438\u0446\u0430 "));
        housePanel.setBorder(new BGTitleBorder(" \u0414\u043e\u043c/\u0414\u0440\u043e\u0431\u044c "));
        box_indexPanel.setBorder(new BGTitleBorder(" \u0418\u043d\u0434\u0435\u043a\u0441 "));
        amountPanel.setBorder(new BGTitleBorder(" \u041a\u0432\u0430\u0440\u0442\u0438\u0440 "));
        commentPanel.setBorder(new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "));
        this.comment.setMinimumSize(new Dimension(485, 40));
        this.comment.setOpaque(true);
        this.comment.setPreferredSize(new Dimension(485, 40));
        this.comment.setText("");
        this.comment.setLineWrap(true);
        this.comment.setRows(2);
        this.comment.setWrapStyleWord(true);
        this.city.setMinimumSize(new Dimension(110, 25));
        this.city.setPreferredSize(new Dimension(110, 25));
        this.house.setMinimumSize(new Dimension(4, 24));
        this.house.setPreferredSize(new Dimension(59, 24));
        this.box_index.setMinimumSize(new Dimension(70, 24));
        this.box_index.setPreferredSize(new Dimension(59, 24));
        this.box_index.setColumns(6);
        this.box_index.setHorizontalAlignment(0);
        this.amount.setMinimumSize(new Dimension(37, 24));
        this.amount.setPreferredSize(new Dimension(59, 24));
        this.amount.setColumns(3);
        JScrollPane jScrollPane1 = new JScrollPane(this.comment);
        jScrollPane1.setMinimumSize(new Dimension(22, 40));
        jScrollPane1.setPreferredSize(new Dimension(488, 40));
        this.add((Component)cityPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        cityPanel.add(this.city, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)areaPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        areaPanel.add(this.area, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.street.setMaximumSize(new Dimension(120, 24));
        this.street.setPreferredSize(new Dimension(120, 24));
        this.add((Component)streetPanel, new GridBagConstraints(2, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        streetPanel.add(this.street, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)housePanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        housePanel.add((Component)this.house, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)box_indexPanel, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        box_indexPanel.add((Component)this.box_index, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)amountPanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        amountPanel.add((Component)this.amount, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.datePanel, new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)commentPanel, new GridBagConstraints(0, 3, 5, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        commentPanel.add((Component)jScrollPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)quarterPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        quarterPanel.add(this.quarter, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.city.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    HouseEditor.this.setAddressToEditor();
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
        });
        this.street.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HouseEditor.this.setIndex();
            }
        });
        this.house.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HouseEditor.this.setIndex();
            }
        });
        this.city.setData(((ClientContext)this.getContext()).getDirectory(City.class).list());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public void setCityComboBox(String cityId) {
    }

    private void setAddressToEditor() throws BGException {
        AddressList addressList;
        int cityId = ((City)this.city.getSelectedItem()).getId();
        SoftReference<AddressList> addressListRef = this.addressMap.get(cityId);
        AddressList addressList2 = addressList = addressListRef != null ? addressListRef.get() : null;
        if (addressList == null) {
            AddressService service = ((ClientContext)this.getContext()).getPort(AddressService.class, 0);
            addressList = new AddressList();
            addressList.areaList = service.searchAreaList(cityId, null, null, null).getList();
            addressList.quarterList = service.searchQuarterList(cityId, null, null, null).getList();
            addressList.streetList = service.searchStreetList(cityId, null, null, null).getList();
            City city = new City();
            city.setId(cityId);
            Area notSelectedArea = new Area();
            notSelectedArea.setId(0);
            notSelectedArea.setCity(city);
            notSelectedArea.setTitle("---");
            addressList.areaList.add(0, notSelectedArea);
            Quarter notSelectedQuarter = new Quarter();
            notSelectedQuarter.setId(0);
            notSelectedQuarter.setCity(city);
            notSelectedQuarter.setTitle("---");
            addressList.quarterList.add(0, notSelectedQuarter);
            this.addressMap.put(cityId, new SoftReference<AddressList>(addressList));
        }
        this.area.setData(addressList.areaList);
        this.quarter.setData(addressList.quarterList);
        this.street.setData(addressList.streetList);
    }

    private void setIndex() {
        String index = null;
        Street street = (Street)this.street.getSelectedItem();
        if (street != null && street.getId() > 0) {
            try {
                index = ((ClientContext)this.getContext()).getPort(AddressService.class, 0).postIndexGet(street.getId(), this.house.getText().trim(), 0, null);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
        this.box_index.setText(Utils.maskNull(index));
    }

    public boolean checkAddress() {
        if (this.city.getSelectedIndex() == -1) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0433\u043e\u0440\u043e\u0434");
            return false;
        }
        if (this.area.getSelectedIndex() == -1) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0440\u0430\u0439\u043e\u043d");
            return false;
        }
        if (this.quarter.getSelectedIndex() == -1) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u043a\u0432\u0430\u0440\u0442\u0430\u043b");
            return false;
        }
        if (this.street.getSelectedIndex() == -1) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u0443\u043b\u0438\u0446\u0430");
            return false;
        }
        if ("".equals(this.house.getText().trim())) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u0432\u0435\u0434\u0435\u043d\u043e \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435:  \u0434\u043e\u043c");
            return false;
        }
        if ("".equals(this.amount.getText().trim())) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u0432\u0435\u0434\u0435\u043d\u043e \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435:  \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e");
            return false;
        }
        return true;
    }

    class AddressList {
        List<Area> areaList;
        List<Quarter> quarterList;
        List<Street> streetList;

        AddressList() {
        }
    }
}

