/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.client.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUCheckList;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttrType;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;

public abstract class FilterEntityAttrDefaultPanel<F extends FilterEntityAttr>
extends BGUPanel {
    protected BGUCheckList<EntitySpecAttr> paramsList;
    protected BGUComboBox<EntitySpecAttr> paramsCombo;
    private final Integer parameterType;
    private Supplier<Map<Integer, List<EntitySpecAttr>>> parameterTypeMap;

    public FilterEntityAttrDefaultPanel(int parameterType, Supplier<Map<Integer, List<EntitySpecAttr>>> parameterTypeMap) {
        this.parameterType = parameterType;
        this.parameterTypeMap = parameterTypeMap;
    }

    @Override
    protected void jbInit() {
        this.paramsList = new BGUCheckList();
        this.paramsCombo = new BGUComboBox();
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            if (this.parameterTypeMap != null) {
                this.updateParameters();
            }
        });
    }

    public static List<EntitySpecAttr> buildList(Node node) {
        ArrayList<EntitySpecAttr> result = new ArrayList<EntitySpecAttr>();
        if (node != null && node.hasChildNodes()) {
            for (Element item : XMLUtils.elements(node.getChildNodes())) {
                EntitySpecAttr attr = new EntitySpecAttr();
                attr.setType(EntitySpecAttrType.ADDRESS.getCode());
                attr.setId(Utils.parseInt(XMLUtils.getAttribute(item, "title", null)));
                attr.setTitle(XMLUtils.getAttribute(item, "title", null));
                result.add(attr);
            }
        }
        return result;
    }

    protected void setParameters(Element parameters, boolean buildList, boolean buildCombo) {
        if (buildList) {
            this.paramsList.setData(FilterEntityAttrDefaultPanel.buildList(parameters));
        }
    }

    protected void setParameters(Element params, String paramType, boolean buildList, boolean buildCombo) {
        NodeList list = params.getElementsByTagName("parameters");
        for (int index = 0; index < list.getLength(); ++index) {
            Element parameters = (Element)list.item(index);
            String pt = XMLUtils.getAttribute(parameters, "pt", null);
            if (pt == null || !paramType.equals(pt)) continue;
            this.setParameters(parameters, buildList, buildCombo);
            break;
        }
    }

    public void updateParameters() {
        this.updateParameters(true, false);
    }

    protected void updateParameters(boolean buildList, boolean buildCombo) {
        if (this.parameterTypeMap == null) {
            Request request = ((ClientContext)this.getContext()).newRequest("OpenContract");
            request.setModule("contract");
            Document doc = ((ClientContext)this.getContext()).getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                this.setParameters(doc.getDocumentElement(), "2", true, false);
            }
        } else {
            List<EntitySpecAttr> params = this.parameterTypeMap.get().get(this.parameterType);
            if (params != null) {
                if (buildList) {
                    this.paramsList.setData(params);
                }
                if (buildCombo) {
                    this.paramsCombo.setData(params);
                }
            }
        }
    }

    public abstract F getFilter();

    public abstract void clearFilter();
}

