/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.client.table;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.function.Supplier;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.client.table.EntityAttrEntry;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.service.EntityService;

class EntityAttrListCellEditor
extends DefaultCellEditor
implements TableCellEditor {
    private Supplier<ClientContext> supplier;
    private EntityAttrEntry value = null;
    private BGUComboBox<IdTitle> comboBox;

    public EntityAttrListCellEditor(Supplier<ClientContext> supplier) {
        super(EntityAttrListCellEditor.newCombo());
        this.supplier = supplier;
        this.comboBox = (BGUComboBox)this.editorComponent;
    }

    private static BGUComboBox<IdTitle> newCombo() {
        return new BGUComboBox<IdTitle>(false);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = (EntityAttrEntry)value;
        EntityAttrList attrList = (EntityAttrList)this.value.getAttr();
        IdTitle idTitle = attrList != null ? new IdTitle(attrList.getValue(), attrList.getTitle()) : new IdTitle(-1, null);
        try {
            this.comboBox.setData(this.supplier.get().getPort(EntityService.class).entitySpecAttrListItemList(this.value.specAttr.getId()).stream().map(a -> a.toIdTitle()).toList());
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        Component result = super.getTableCellEditorComponent(table, idTitle, isSelected, row, column);
        ((JComboBox)result).requestFocus();
        return result;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.value == null) {
            return super.stopCellEditing();
        }
        IdTitle item = (IdTitle)this.getCellEditorValue();
        if (item == null || item.getId() == -1) {
            this.value.setAttr(null);
        } else {
            EntityAttrList attrList = (EntityAttrList)this.value.getAttr();
            if (attrList == null) {
                this.value.setAttr((EntityAttr)new EntityAttrList(this.value.getEntity().getEntityId(), this.value.getSpecAttr().getId(), item.getId(), item.getTitle()));
            } else {
                attrList.setValue(item.getId());
                attrList.setTitle(item.getTitle());
            }
        }
        return super.stopCellEditing();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return true;
    }
}

