/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGFilterPane;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUAction;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.oss.systems.inventory.product.client.ProductSpecFilter;
import ru.bitel.oss.systems.inventory.product.client.ProductSpecForm;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.service.ProductService;

public class ProductSpecPanel
extends BGUPanel {
    public static final int MODE_EDIT = 0;
    public static final int MODE_SELECT = 1;
    private final Icon iconRoot = ClientUtils.getIcon("fugue/folder");
    private final Icon iconNode = ClientUtils.getIcon("fugue/folder");
    private final Icon iconLeaf = ClientUtils.getIcon("fugue/present");
    private final Icon iconFolder = ClientUtils.getIcon("fugue/folder-network");
    private final DataFlavor[] dataFlavors = new DataFlavor[]{new DataFlavor(ProductOrderData.class, "ProductOrderData")};
    private int mode = 0;
    private BGEditor editor;
    private BGUTreeTable table;
    private ProductSpecFilter filter;
    private ProductService productService;
    private ProductSpecTreeTableModel model;
    private final BGFilterPane splitPane = new BGFilterPane(this.mode != 0);

    public ProductSpecPanel(ClientContext context) {
        super((LayoutManager)new BorderLayout(), context);
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            this.filter = new ProductSpecFilter(this, (ClientContext)this.getContext());
            this.splitPane.setFilterComponent(this.filter);
            String title = this.filter.mainFilter.title.getText();
            Date dateFrom = TimeUtils.convertCalendarToDate(this.filter.mainFilter.period.getDateCalendar1());
            Date dateTo = TimeUtils.convertCalendarToDate(this.filter.mainFilter.period.getDateCalendar2());
            this.getProductSpecTreeTableModel().setData(this.getProductService().productSpecRoot(Integer.valueOf(((ClientContext)this.getContext()).getModuleId()), dateFrom, dateTo, title, this.filter.getFilters()));
            this.table.expandAfterUpdate();
        });
    }

    @Override
    protected void jbInit() throws Exception {
        this.table = new BGUTreeTable(this.getProductSpecTreeTableModel());
        JPanel rightPanel = new JPanel(new BorderLayout());
        if (this.mode == 0) {
            this.editor = new BGEditor("table");
            JPanel tablePanel = new JPanel(new BorderLayout());
            tablePanel.setName("table");
            tablePanel.add((Component)new JScrollPane(this.table), "Center");
            rightPanel.add((Component)this.editor, "Center");
            this.splitPane.getToolBar().add(new BGUAction("showReorderDialog", "\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430", (Icon)ClientUtils.getIcon("fugue/tree--pencil")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ProductSpecPanel.this.reorderTree();
                }
            });
            this.splitPane.setDataComponent(tablePanel);
            this.editor.addForm(this.splitPane, "table");
            this.editor.addForm(new ProductSpecForm(this, (ClientContext)this.getContext()));
            this.add((Component)this.editor, "Center");
            BGSwingUtilites.handleEdit(this.table, this);
        } else {
            rightPanel.add((Component)new JScrollPane(this.table), "Center");
            this.splitPane.setDataComponent(rightPanel);
            this.add((Component)this.splitPane, "Center");
        }
    }

    ProductSpecTreeTableModel getProductSpecTreeTableModel() {
        if (this.model == null) {
            this.model = new ProductSpecTreeTableModel(ProductSpecTreeTableModel.class.getName());
        }
        return this.model;
    }

    ProductService getProductService() {
        if (this.productService == null) {
            this.productService = ((ClientContext)this.getContext()).getPort(ProductService.class, 0);
        }
        return this.productService;
    }

    protected int getEntitySpecId() throws BGException {
        return 0;
    }

    private void reorderTree() {
        try {
            JSONObject treeJsonObject = this.getProductService().productSpecTree(((ClientContext)this.getContext()).getModuleId());
            ProductOrderData productOrderData = new ProductOrderData();
            productOrderData.id = treeJsonObject.getInt("id");
            productOrderData.title = treeJsonObject.getString("title");
            productOrderData.type = 0;
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(productOrderData);
            this.buildTree(rootNode, treeJsonObject);
            JTree productTree = new JTree(rootNode);
            productTree.setCellRenderer(new ProductTreeCellRender());
            productTree.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            productTree.getSelectionModel().setSelectionMode(2);
            productTree.setDragEnabled(true);
            productTree.setDropMode(DropMode.ON_OR_INSERT);
            productTree.setTransferHandler(new TreeTransferHandler());
            Dimension dimension = new Dimension(1000, 600);
            JScrollPane scrollPane = new JScrollPane(productTree);
            scrollPane.setMinimumSize(dimension);
            scrollPane.setPreferredSize(dimension);
            JButton expandTreeButton = new JButton("\u0440\u0430\u0437\u0432\u0435\u0440\u043d\u0443\u0442\u044c \u0434\u0435\u0440\u0435\u0432\u043e");
            expandTreeButton.addActionListener(e -> {
                for (int i = 0; i < productTree.getRowCount(); ++i) {
                    productTree.expandRow(i);
                }
            });
            JButton expandTreeNodeButton = new JButton("\u0440\u0430\u0437\u0432\u0435\u0440\u043d\u0443\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0443\u044e \u0432\u0435\u0442\u043a\u0443");
            expandTreeNodeButton.addActionListener(e -> {
                if (!productTree.getSelectionModel().isSelectionEmpty()) {
                    int i;
                    int j = i = productTree.getSelectionModel().getSelectionRows()[0];
                    while (true) {
                        int max1 = productTree.getRowCount();
                        productTree.expandRow(i);
                        int max2 = productTree.getRowCount();
                        if (i == (j += max2 - max1)) break;
                        ++i;
                    }
                }
            });
            JButton collapseTreeButton = new JButton("\u0441\u0432\u0435\u0440\u043d\u0443\u0442\u044c \u0434\u0435\u0440\u0435\u0432\u043e");
            collapseTreeButton.addActionListener(e -> {
                for (int i = 1; i < productTree.getRowCount(); ++i) {
                    productTree.collapseRow(i);
                }
            });
            JPanel topPanel = new JPanel(new GridBagLayout());
            topPanel.add(collapseTreeButton);
            topPanel.add(expandTreeButton);
            topPanel.add(expandTreeNodeButton);
            topPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)topPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
            JButton[] buttons = new JButton[]{new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c")};
            BGOptionPane optionPane = new BGOptionPane((Object)panel, "\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430", buttons);
            JDialog dialog = optionPane.getDialog();
            buttons[0].addActionListener(e -> dialog.setVisible(false));
            dialog.setVisible(true);
        }
        catch (Exception e2) {
            ClientUtils.showErrorMessageDialog(e2);
        }
    }

    private void buildTree(DefaultMutableTreeNode treeNode, JSONObject jsonObject) {
        JSONArray array = jsonObject.optJSONArray("children");
        if (array != null && !array.isEmpty()) {
            for (int i = 0; i < array.length(); ++i) {
                JSONObject chJsonObject = array.getJSONObject(i);
                ProductOrderData productOrderData = new ProductOrderData();
                productOrderData.id = chJsonObject.getInt("id");
                productOrderData.title = chJsonObject.getString("title");
                productOrderData.type = chJsonObject.optInt("productTypeId", 1);
                DefaultMutableTreeNode chTreeNode = new DefaultMutableTreeNode(productOrderData);
                treeNode.add(chTreeNode);
                this.buildTree(chTreeNode, chJsonObject);
            }
        }
    }

    class ProductOrderData
    implements Transferable {
        int id;
        int type;
        String title;

        ProductOrderData() {
        }

        public String toString() {
            return this.title;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return ProductSpecPanel.this.dataFlavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor != null && flavor.equals(ProductSpecPanel.this.dataFlavors[0]);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this;
        }
    }

    class ProductSpecTreeTableModel
    extends BGTreeTableModel<ProductSpec> {
        public ProductSpecTreeTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", ProductSpec.class, false);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, 100, -1, "comment", false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440", 100, 150, 200, "identifier", false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumnId(false);
        }

        @Override
        public Object getValue(ProductSpec val, int column) throws BGException {
            Object value = null;
            switch (column) {
                case 0: {
                    if (val == this.root) {
                        value = "\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b";
                        break;
                    }
                    value = val.getTitle();
                    break;
                }
                default: {
                    value = super.getValue(val, column);
                }
            }
            return value;
        }

        @Override
        public Icon getIcon(ProductSpec value) {
            if (value == this.root) {
                return ProductSpecPanel.this.iconRoot;
            }
            if (this.isLeaf(value)) {
                return ProductSpecPanel.this.iconLeaf;
            }
            return ProductSpecPanel.this.iconNode;
        }
    }

    class ProductTreeCellRender
    extends DefaultTreeCellRenderer {
        ProductTreeCellRender() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object userObject;
            Component component = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof ProductOrderData) {
                if (((ProductOrderData)userObject).id == 0) {
                    this.setIcon(ProductSpecPanel.this.iconRoot);
                } else if (((ProductOrderData)userObject).type == 0) {
                    this.setIcon(ProductSpecPanel.this.iconFolder);
                } else if (leaf) {
                    this.setIcon(ProductSpecPanel.this.iconLeaf);
                } else {
                    this.setIcon(ProductSpecPanel.this.iconNode);
                }
            }
            return component;
        }
    }

    class TreeTransferHandler
    extends TransferHandler {
        TreeTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent component) {
            Transferable transferable = null;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)((JTree)component).getLastSelectedPathComponent();
            if (node.getUserObject() instanceof Transferable) {
                transferable = (Transferable)node.getUserObject();
            }
            return transferable;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            Object transferData = null;
            try {
                transferData = transferSupport.getTransferable().getTransferData(ProductSpecPanel.this.dataFlavors[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (transferData == null) {
                return false;
            }
            final JTree tree = (JTree)transferSupport.getComponent();
            final DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
            int srcId = ((ProductOrderData)transferData).id;
            DefaultMutableTreeNode moveNode = this.getNode(rootNode, srcId);
            JTree.DropLocation dropLocation = (JTree.DropLocation)transferSupport.getDropLocation();
            final TreePath treePath = dropLocation.getPath();
            DefaultMutableTreeNode last = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            int childIndex = dropLocation.getChildIndex();
            try {
                ProductSpecPanel.this.getProductService().productTreeReorder(srcId, ((ProductOrderData)last.getUserObject()).id, childIndex);
                if (childIndex == -1) {
                    treeModel.removeNodeFromParent(moveNode);
                    last.add(moveNode);
                } else if (moveNode.getParent() == last) {
                    int srcIndex = treeModel.getIndexOfChild(moveNode.getParent(), moveNode);
                    treeModel.removeNodeFromParent(moveNode);
                    last.insert(moveNode, childIndex - (srcIndex < childIndex ? 1 : 0));
                } else {
                    last.insert(moveNode, childIndex);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        treeModel.reload();
                        tree.expandPath(treePath);
                        ProductSpecPanel.this.performAction("refresh");
                    }
                });
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog(e);
            }
            return true;
        }

        private DefaultMutableTreeNode getNode(DefaultMutableTreeNode currentNode, int deviceId) {
            ProductOrderData productOrderData = (ProductOrderData)currentNode.getUserObject();
            if (productOrderData.id == deviceId) {
                return currentNode;
            }
            Enumeration<TreeNode> enumeration = currentNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
                DefaultMutableTreeNode resultNode = this.getNode(node, deviceId);
                if (resultNode == null) continue;
                return resultNode;
            }
            return null;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            Object transferData = null;
            try {
                transferData = transferSupport.getTransferable().getTransferData(ProductSpecPanel.this.dataFlavors[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (transferData == null) {
                return false;
            }
            int srcId = ((ProductOrderData)transferData).id;
            JTree.DropLocation dropLocation = (JTree.DropLocation)transferSupport.getDropLocation();
            TreePath treePath = dropLocation.getPath();
            for (Object object : treePath.getPath()) {
                Object userObject = ((DefaultMutableTreeNode)object).getUserObject();
                int dstId = ((ProductOrderData)userObject).id;
                if (srcId != dstId) continue;
                return false;
            }
            return true;
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
        }
    }
}

