/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.client.device;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.oss.kernel.entity.client.EntityAttributesForm;
import ru.bitel.oss.systems.inventory.resource.client.device.DeviceFormMain;
import ru.bitel.oss.systems.inventory.resource.client.device.DevicePanel;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceType;

class DeviceForm<D extends Device<D, T>, T extends DeviceType>
extends BGUPanel {
    private final DevicePanel<D, T> devicePanel;
    private JTabbedPane pane;
    private List<BGUPanel> panels;
    private AtomicReference<D> currentRef = new AtomicReference();

    public DeviceForm(DevicePanel<D, T> devicePanel, ClientContext context) {
        super((LayoutManager)new BorderLayout(), context);
        this.devicePanel = devicePanel;
        this.setName("deviceForm");
    }

    @Override
    protected void jbInit() {
        BGSwingUtilites.wrapBorder(this, " \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 ");
        this.pane = new JTabbedPane();
        this.panels = new ArrayList<BGUPanel>();
        this.addTab("\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435", this.devicePanel.newMainForm(this.currentRef));
        this.addTab("\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044b", new EntityAttributesForm(this.currentRef, (ClientContext)this.getContext()));
        this.devicePanel.addFormTabs(this.pane, this.panels, this.currentRef);
        this.add((Component)this.pane, "Center");
    }

    private void addTab(String title, BGUPanel panel) {
        this.panels.add(panel);
        this.pane.addTab(title, panel);
        this.pane.setMnemonicAt(this.pane.getComponentCount() - 1, 48 + this.pane.getComponentCount());
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionNew(e -> {
            if (this.isShowing()) {
                ClientUtils.showErrorMessageDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442.");
                return;
            }
            this.currentRef.set(this.devicePanel.newDevice());
            for (BGUPanel panel : this.panels) {
                panel.performAction("new");
            }
            this.pane.setSelectedIndex(0);
            this.performActionOpen();
        });
        new AbstractBGUPanel.BGActionEdit(e -> {
            if (this.isShowing()) {
                ClientUtils.showErrorMessageDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442.");
                return;
            }
            if (this.devicePanel.model.getSelectedRow() != this.devicePanel.model.getRoot()) {
                Object selected = (Device)this.devicePanel.model.getSelectedRow();
                if (selected == null) {
                    return;
                }
                selected = this.devicePanel.deviceGet(selected.getId());
                this.currentRef.set(selected);
                for (BGUPanel panel : this.panels) {
                    panel.performAction("edit");
                }
                this.pane.setSelectedIndex(0);
                this.performActionOpen();
            }
        });
        new AbstractBGUPanel.BGActionDelete(e -> {
            if (!this.isEnabled()) {
                ClientUtils.showErrorMessageDialog("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430.");
                return;
            }
            Device selected = (Device)this.devicePanel.model.getSelectedRow();
            if (selected == null || selected == this.devicePanel.model.getRoot()) {
                ClientUtils.showMessageDialog("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e");
                return;
            }
            if (selected.getChildren() != null) {
                ClientUtils.showMessageDialog("\u0421\u043d\u0430\u0447\u0430\u043b\u0430 \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430");
                return;
            }
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0) == 0) {
                this.devicePanel.deviceDelete(selected.getId());
                this.devicePanel.model.setSelectedRow(selected.getParentId());
                this.devicePanel.performAction("refresh");
            }
        });
        new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                DeviceType type = null;
                for (BGUPanel panel : DeviceForm.this.panels) {
                    if (panel instanceof DeviceFormMain) {
                        type = ((DeviceFormMain)panel).getSelectedDeviceType();
                    }
                    if (panel.performAction("ok")) continue;
                    return;
                }
                Device device = (Device)DeviceForm.this.currentRef.get();
                device.setTitle(Device.generateTitle((Device)device, type));
                int id = DeviceForm.this.devicePanel.deviceUpdate(device);
                DeviceForm.this.devicePanel.performAction("refresh");
                DeviceForm.this.devicePanel.model.setSelectedRow(id);
                DeviceForm.this.performActionClose();
            }
        };
    }
}

