/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import ru.bitel.common.DateTimeUtils;
import ru.bitel.common.Utils;

public abstract class ParameterMap {
    private transient List<ActionListener> actionListeners;
    protected String mapPrint = null;
    private static final Pattern patternDot = Pattern.compile("\\.");
    private static final Pattern patternDot2 = Pattern.compile("(?<!\\\\)\\.");
    private static final Comparator<Map.Entry<String, String>> comparator = new Comparator<Map.Entry<String, String>>(){

        @Override
        public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    };

    public void addActionListener(ActionListener al) {
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList<ActionListener>();
        }
        this.actionListeners.add(al);
    }

    protected void throwActionEvent(ActionEvent e) {
        if (this.actionListeners != null) {
            for (ActionListener al : this.actionListeners) {
                al.actionPerformed(e);
            }
        }
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public abstract String get(String var1, String var2);

    public int getInt(String key, int def) {
        try {
            String value = this.get(key, null);
            if (Utils.isEmptyString(value)) {
                return def;
            }
            return Integer.parseInt(value.trim());
        }
        catch (Exception ex) {
            return def;
        }
    }

    public float getFloat(String key, float def) {
        try {
            String value = this.get(key, null);
            if (Utils.isEmptyString(value)) {
                return def;
            }
            return Float.parseFloat(value.trim());
        }
        catch (Exception ex) {
            return def;
        }
    }

    public long getLong(String key, long def) {
        try {
            String value = this.get(key, null);
            if (Utils.isEmptyString(value)) {
                return def;
            }
            return Long.parseLong(value.trim());
        }
        catch (Exception ex) {
            return def;
        }
    }

    public double getDouble(String key, double def) {
        try {
            String value = this.get(key, null);
            if (Utils.isEmptyString(value)) {
                return def;
            }
            return Double.parseDouble(value.trim());
        }
        catch (Exception ex) {
            return def;
        }
    }

    public BigDecimal getBigDecimal(String key, BigDecimal def) {
        BigDecimal result = def;
        try {
            String value = this.get(key, null);
            result = Utils.isEmptyString(value) ? def : new BigDecimal(value.trim().replace(',', '.'));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean getBoolean(String key, boolean def) {
        try {
            String value = this.get(key, null);
            if (Utils.isEmptyString(value)) {
                return def;
            }
            return Utils.parseBoolean(value.trim(), def);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public char getChar(String key, char def) {
        try {
            String value = this.get(key, null);
            if (Utils.isEmptyString(value)) {
                return def;
            }
            return value.charAt(0);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public LocalDate getLocalDate(String key, LocalDate def) {
        try {
            String value = this.get(key, null);
            if (Utils.isEmptyString(value)) {
                return def;
            }
            return DateTimeUtils.parseLocalDate(value, "dd.MM.yyyy");
        }
        catch (Exception ex) {
            return def;
        }
    }

    public <T extends Enum<T>> T getEnum(Class<T> enumType, String key, T def) {
        try {
            String value = this.get(key, null);
            if (Utils.isEmptyString(value)) {
                return def;
            }
            return Utils.parseEnum(enumType, value.trim(), def);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public List<Integer> getIntegerList(String key, List<Integer> defList) {
        List<Integer> list = null;
        String str = this.get(key, null);
        list = str == null ? defList : Utils.toIntegerList(str);
        return list;
    }

    public abstract Set<Map.Entry<String, String>> entrySet();

    protected void extract(Map<String, String> data) {
        for (Map.Entry<String, String> e : this.entrySet()) {
            data.put(e.getKey(), e.getValue());
        }
    }

    public Map<String, String> getMap() {
        return this.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public String fingerprint() {
        throw new UnsupportedOperationException();
    }

    public ParameterMap sub(String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> e : this.entrySet()) {
            String paramKey = e.getKey();
            if (!paramKey.startsWith(prefix)) continue;
            String suffix = paramKey.substring(prefix.length(), paramKey.length());
            result.put(suffix, e.getValue());
        }
        return new DefaultParameterMap(result);
    }

    public ParameterMap filter(String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> e : this.entrySet()) {
            String paramKey = e.getKey();
            if (!paramKey.startsWith(prefix)) continue;
            result.put(paramKey, e.getValue());
        }
        return new DefaultParameterMap(result);
    }

    public SortedMap<Integer, ParameterMap> subIndexed(String prefix) {
        TreeMap<Integer, ParameterMap> result = new TreeMap<Integer, ParameterMap>();
        HashMap<Integer, HashMap<String, String>> resultMap = new HashMap<Integer, HashMap<String, String>>();
        for (Map.Entry<String, String> e : this.entrySet()) {
            String paramKey = e.getKey();
            if (!paramKey.startsWith(prefix)) continue;
            String suffix = paramKey.substring(prefix.length(), paramKey.length());
            String[] pref = patternDot.split(suffix, 2);
            Integer id = Utils.parseInt(pref[0]);
            HashMap<String, String> map = (HashMap<String, String>)resultMap.get(id);
            if (map == null) {
                map = new HashMap<String, String>();
                resultMap.put(id, map);
                result.put(id, new DefaultParameterMap(map));
            }
            if (pref.length == 2) {
                map.put(pref[1], e.getValue());
                continue;
            }
            map.put("", e.getValue());
        }
        return result;
    }

    public Map<String, ParameterMap> subKeyed(String prefix) {
        HashMap<String, ParameterMap> result = new HashMap<String, ParameterMap>();
        HashMap<String, HashMap<String, String>> resultMap = new HashMap<String, HashMap<String, String>>();
        for (Map.Entry<String, String> e : this.entrySet()) {
            String paramKey = e.getKey();
            if (!paramKey.startsWith(prefix)) continue;
            String suffix = paramKey.substring(prefix.length(), paramKey.length());
            String[] pref = patternDot2.split(suffix, 2);
            pref[0] = pref[0].replace("\\.", ".");
            HashMap<String, String> map = (HashMap<String, String>)resultMap.get(pref[0]);
            if (map == null) {
                map = new HashMap<String, String>();
                resultMap.put(pref[0], map);
                result.put(pref[0], new DefaultParameterMap(map));
            }
            if (pref.length == 2) {
                map.put(pref[1], e.getValue());
                continue;
            }
            map.put("", e.getValue());
        }
        return result;
    }

    public void toReference(Reference ref) {
        for (Map.Entry<String, String> e : this.entrySet()) {
            ref.add(new StringRefAddr(e.getKey(), e.getValue()));
        }
    }

    public ParameterMap inherit(final ParameterMap parameterMap) {
        return new ParameterMap(){

            @Override
            protected void extract(Map<String, String> data) {
                ParameterMap.this.extract(data);
                parameterMap.extract(data);
            }

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                HashMap<String, String> data = new HashMap<String, String>();
                this.extract(data);
                return data.entrySet();
            }

            @Override
            public String get(String key, String def) {
                String result = parameterMap.get(key, null);
                if (result != null) {
                    return result;
                }
                return ParameterMap.this.get(key, def);
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>(this.entrySet());
        Collections.sort(list, comparator);
        for (Map.Entry entry : list) {
            sb.append((String)entry.getKey()).append('=').append((String)entry.getValue()).append('\n');
        }
        return sb.toString();
    }

    public ParameterMap subLined(String key, String defValue) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String str = this.get(key, defValue);
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, ";");
            while (st.hasMoreTokens()) {
                String[] module_title = st.nextToken().split(":");
                if (module_title.length != 2) continue;
                result.put(module_title[0], module_title[1]);
            }
        }
        return new DefaultParameterMap(result);
    }

    public static class DefaultParameterMap
    extends ParameterMap {
        protected Map<String, String> data;

        public DefaultParameterMap(Map<String, String> data) {
            this.data = data;
        }

        @Override
        public String get(String key, String def) {
            String result = this.data.get(key);
            return result != null ? result : def;
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.data.entrySet();
        }

        @Override
        protected void extract(Map<String, String> data) {
            data.putAll(this.data);
        }
    }
}

