/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common;

import jakarta.activation.DataSource;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import ru.bitel.common.Utils;
import ru.bitel.common.io.IOUtils;

public class ZipUtils {
    private ZipInputStream _zis;

    public ZipUtils(InputStream is) {
        try {
            this._zis = new ZipInputStream(is);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public byte[] getEntry(String entryName) {
        ZipEntry ze = null;
        byte[] result = null;
        if (this._zis != null) {
            try {
                while ((ze = this._zis.getNextEntry()) != null) {
                    if (entryName != null && !ze.getName().equals(entryName)) continue;
                    result = Utils.readByBlock(this._zis);
                    break;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static String doZip(Map<String, byte[]> map, String folderPath, String patternTitle) throws IOException {
        String filePath = folderPath + File.separator + patternTitle;
        File file = new File(filePath);
        file.createNewFile();
        FileOutputStream dest = new FileOutputStream(file);
        ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(dest));
        zipOut.closeEntry();
        for (String key : map.keySet()) {
            ZipEntry zipEntry = new ZipEntry(key);
            zipOut.putNextEntry(zipEntry);
            byte[] b = map.get(key);
            zipOut.write(b, 0, b.length);
            zipOut.closeEntry();
        }
        zipOut.flush();
        zipOut.close();
        return filePath;
    }

    public static Map<String, byte[]> unZip(String filePath) throws IOException {
        return ZipUtils.unZip(new File(filePath));
    }

    public static Map<String, byte[]> unZip(File file) throws IOException {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            result.put(zipEntry.getName(), Utils.readByBlock(zipFile.getInputStream(zipEntry)));
        }
        return result;
    }

    public static DataSource zippedDataSources(final List<DataSource> dataSources) {
        return new DataSource(){

            public InputStream getInputStream() throws IOException {
                File temp = File.createTempFile("bgzip", ".zip");
                temp.deleteOnExit();
                try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(temp));){
                    zos.setLevel(1);
                    for (DataSource ds : dataSources) {
                        zos.putNextEntry(new ZipEntry(ds.getName()));
                        IOUtils.transfer(ds.getInputStream(), zos, 10240);
                        zos.closeEntry();
                    }
                }
                return new FileInputStream(temp);
            }

            public OutputStream getOutputStream() throws IOException {
                return null;
            }

            public String getContentType() {
                return "application/zip";
            }

            public String getName() {
                return dataSources.size() + "files" + System.currentTimeMillis() + ".zip";
            }
        };
    }
}

