/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.io;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.ref.ConcurrentWeakHashMap;

public class BinaryValueExtractor {
    private static final Logger logger = LogManager.getLogger();
    private static final ConcurrentWeakHashMap<String, Pattern> patternCache = new ConcurrentWeakHashMap();
    private final Entry[] entries;

    private BinaryValueExtractor(Entry[] entries) {
        this.entries = entries;
    }

    public <V> V extract(byte[] bytes, Function<String, V> binaryConverter, Function<String, V> stringConverter) {
        String hex = null;
        String string = null;
        for (int i = 0; i < this.entries.length; ++i) {
            Matcher m;
            String s;
            Entry e = this.entries[i];
            if (e.hex != null) {
                if (hex == null) {
                    hex = Utils.bytesToString(bytes, false, null);
                }
                s = hex;
                if (!".*".equals(e.hex.pattern())) {
                    m = e.hex.matcher(s);
                    if (!m.find()) continue;
                    s = m.groupCount() > 0 ? m.group(1) : m.group();
                }
            } else {
                s = null;
            }
            if (e.string != null) {
                if (s == null) {
                    if (string == null) {
                        string = new String(bytes, StandardCharsets.UTF_8);
                    }
                    s = string;
                } else {
                    byte[] bytes2 = Utils.stringToBytes(s, null);
                    s = new String(bytes2, StandardCharsets.UTF_8);
                }
                if (!".*".equals(e.string.pattern())) {
                    m = e.string.matcher(s);
                    if (!m.find()) continue;
                    s = m.groupCount() > 0 ? m.group(1) : m.group();
                    return stringConverter.apply(s);
                }
                return stringConverter.apply(s);
            }
            assert (s != null);
            if (s == null) continue;
            return binaryConverter.apply(s);
        }
        return null;
    }

    public String extractString(byte[] bytes, String def) {
        String result = this.extract(bytes, b -> b, s -> s);
        if (result != null) {
            return result;
        }
        return def;
    }

    public int extractInt(byte[] bytes, int def) {
        Integer result = this.extract(bytes, this::parseInt, s -> Utils.parseInt(s, -1));
        if (result != null) {
            return result;
        }
        return def;
    }

    private int parseInt(String bytes) {
        return Utils.bytesToInt(Utils.stringToBytes(bytes, null));
    }

    public long extractLong(byte[] bytes, long def) {
        Long result = this.extract(bytes, this::parseLong, s -> Utils.parseLong(s, -1L));
        if (result != null) {
            return result;
        }
        return def;
    }

    private long parseLong(String bytes) {
        return Utils.bytesToLong(Utils.stringToBytes(bytes, null));
    }

    public static BinaryValueExtractor newInstance(ParameterMap params, String prefix) {
        ArrayList<Entry> list = new ArrayList<Entry>();
        String hex = params.get(prefix + "hex", null);
        String string = params.get(prefix + "string", null);
        if (hex != null || string != null) {
            BinaryValueExtractor.newEntry(list, prefix, null, hex, string);
        }
        if (params.get(prefix + "1.hex", null) != null || params.get(prefix + "1.string", null) != null) {
            for (Map.Entry<Integer, ParameterMap> e : params.subIndexed(prefix).entrySet()) {
                ParameterMap p = e.getValue();
                String hex2 = p.get("hex", null);
                String string2 = p.get("string", null);
                BinaryValueExtractor.newEntry(list, prefix, e.getKey(), hex2, string2);
            }
        }
        if (list.size() > 0) {
            return new BinaryValueExtractor(list.toArray(new Entry[list.size()]));
        }
        return null;
    }

    private static void newEntry(List<Entry> list, String prefix, Object key, String hex, String string) {
        Pattern hexPattern = null;
        Pattern stringPattern = null;
        if (hex != null) {
            try {
                hexPattern = patternCache.computeIfAbsent(hex, a -> Pattern.compile(hex, 2));
            }
            catch (Exception ex) {
                logger.error("Error parsing regex: " + hex + " on entry " + prefix + (String)(key != null ? " " + key : "") + ".hex. " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (string != null) {
            try {
                stringPattern = patternCache.computeIfAbsent(string, a -> Pattern.compile(string, 2));
            }
            catch (Exception ex) {
                logger.error("Error parsing regex: " + hex + " on entry " + prefix + (String)(key != null ? " " + key : "") + ".string. " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (hexPattern != null || stringPattern != null) {
            list.add(new Entry(hexPattern, stringPattern));
        }
    }

    public static int convertToInt(Object value, int def) {
        if (value == null) {
            return def;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Long) {
            return (int)((Long)value & 0xFFFFFFFFL);
        }
        if (value instanceof String) {
            return Utils.parseInt((String)value, def);
        }
        if (value instanceof byte[]) {
            byte[] data = (byte[])value;
            return Utils.bytesToInt(data, 0, data.length);
        }
        if (value instanceof ByteBuffer) {
            byte[] data = Utils.byteBufferAsArray((ByteBuffer)value);
            return Utils.bytesToInt(data, 0, data.length);
        }
        return def;
    }

    public static byte[] convertToBytes(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof byte[]) {
            return (byte[])data;
        }
        if (data instanceof ByteBuffer) {
            return Utils.byteBufferAsArray((ByteBuffer)data);
        }
        if (data instanceof String) {
            return Utils.stringToBytes((String)data, null);
        }
        return null;
    }

    private static class Entry {
        private final Pattern hex;
        private final Pattern string;

        public Entry(Pattern hex, Pattern string) {
            this.hex = hex;
            this.string = string;
        }
    }

    public static class BinaryValueExtractorFactory {
        private static final BinaryValueExtractor EMPTY = new BinaryValueExtractor(new Entry[0]);
        private final ConcurrentWeakHashMap<ParameterMap, ConcurrentWeakHashMap<String, BinaryValueExtractor>> cache = new ConcurrentWeakHashMap();

        public BinaryValueExtractor getExtractor(ParameterMap params, String prefix) {
            BinaryValueExtractor result = this.cache.computeIfAbsent(params, a -> new ConcurrentWeakHashMap(8)).computeIfAbsent(prefix, a -> {
                BinaryValueExtractor n = BinaryValueExtractor.newInstance(params, prefix);
                return n != null ? n : EMPTY;
            });
            return result != EMPTY ? result : null;
        }
    }
}

