/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.xml;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.LocalDate;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import ru.bitel.common.model.KeyValue;
import ru.bitel.common.xml.XmlAdapters;

public class MapAdapters {

    @XmlSeeAlso(value={MapWrapper.class, XmlAdapters.CollectionWrapper.class, Entry.class, MapEntry.class, KeyValue.class, SortedMapWrapper.class, LinkedMapWrapper.class, XmlAdapters.LocalDateWrapper.class})
    public static class MapAdapter<K, V>
    extends XmlAdapter<MapWrapper, Map<K, V>> {
        public final MapWrapper marshal(Map<K, V> v) throws Exception {
            if (v == null) {
                return null;
            }
            return (MapWrapper)this.marshalObject(v);
        }

        public final Map<K, V> unmarshal(MapWrapper value) throws Exception {
            if (value == null) {
                return null;
            }
            return (Map)this.unmarshalObject(value);
        }

        protected Entry newEntry(K key, Object value) {
            return new Entry(key, value);
        }

        protected Object marshalObject(Object value) {
            if (value instanceof Map) {
                ArrayList<Entry> item = new ArrayList<Entry>();
                for (Map.Entry e : ((Map)value).entrySet()) {
                    item.add(this.newEntry(e.getKey(), this.marshalObject(e.getValue())));
                }
                value = value instanceof SortedMap ? new SortedMapWrapper(item) : (value instanceof LinkedHashMap ? new LinkedMapWrapper(item) : new MapWrapper(item));
            } else if (value instanceof List) {
                XmlAdapters.ListWrapper list = new XmlAdapters.ListWrapper();
                list.item = (List)value;
                value = list;
            } else if (value instanceof Collection) {
                XmlAdapters.CollectionWrapper list = new XmlAdapters.CollectionWrapper();
                list.item = (Collection)value;
                value = list;
            } else if (value instanceof LocalDate) {
                XmlAdapters.LocalDateWrapper list = new XmlAdapters.LocalDateWrapper();
                list.item = (LocalDate)value;
                value = list;
            }
            return value;
        }

        protected Object unmarshalObject(Object value) {
            if (value instanceof MapWrapper) {
                AbstractMap result = value instanceof SortedMapWrapper ? new TreeMap() : (value instanceof LinkedMapWrapper ? new LinkedHashMap() : new HashMap());
                MapWrapper mapWrapper = (MapWrapper)((Object)value);
                if (mapWrapper.entry != null) {
                    int size = mapWrapper.entry.size();
                    for (int i = 0; i < size; ++i) {
                        Entry e = mapWrapper.entry.get(i);
                        result.put(e.key, this.unmarshalObject(e.value));
                    }
                }
                value = result;
            } else if (value instanceof XmlAdapters.ListWrapper) {
                value = ((XmlAdapters.ListWrapper)((Object)value)).item;
            } else if (value instanceof XmlAdapters.CollectionWrapper) {
                value = ((XmlAdapters.CollectionWrapper)((Object)value)).item;
            } else if (value instanceof XmlAdapters.LocalDateWrapper) {
                value = ((XmlAdapters.LocalDateWrapper)((Object)value)).item;
            }
            return value;
        }
    }

    @XmlSeeAlso(value={MapWrapper.class, XmlAdapters.CollectionWrapper.class, Entry.class, MapEntry.class, KeyValue.class, SortedMapWrapper.class, LinkedMapWrapper.class, XmlAdapters.LocalDateWrapper.class})
    public static class StringMapAdapter
    extends AbstractMapAdapter<String, Object, XmlAdapters.ListWrapper<MapEntry>, MapEntry> {
        @Override
        protected MapEntry newEntry(String key, Object value) {
            return new MapEntry(key, value);
        }

        @Override
        protected XmlAdapters.ListWrapper<MapEntry> newWrapper(List<MapEntry> item) {
            return new XmlAdapters.ListWrapper<MapEntry>(item);
        }
    }

    static class MapEntry
    extends AbstractMapEntry<String> {
        @XmlAttribute
        public String key;
        public Object value;

        public MapEntry() {
        }

        public MapEntry(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        @XmlTransient
        public String getKey() {
            return this.key;
        }

        @Override
        @XmlTransient
        public Object getValue() {
            return this.value;
        }
    }

    static abstract class AbstractMapAdapter<K, V, W extends XmlAdapters.ListHolder<?>, E extends AbstractMapEntry<K>>
    extends XmlAdapter<W, Map<K, V>> {
        AbstractMapAdapter() {
        }

        protected abstract E newEntry(K var1, Object var2);

        protected abstract W newWrapper(List<E> var1);

        protected Map<K, V> newMap() {
            return new HashMap();
        }

        public final W marshal(Map<K, V> v) throws Exception {
            if (v == null) {
                return null;
            }
            ArrayList<E> item = new ArrayList<E>();
            for (Map.Entry<K, V> e : v.entrySet()) {
                item.add(this.newEntry(e.getKey(), this.marshalObject(e.getValue())));
            }
            return this.newWrapper(item);
        }

        public final Map<K, V> unmarshal(W value) throws Exception {
            if (value == null) {
                return null;
            }
            Map result = this.newMap();
            List list = value.getList();
            if (list != null) {
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    AbstractMapEntry e = (AbstractMapEntry)list.get(i);
                    result.put(e.getKey(), this.unmarshalObject(e.getValue()));
                }
            }
            return result;
        }

        protected Object marshalObject(Object value) {
            if (value instanceof List) {
                XmlAdapters.ListWrapper list = new XmlAdapters.ListWrapper();
                list.item = (List)value;
                value = list;
            } else if (value instanceof Collection) {
                XmlAdapters.CollectionWrapper list = new XmlAdapters.CollectionWrapper();
                list.item = (Collection)value;
                value = list;
            } else if (value instanceof LocalDate) {
                XmlAdapters.LocalDateWrapper list = new XmlAdapters.LocalDateWrapper();
                list.item = (LocalDate)value;
                value = list;
            }
            return value;
        }

        protected Object unmarshalObject(Object value) {
            if (value instanceof XmlAdapters.ListWrapper) {
                value = ((XmlAdapters.ListWrapper)value).item;
            } else if (value instanceof XmlAdapters.CollectionWrapper) {
                value = ((XmlAdapters.CollectionWrapper)value).item;
            } else if (value instanceof XmlAdapters.LocalDateWrapper) {
                value = ((XmlAdapters.LocalDateWrapper)value).item;
            }
            return value;
        }
    }

    @XmlSeeAlso(value={MapWrapper.class, SortedMapWrapper.class, LinkedMapWrapper.class, XmlAdapters.ListWrapper.class, XmlAdapters.CollectionWrapper.class, Entry.class, MapEntry.class, XmlAdapters.LocalDateWrapper.class})
    static final class Entry
    extends AbstractMapEntry<Object> {
        @XmlElement
        public Object key;
        @XmlElement
        public Object value;

        public Entry() {
        }

        public Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        @XmlTransient
        public Object getKey() {
            return this.key;
        }

        @Override
        @XmlTransient
        public Object getValue() {
            return this.value;
        }
    }

    @XmlSeeAlso(value={MapWrapper.class, SortedMapWrapper.class, LinkedMapWrapper.class, XmlAdapters.ListWrapper.class, XmlAdapters.CollectionWrapper.class, Entry.class, MapEntry.class, XmlAdapters.LocalDateWrapper.class})
    static abstract class AbstractMapEntry<K> {
        AbstractMapEntry() {
        }

        @XmlTransient
        public abstract K getKey();

        @XmlTransient
        public abstract Object getValue();
    }

    @XmlType(name="linkedMap")
    @XmlSeeAlso(value={MapWrapper.class, SortedMapWrapper.class, LinkedMapWrapper.class, XmlAdapters.ListWrapper.class, XmlAdapters.CollectionWrapper.class, Entry.class, MapEntry.class, XmlAdapters.LocalDateWrapper.class})
    static final class LinkedMapWrapper
    extends MapWrapper {
        public LinkedMapWrapper(List<Entry> entry) {
            super(entry);
        }

        public LinkedMapWrapper() {
        }
    }

    @XmlType(name="sortedMap")
    @XmlSeeAlso(value={MapWrapper.class, SortedMapWrapper.class, LinkedMapWrapper.class, XmlAdapters.ListWrapper.class, XmlAdapters.CollectionWrapper.class, Entry.class, MapEntry.class, XmlAdapters.LocalDateWrapper.class})
    static final class SortedMapWrapper
    extends MapWrapper {
        public SortedMapWrapper(List<Entry> entry) {
            super(entry);
        }

        public SortedMapWrapper() {
        }
    }

    @XmlType(name="map")
    @XmlSeeAlso(value={MapWrapper.class, SortedMapWrapper.class, LinkedMapWrapper.class, XmlAdapters.ListWrapper.class, XmlAdapters.CollectionWrapper.class, Entry.class, MapEntry.class, XmlAdapters.LocalDateWrapper.class})
    static class MapWrapper
    implements XmlAdapters.ListHolder<Entry> {
        public List<Entry> entry;

        public MapWrapper(List<Entry> entry) {
            this.entry = entry;
        }

        public MapWrapper() {
        }

        @Override
        @XmlTransient
        public List<Entry> getList() {
            return this.entry;
        }

        public void setList(List<Entry> entry) {
            this.entry = entry;
        }
    }
}

